/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.analysis.entity.AnalysisEntityManager;
import kd.bos.workflow.analysis.entity.WorkflowAnalysisEntity;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;

public abstract class AbstractAnalysisEntityManagerImpl<T extends WorkflowAnalysisEntity>
extends AbstractEntityManager<T>
implements AnalysisEntityManager<T> {
    public AbstractAnalysisEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    protected void appendQueryFields(ReportQueryParam queryParam, StringBuilder sql) {
        int index = 1;
        Map<String, String> fieldsMap = this.getQueryFieldsMap(queryParam);
        int size = fieldsMap.size();
        for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
            this.appendField(sql, entry.getKey(), entry.getValue(), index++ == size);
        }
    }

    protected void appendField(StringBuilder sql, String queryField, String columnField) {
        this.appendField(sql, queryField, columnField, false);
    }

    protected void appendField(StringBuilder sql, String queryField, String columnField, boolean last) {
        sql.append(String.format("%s %s%s", queryField, columnField, last ? " " : ","));
    }

    protected void appendConditionAndParam(FilterInfo filterInfo, StringBuilder sql, String filterKey, String fieldKey, List<Object> params) {
        QFilter filter = this.getConditionFilter(filterInfo, filterKey);
        if (filter == null) {
            return;
        }
        this.appendConditionAndParam(filter, sql, fieldKey, params);
    }

    protected void appendConditionAndParam(QFilter filter, StringBuilder sql, String field, List<Object> params) {
        String key = String.format("T.%s", field);
        if ("IN".equalsIgnoreCase(filter.getCP())) {
            sql.append("AND ").append(new QFilter(key, filter.getCP(), filter.getValue()));
        } else {
            sql.append("AND ").append(key).append(" ").append(filter.getCP()).append(" ? ");
            params.add(filter.getValue());
        }
    }

    protected QFilter getConditionFilter(FilterInfo filterInfo, String filterKey) {
        if (filterInfo == null) {
            return null;
        }
        for (QFilter filter : filterInfo.getQFilters()) {
            String property = filter.getProperty();
            if (!property.startsWith(filterKey)) continue;
            return filter;
        }
        return null;
    }

    protected void appendFromJoinAndWhereSQL(StringBuilder sql, ReportQueryParam queryParam, List<Object> params) {
        sql.append(String.format("FROM %s T ", this.getTableName()));
        sql.append(String.format("LEFT JOIN %s TL ON T.FID = TL.FID AND TL.FLOCALEID = ? ", this.getMultiLangTableName()));
        sql.append("WHERE T.FPROCTYPE = ? ");
        params.add(RequestContext.get().getLang().toString());
        params.add(ModelType.AuditFlow.name());
        if (queryParam != null) {
            FilterInfo filterInfo = queryParam.getFilter();
            this.appendCommonConditionFilter(sql, filterInfo, params);
            this.appendParamsFilter(sql, queryParam, params);
        }
        sql.append(WorkflowAnalysisUtils.getOrgFilterSQL(String.format("T.%s", "FORGUNITID")));
        sql.append(" ");
    }

    protected boolean appendOrderBySQL(StringBuilder sql, ReportQueryParam queryParam) {
        if (queryParam == null) {
            return false;
        }
        String sortInfo = queryParam.getSortInfo();
        if (WfUtils.isNotEmpty((String)sortInfo) && !this.filterHeaderFilter(queryParam, sortInfo.substring(0, sortInfo.indexOf(32)))) {
            sql.append(String.format(" ORDER BY %s ", sortInfo));
            return true;
        }
        return false;
    }

    protected void appendHeaderFilter(StringBuilder sql, ReportQueryParam queryParam, List<Object> params) {
        this.appendHeaderFilter(sql, "", queryParam, params);
    }

    protected void appendHeaderFilter(StringBuilder sql, String topSql, ReportQueryParam queryParam, List<Object> params) {
        if (queryParam == null) {
            return;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo == null) {
            return;
        }
        List headFilters = filterInfo.getHeadFilters();
        if (WfUtils.isEmptyForCollection((Collection)headFilters)) {
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(headFilters.size());
        for (QFilter filter : headFilters) {
            if (this.filterHeaderFilter(queryParam, filter.getProperty())) continue;
            filters.add(filter);
        }
        if (filters.isEmpty()) {
            return;
        }
        int index = 1;
        Collection<String> columnFields = this.getQueryFieldsMap(queryParam).values();
        int size = columnFields.size();
        StringBuilder wrapSql = new StringBuilder("SELECT ").append(topSql);
        for (String columnField : columnFields) {
            wrapSql.append(columnField);
            if (index++ >= size) continue;
            wrapSql.append(',');
        }
        wrapSql.append(String.format(" FROM (%s) RES WHERE ", sql));
        sql.delete(0, sql.length());
        sql.append((CharSequence)wrapSql);
        for (int i = 0; i < filters.size(); ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            QFilter filter = (QFilter)filters.get(i);
            this.appendHeaderConditionAndParam(filter, sql, String.format("%s", filter.getProperty()), params);
        }
    }

    protected boolean filterHeaderFilter(ReportQueryParam queryParam, String property) {
        return false;
    }

    protected void appendHeaderConditionAndParam(QFilter filter, StringBuilder sql, String field, List<Object> params) {
        String key = String.format("RES.%s", field);
        if ("is null".equals(filter.getCP()) || "is not null".equals(filter.getCP())) {
            String condition = String.format("%s %s", key, filter.getCP());
            List filterNests = filter.getNests(false);
            sql.append("(").append(condition).append(this.getHeaderNullFilterNestSQL(key, filterNests, params)).append(")");
        } else {
            sql.append(String.format("%s %s ?", key, filter.getCP()));
            params.add(this.convertParam(field, filter.getValue()));
        }
    }

    protected String getHeaderNullFilterNestSQL(String key, List<QFilter.QFilterNest> filterNests, List<Object> params) {
        StringBuilder sql = new StringBuilder();
        if (filterNests == null) {
            return sql.toString();
        }
        for (QFilter.QFilterNest nest : filterNests) {
            QFilter nestFilter;
            if (nest == null || (nestFilter = nest.getFilter()) == null) continue;
            sql.append(String.format(" %s %s %s ?", nest.getOp(), key, nestFilter.getCP()));
            params.add(nestFilter.getValue());
        }
        return sql.toString();
    }

    protected Object convertParam(String field, Object param) {
        return param;
    }

    protected void appendParamsFilter(StringBuilder sql, ReportQueryParam queryParam, List<Object> params) {
        QFilter[] filters = (QFilter[])queryParam.getCustomParam().get("filters");
        if (filters != null) {
            for (QFilter filter : filters) {
                this.appendConditionAndParam(filter, sql, String.format("f%s", filter.getProperty()), params);
            }
        }
    }

    protected void appendCommonConditionFilter(StringBuilder sql, FilterInfo filterInfo, List<Object> params) {
        this.appendConditionAndParam(filterInfo, sql, "years", "FYEARS", params);
        this.appendConditionAndParam(filterInfo, sql, "entity", "FENTITYNUMBER", params);
        this.appendConditionAndParam(filterInfo, sql, "org", "FORGUNITID", params);
        this.appendConditionAndParam(filterInfo, sql, "process", "FPROCDEFID", params);
    }

    @Override
    public List<String> getAnalysisYears() {
        String table = this.getTableName();
        ArrayList<String> years = new ArrayList<String>(32);
        String sql = String.format("SELECT DISTINCT FYEARS FROM %s ORDER BY FYEARS DESC;", table);
        try (DataSet ds = DB.queryDataSet((String)"analysis.getAnalysisYears", (DBRoute)DBRoute.workflow, (String)sql);){
            for (Row row : ds) {
                years.add(row.getString("FYEARS"));
            }
        }
        return years;
    }

    @Override
    public Map<String, String> getAnalysisNodeInfo() {
        HashMap<String, String> nodeInfo = new HashMap<String, String>(64);
        String sql = String.format("SELECT DISTINCT T.FNODEID NODEID, TL.FNODENAME NODENAME FROM %s T LEFT JOIN %s TL ON T.FID = TL.FID AND TL.FLOCALEID = ?", this.getTableName(), this.getMultiLangTableName());
        try (DataSet ds = DB.queryDataSet((String)"analysis.getAnalysisNodeInfo", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{RequestContext.get().getLang().toString()});){
            for (Row row : ds) {
                String nodeId = row.getString("NODEID");
                String nodeName = row.getString("NODENAME");
                nodeInfo.put(nodeId, WfUtils.isEmpty((String)nodeName) ? nodeId : nodeName);
            }
        }
        return nodeInfo;
    }

    @Override
    public Map<String, String> getAnalysisNodeTypeInfo() {
        HashMap<String, String> nodeTypeInfo = new HashMap<String, String>(16);
        String sql = String.format("SELECT DISTINCT T.FNODETYPE NODETYPE FROM %s T ", this.getTableName());
        try (DataSet ds = DB.queryDataSet((String)"analysis.getAnalysisNodeTypeInfo", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[0]);){
            for (Row row : ds) {
                String nodeType = row.getString("NODETYPE");
                if (WfUtils.isEmpty((String)nodeType)) continue;
                nodeTypeInfo.put(nodeType, nodeType);
            }
        }
        int size = nodeTypeInfo.size();
        if (size < 1) {
            return nodeTypeInfo;
        }
        StringBuilder inStr = new StringBuilder("(?");
        for (int i = 1; i < size; ++i) {
            inStr.append(",?");
        }
        inStr.append(")");
        sql = String.format("SELECT N.FNUMBER NUMBER, NL.FNAME NAME FROM T_WF_NODETEMPLATE N LEFT JOIN T_WF_NODETEMPLATE_L NL ON N.FID = NL.FID AND NL.FLOCALEID = ? WHERE N.FNUMBER IN %s ORDER BY N.FID DESC ", inStr);
        ArrayList<String> params = new ArrayList<String>(size + 1);
        params.add(RequestContext.get().getLang().toString());
        params.addAll(nodeTypeInfo.keySet());
        try (DataSet ds = DB.queryDataSet((String)"analysis.getNodeTypeName", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            for (Row row : ds) {
                String number = row.getString("NUMBER");
                String name = row.getString("NAME");
                nodeTypeInfo.put(number, WfUtils.isEmpty((String)name) ? number : name);
            }
        }
        return nodeTypeInfo;
    }

    @Override
    public Set<Long> getProcessDefinitionIds(Map<String, Object> params) {
        HashSet<Long> ids = new HashSet<Long>();
        ArrayList<Object> queryParams = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append(String.format("SELECT DISTINCT T.FPROCDEFID PROCDEFID FROM %s T ", this.getTableName()));
        sql.append(String.format("LEFT JOIN %S TL ON T.FID = TL.FID AND TL.FLOCALEID = ? ", this.getMultiLangTableName()));
        sql.append("WHERE T.FPROCTYPE = ? ");
        sql.append(WorkflowAnalysisUtils.getOrgFilterSQL(String.format("T.%s", "FORGUNITID")));
        queryParams.add(RequestContext.get().getLang().toString());
        queryParams.add(ModelType.AuditFlow.name());
        this.appendFindProcDefIdSQLAndParam(params, sql, queryParams);
        try (DataSet ds = DB.queryDataSet((String)"analysis.getProcessDefinitionIds", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])queryParams.toArray());){
            for (Row row : ds) {
                ids.add(row.getLong("PROCDEFID"));
            }
        }
        return ids;
    }

    protected abstract Map<String, String> getQueryFieldsMap(ReportQueryParam var1);

    protected abstract void appendFindProcDefIdSQLAndParam(Map<String, Object> var1, StringBuilder var2, List<Object> var3);

    protected void appendFindProcDefIdSQLAndParam(StringBuilder sql, List<Object> queryParams, String field, Object value, boolean multiLangColumn) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            this.appendFindProcDefIdSQLAndCollectionParam(sql, field, (Collection)value);
        } else {
            this.appendFindProcDefIdSQLAndBasicParam(sql, queryParams, field, value, multiLangColumn);
        }
    }

    protected void appendFindProcDefIdSQLAndBasicParam(StringBuilder sql, List<Object> queryParams, String field, Object value, boolean multiLangColumn) {
        if (multiLangColumn) {
            String tlFieldColumn = String.format("TL.F%s", field);
            String tFieldColumn = String.format("T.F%s", field);
            sql.append(String.format("AND (case when (%s is null or %s = ' ') then %s else %s end) = ? ", tlFieldColumn, tlFieldColumn, tFieldColumn, tlFieldColumn));
        } else {
            sql.append(String.format("AND T.F%s = ? ", field));
        }
        queryParams.add(value);
    }

    protected void appendFindProcDefIdSQLAndCollectionParam(StringBuilder sql, String field, Collection<Object> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        int index = 0;
        int size = value.size();
        sql.append(String.format("AND T.F%s in (", field));
        for (Object val : value) {
            if (val instanceof Number) {
                sql.append(val);
            } else {
                sql.append("'").append(val).append("'");
            }
            if (index < size - 1) {
                sql.append(",");
            }
            ++index;
        }
        sql.append(") ");
    }

    protected int getTimeUnitMillisecond(ReportQueryParam queryParam) {
        if (null == queryParam) {
            return WorkflowAnalysisUtils.getTimeUnitMillisecond(this.getDefaultTimeUnit());
        }
        String timeUnit = (String)queryParam.getCustomParam().get("timeunit");
        if (timeUnit == null) {
            timeUnit = this.getDefaultTimeUnit();
        }
        return WorkflowAnalysisUtils.getTimeUnitMillisecond(timeUnit);
    }

    protected String getDefaultTimeUnit() {
        return "minute";
    }

    public String getMultiLangTableName() {
        return String.format("%s_L", this.getTableName());
    }

    protected boolean isEnableWorkCalendar() {
        return WorkflowAnalysisUtils.isEnableWorkCalendar();
    }

    protected String getTotalDurationField() {
        return WorkflowAnalysisUtils.getTotalDurationField();
    }

    public abstract String getTableName();
}

