/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.analysis.entity.AbstractAnalysisEntityManagerImpl;
import kd.bos.workflow.analysis.entity.NodeAnalysisEntity;
import kd.bos.workflow.analysis.entity.NodeAnalysisEntityImpl;
import kd.bos.workflow.analysis.entity.NodeAnalysisEntityManager;
import kd.bos.workflow.analysis.model.NodeAnalysisBarChartData;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;

public class NodeAnalysisEntityManagerImpl
extends AbstractAnalysisEntityManagerImpl<NodeAnalysisEntity>
implements NodeAnalysisEntityManager {
    public NodeAnalysisEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends NodeAnalysisEntity> getManagedEntityClass() {
        return NodeAnalysisEntityImpl.class;
    }

    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "id", "procdefid", "schemeid", "procnumber", "procname", "entitynumber", "entityname", "orgunitid", "nodeid", "nodename", "nodetype", "nodetypename", "years", "instancecount", "totalduration", "maxduration");
    }

    @Override
    public void clearByYears(String years) {
        QFilter[] filters = new QFilter[]{new QFilter("years", "=", (Object)years)};
        DeleteServiceHelper.delete((String)"wf_nodeanalysis", (QFilter[])filters);
    }

    @Override
    public List<NodeAnalysisBarChartData> getNodeAnalysisBarChartDatas(ReportQueryParam queryParam) {
        int limit = 20;
        ArrayList<NodeAnalysisBarChartData> datas = new ArrayList<NodeAnalysisBarChartData>(limit);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT TOP ").append(limit).append(" ");
        sql.append("T.FNODEID ").append("nodeid").append(", ");
        sql.append(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FPROCNAME", "procname")).append(" ").append("procname").append(", ");
        sql.append(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FNODENAME", "nodename")).append(" ").append("nodename").append(", ");
        sql.append(String.format("ROUND(SUM(T.%s)/SUM(T.FINSTANCECOUNT)/%s.0, 2) AVERAGEDURATION, ", this.getTotalDurationField(), this.getTimeUnitMillisecond(queryParam)));
        sql.append(String.format("ROUND(SUM(T.%s)/SUM(T.FINSTANCECOUNT)/1.0, 2) AVERAGEMILLISECOND ", this.getTotalDurationField()));
        this.appendFromJoinAndWhereSQL(sql, queryParam, params);
        sql.append("GROUP BY T.FNODEID, T.FPROCNAME, T.FNODENAME,TL.FPROCNAME, TL.FNODENAME ");
        sql.append("ORDER BY AVERAGEMILLISECOND DESC ");
        try (DataSet ds = DB.queryDataSet((String)WorkflowAnalysisUtils.createAlgoKey("node.queryNodeAnalysisBarChartDatas"), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            for (Row row : ds) {
                NodeAnalysisBarChartData data = new NodeAnalysisBarChartData();
                data.setProcName(row.getString("PROCNAME"));
                data.setNodeName(row.getString("NODENAME"));
                data.setNodeId(row.getString("NODEID"));
                data.setAverageDuration(row.getDouble("AVERAGEDURATION"));
                datas.add(data);
            }
        }
        return datas;
    }

    @Override
    public DataSet getAnalysisReportDataSet(ReportQueryParam queryParam) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT ");
        this.appendQueryFields(queryParam, sql);
        this.appendFromJoinAndWhereSQL(sql, queryParam, params);
        sql.append("GROUP BY T.FPROCNUMBER, T.FNODEID, T.FNODETYPE, T.FENTITYNUMBER, T.FENTITYNAME, T.FPROCNAME, T.FNODETYPENAME, T.FNODENAME, TL.FENTITYNAME, TL.FPROCNAME, TL.FNODETYPENAME, TL.FNODENAME ");
        this.appendHeaderFilter(sql, queryParam, params);
        this.appendOrderBySQL(sql, queryParam);
        return DB.queryDataSet((String)WorkflowAnalysisUtils.createAlgoKey("node.getAnalysisReportDatas"), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());
    }

    @Override
    protected void appendCommonConditionFilter(StringBuilder sql, FilterInfo filterInfo, List<Object> params) {
        super.appendCommonConditionFilter(sql, filterInfo, params);
        this.appendConditionAndParam(filterInfo, sql, "activitytype", "FNODETYPE", params);
    }

    @Override
    protected void appendFindProcDefIdSQLAndParam(Map<String, Object> params, StringBuilder sql, List<Object> queryParams) {
        String procName = (String)params.get("procname");
        String nodeId = (String)params.get("nodeid");
        String nodeName = (String)params.get("nodename");
        this.appendFindProcDefIdSQLAndParam(sql, queryParams, "procname", procName, true);
        this.appendFindProcDefIdSQLAndParam(sql, queryParams, "nodeid", nodeId, false);
        this.appendFindProcDefIdSQLAndParam(sql, queryParams, "nodename", nodeName, true);
    }

    @Override
    public String getTableName() {
        return "T_WF_NODEANALYSIS";
    }

    @Override
    protected Map<String, String> getQueryFieldsMap(ReportQueryParam queryParam) {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        fieldsMap.put("T.FPROCNUMBER", "procnumber");
        fieldsMap.put("T.FNODEID", "nodeid");
        fieldsMap.put("T.FNODETYPE", "nodetype");
        fieldsMap.put("T.FENTITYNUMBER", "entitynumber");
        fieldsMap.put(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FPROCNAME", "procname"), "procname");
        fieldsMap.put(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FENTITYNAME", "entityname"), "entityname");
        fieldsMap.put(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FNODENAME", "nodename"), "nodename");
        fieldsMap.put(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FNODETYPENAME", "nodetypename"), "nodetypename");
        fieldsMap.put("SUM(FINSTANCECOUNT)", "executecount");
        String durationField = this.getTotalDurationField();
        int millisecond = this.getTimeUnitMillisecond(queryParam);
        String totalDuration = String.format("ROUND(SUM(%s)/%s.0, 2)", durationField, millisecond);
        fieldsMap.put(totalDuration, "sumduration");
        String averageDuration = String.format("ROUND(SUM(%s)/SUM(FINSTANCECOUNT)/%s.0, 2)", durationField, millisecond);
        fieldsMap.put(averageDuration, "averageduration");
        String maxDuration = String.format("ROUND(MAX(%s)/%s.0, 2)", WorkflowAnalysisUtils.getMaxDurationField(), millisecond);
        fieldsMap.put(maxDuration, "maxduration");
        return fieldsMap;
    }

    @Override
    protected Object convertParam(String field, Object param) {
        switch (field) {
            case "executecount": {
                return Long.valueOf((String)param);
            }
            case "sumduration": 
            case "averageduration": 
            case "maxduration": {
                return Double.valueOf((String)param);
            }
        }
        return super.convertParam(field, param);
    }
}

