/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.analysis.entity.AbstractAnalysisEntityManagerImpl;
import kd.bos.workflow.analysis.entity.PersonAnalysisEntity;
import kd.bos.workflow.analysis.entity.PersonAnalysisEntityImpl;
import kd.bos.workflow.analysis.entity.PersonAnalysisEntityManager;
import kd.bos.workflow.analysis.personnel.GraphDimensionHelper;
import kd.bos.workflow.analysis.personnel.IDimensionHelper;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;

public class PersonAnalysisEntityManagerImpl
extends AbstractAnalysisEntityManagerImpl<PersonAnalysisEntity>
implements PersonAnalysisEntityManager {
    private static final String ORDERBY = " ORDER BY ";

    public PersonAnalysisEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends PersonAnalysisEntity> getManagedEntityClass() {
        return PersonAnalysisEntityImpl.class;
    }

    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "id", "procdefid", "schemeid", "procnumber", "procname", "entitynumber", "entityname", "orgunitid", "nodeid", "nodename", "nodetype", "nodetypename", "assigneeid", "assignee", "assigneenumber", "assigneeavatar", "years", "instancecount", "totalduration", "maxduration");
    }

    @Override
    public void clearByYears(String years) {
        QFilter[] filters = new QFilter[]{new QFilter("years", "=", (Object)years)};
        DeleteServiceHelper.delete((String)"wf_personanalysis", (QFilter[])filters);
    }

    @Override
    public DataSet getAnalysisReportDataSet(ReportQueryParam queryParam) {
        IDimensionHelper dimensionQuery = WorkflowAnalysisUtils.getPersonDimensionQuery(queryParam);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT ");
        String topSql = "";
        boolean innerTopSql = false;
        int top = dimensionQuery.getTop();
        if (top > 0) {
            topSql = "TOP " + top + " ";
        }
        FilterInfo filterInfo = null;
        if (null != queryParam) {
            filterInfo = queryParam.getFilter();
        }
        if (filterInfo == null || WfUtils.isEmptyForCollection((Collection)filterInfo.getHeadFilters()) || dimensionQuery instanceof GraphDimensionHelper) {
            sql.append(topSql);
            innerTopSql = true;
        }
        Map<String, String> fieldsMap = dimensionQuery.getQueryFieldsMap();
        int index = 1;
        int size = fieldsMap.size();
        for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
            this.appendField(sql, entry.getKey(), entry.getValue(), index++ == size);
        }
        this.appendFromJoinAndWhereSQL(sql, queryParam, params);
        sql.append(" GROUP BY ").append(dimensionQuery.getGroupByFields()).append(" ");
        if (dimensionQuery instanceof GraphDimensionHelper || innerTopSql && !super.appendOrderBySQL(sql, queryParam)) {
            sql.append(ORDERBY).append(dimensionQuery.getOrderByFields());
        }
        if (!(dimensionQuery instanceof GraphDimensionHelper)) {
            this.appendHeaderFilter(sql, topSql, queryParam, params);
            if (!innerTopSql && !super.appendOrderBySQL(sql, queryParam)) {
                sql.append(ORDERBY).append(dimensionQuery.getOrderByFields());
            }
        }
        return DB.queryDataSet((String)WorkflowAnalysisUtils.createAlgoKey("person.getAnalysisReportDatas"), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());
    }

    @Override
    protected void appendCommonConditionFilter(StringBuilder sql, FilterInfo filterInfo, List<Object> params) {
        super.appendCommonConditionFilter(sql, filterInfo, params);
        this.appendConditionAndParam(filterInfo, sql, "activitytype", "FNODETYPE", params);
        this.appendConditionAndParam(filterInfo, sql, "user", "FASSIGNEEID", params);
    }

    @Override
    protected boolean filterHeaderFilter(ReportQueryParam queryParam, String property) {
        IDimensionHelper dimensionQuery = WorkflowAnalysisUtils.getPersonDimensionQuery(queryParam);
        return dimensionQuery.filterReportColumn(property);
    }

    @Override
    protected void appendFindProcDefIdSQLAndParam(Map<String, Object> params, StringBuilder sql, List<Object> queryParams) {
        String dimension = (String)params.get("dimension");
        Long userId = (Long)params.get("userid");
        this.appendFindProcDefIdSQLAndParam(sql, queryParams, "assigneeid", userId, false);
        if ("all".equals(dimension)) {
            String nodeId = (String)params.get("nodeid");
            String nodeName = (String)params.get("nodename");
            this.appendFindProcDefIdSQLAndParam(sql, queryParams, "nodeid", nodeId, false);
            this.appendFindProcDefIdSQLAndParam(sql, queryParams, "nodename", nodeName, false);
        }
        if ("personnel".equals(dimension)) {
            Object org = params.get("org");
            this.appendFindProcDefIdSQLAndParam(sql, queryParams, "orgunitid", org, false);
            Object entity = params.get("entity");
            this.appendFindProcDefIdSQLAndParam(sql, queryParams, "entitynumber", entity, false);
            Object process = params.get("process");
            this.appendFindProcDefIdSQLAndParam(sql, queryParams, "procdefid", process, false);
        }
    }

    @Override
    public String getTableName() {
        return "T_WF_PERSONANALYSIS";
    }

    @Override
    protected Map<String, String> getQueryFieldsMap(ReportQueryParam queryParam) {
        IDimensionHelper dimensionQuery = WorkflowAnalysisUtils.getPersonDimensionQuery(queryParam);
        return dimensionQuery.getQueryFieldsMap();
    }

    @Override
    protected Object convertParam(String field, Object param) {
        switch (field) {
            case "approvecount": {
                return Long.valueOf((String)param);
            }
            case "sumduration": 
            case "averageduration": 
            case "maxduration": {
                return Double.valueOf((String)param);
            }
        }
        return super.convertParam(field, param);
    }

    @Override
    public long countByUserIdAndNodeType(Long userId, String nodeType) {
        QFilter[] filters = new QFilter[]{new QFilter("assigneeid", "=", (Object)userId), new QFilter("nodetype", "=", (Object)nodeType)};
        return this.countByFilter("id", filters, true);
    }
}

