/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.analysis.entity.AbstractAnalysisEntityManagerImpl;
import kd.bos.workflow.analysis.entity.ProcAnalysisEntity;
import kd.bos.workflow.analysis.entity.ProcAnalysisEntityImpl;
import kd.bos.workflow.analysis.entity.ProcAnalysisEntityManager;
import kd.bos.workflow.analysis.model.ProcAnalysisBarChartData;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;

public class ProcAnalysisEntityManagerImpl
extends AbstractAnalysisEntityManagerImpl<ProcAnalysisEntity>
implements ProcAnalysisEntityManager {
    public ProcAnalysisEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends ProcAnalysisEntity> getManagedEntityClass() {
        return ProcAnalysisEntityImpl.class;
    }

    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "id", "procdefid", "procnumber", "procname", "procversion", "entitynumber", "entityname", "orgunitid", "years", "instancecount", "totalduration");
    }

    @Override
    public void clearByYears(String years) {
        QFilter[] filters = new QFilter[]{new QFilter("years", "=", (Object)years)};
        DeleteServiceHelper.delete((String)"wf_procanalysis", (QFilter[])filters);
    }

    @Override
    public Map<String, Long> getEntityProcessStatistics(ReportQueryParam queryParam) {
        int limit = 8;
        HashMap<String, Long> map = new HashMap<String, Long>(limit);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT TOP ").append(limit).append(" ");
        sql.append("(").append(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FENTITYNAME", "entityname")).append(") ").append("entityname").append(", ");
        sql.append("SUM(T.FINSTANCECOUNT) INSTANCECOUNT ");
        this.appendFromJoinAndWhereSQL(sql, queryParam, params);
        sql.append("GROUP BY T.FENTITYNAME,TL.FENTITYNAME ");
        sql.append("ORDER BY INSTANCECOUNT DESC ");
        try (DataSet ds = DB.queryDataSet((String)WorkflowAnalysisUtils.createAlgoKey("process.queryEntityProcessStatistics"), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            for (Row row : ds) {
                map.put(row.getString("ENTITYNAME"), row.getLong("INSTANCECOUNT"));
            }
        }
        return map;
    }

    @Override
    public List<ProcAnalysisBarChartData> getProcAnalysisBarChartDatas(ReportQueryParam queryParam) {
        int limit = 10;
        ArrayList<ProcAnalysisBarChartData> datas = new ArrayList<ProcAnalysisBarChartData>(limit);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT TOP ").append(limit).append(" ");
        sql.append("T.FPROCNUMBER PROCNUMBER, ");
        sql.append(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FPROCNAME", "procname")).append(" ").append("procname").append(", ");
        sql.append(String.format("ROUND(SUM(T.%s)/SUM(T.FINSTANCECOUNT)/%s.0, 2) AVERAGEDURATION ", this.getTotalDurationField(), this.getTimeUnitMillisecond(queryParam)));
        this.appendFromJoinAndWhereSQL(sql, queryParam, params);
        sql.append("GROUP BY T.FPROCNUMBER, T.FPROCNAME, TL.FPROCNAME ");
        sql.append("ORDER BY AVERAGEDURATION DESC ");
        try (DataSet ds = DB.queryDataSet((String)WorkflowAnalysisUtils.createAlgoKey("process.queryProcAnalysisBarChartDatas"), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            for (Row row : ds) {
                ProcAnalysisBarChartData data = new ProcAnalysisBarChartData();
                data.setProcName(row.getString("PROCNAME"));
                data.setProcNumber(row.getString("PROCNUMBER"));
                data.setAverageDuration(row.getDouble("AVERAGEDURATION"));
                datas.add(data);
            }
        }
        return datas;
    }

    @Override
    public DataSet getAnalysisReportDataSet(ReportQueryParam queryParam) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT ");
        this.appendQueryFields(queryParam, sql);
        this.appendFromJoinAndWhereSQL(sql, queryParam, params);
        sql.append("GROUP BY T.FPROCNUMBER, T.FPROCNAME, T.FENTITYNAME, TL.FPROCNAME, TL.FENTITYNAME ");
        this.appendHeaderFilter(sql, queryParam, params);
        this.appendOrderBySQL(sql, queryParam);
        return DB.queryDataSet((String)WorkflowAnalysisUtils.createAlgoKey("process.getAnalysisReportDatas"), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());
    }

    @Override
    protected void appendFindProcDefIdSQLAndParam(Map<String, Object> params, StringBuilder sql, List<Object> queryParams) {
        String procNumber = (String)params.get("procnumber");
        String procName = (String)params.get("procname");
        this.appendFindProcDefIdSQLAndParam(sql, queryParams, "procnumber", procNumber, false);
        this.appendFindProcDefIdSQLAndParam(sql, queryParams, "procname", procName, true);
    }

    @Override
    public String getTableName() {
        return "T_WF_PROCANALYSIS";
    }

    @Override
    protected String getDefaultTimeUnit() {
        return "hour";
    }

    @Override
    protected Map<String, String> getQueryFieldsMap(ReportQueryParam queryParam) {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        fieldsMap.put("T.FPROCNUMBER", "procnumber");
        fieldsMap.put(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FPROCNAME", "procname"), "procname");
        fieldsMap.put(WorkflowAnalysisUtils.getGeneralLangSQL(this.getEntityName(), "FENTITYNAME", "entityname"), "entityname");
        String durationField = this.getTotalDurationField();
        int millisecond = this.getTimeUnitMillisecond(queryParam);
        String totalDuration = String.format("ROUND(SUM(%s)/%s.0, 2)", durationField, millisecond);
        fieldsMap.put(totalDuration, "sumduration");
        String averageDuration = String.format("ROUND(SUM(%s)/SUM(FINSTANCECOUNT)/%s.0, 2)", durationField, millisecond);
        fieldsMap.put(averageDuration, "averageduration");
        fieldsMap.put("SUM(FINSTANCECOUNT)", "instancecount");
        return fieldsMap;
    }

    @Override
    protected Object convertParam(String field, Object param) {
        switch (field) {
            case "instancecount": {
                return Long.valueOf((String)param);
            }
            case "sumduration": 
            case "averageduration": {
                return Double.valueOf((String)param);
            }
        }
        return super.convertParam(field, param);
    }
}

