/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.personnel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.workflow.analysis.personnel.IDimensionHelper;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;

public abstract class AbstractDimensionHelper
implements IDimensionHelper {
    private String timeUnit;

    @Override
    public Map<String, String> getQueryFieldsMap() {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        fieldsMap.put("T.FASSIGNEEID", "userid");
        fieldsMap.put("T.FASSIGNEENUMBER", "usernumber");
        fieldsMap.put("T.FASSIGNEEAVATAR", "useravatar");
        fieldsMap.put(WorkflowAnalysisUtils.getGeneralLangSQL("wf_personanalysis", "FASSIGNEE", "assignee"), "username");
        fieldsMap.put("SUM(T.FINSTANCECOUNT)", "approvecount");
        String durationField = WorkflowAnalysisUtils.getTotalDurationField();
        int millisecond = WorkflowAnalysisUtils.getTimeUnitMillisecond(this.timeUnit);
        String totalDuration = String.format("ROUND(SUM(T.%s)/%s.0, 2)", durationField, millisecond);
        fieldsMap.put(totalDuration, "sumduration");
        String averageDuration = String.format("ROUND(SUM(T.%s)/SUM(T.FINSTANCECOUNT)/%s.0, 2)", durationField, millisecond);
        fieldsMap.put(averageDuration, "averageduration");
        String maxDuration = String.format("ROUND(MAX(T.%s)/%s.0, 2)", WorkflowAnalysisUtils.getMaxDurationField(), millisecond);
        fieldsMap.put(maxDuration, "maxduration");
        return fieldsMap;
    }

    @Override
    public int getTop() {
        return 0;
    }

    @Override
    public String getGroupByFields() {
        return String.format("%s,%s,%s,%s,%s", "T.FASSIGNEEID", "T.FASSIGNEENUMBER", "T.FASSIGNEEAVATAR", "T.FASSIGNEE", "TL.FASSIGNEE");
    }

    @Override
    public String getOrderByFields() {
        return "usernumber";
    }

    @Override
    public void filterReportColumns(List<AbstractReportColumn> columns) {
    }

    @Override
    public boolean filterReportColumn(String column) {
        return false;
    }

    @Override
    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    protected String createPersonnelEfficiencyAlgoKey(String key) {
        return WorkflowAnalysisUtils.createAlgoKey(String.format("personnelEfficiency.%s", key));
    }
}

