/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.personnel;

import java.util.Map;
import kd.bos.workflow.analysis.personnel.AbstractDimensionHelper;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;

public class GraphDimensionHelper
extends AbstractDimensionHelper {
    @Override
    public int getTop() {
        return 20;
    }

    @Override
    public Map<String, String> getQueryFieldsMap() {
        Map<String, String> fieldsMap = super.getQueryFieldsMap();
        fieldsMap.remove(WorkflowAnalysisUtils.getGeneralLangSQL("wf_personanalysis", "FASSIGNEE", "assignee"));
        fieldsMap.remove("T.FASSIGNEENUMBER");
        fieldsMap.remove("T.FASSIGNEEAVATAR");
        String durationField = WorkflowAnalysisUtils.getTotalDurationField();
        String millisecondDuration = String.format("ROUND(SUM(T.%s)/SUM(T.FINSTANCECOUNT)/1.0, 2)", durationField);
        fieldsMap.put(millisecondDuration, "averageMillisecond");
        return fieldsMap;
    }

    @Override
    public String getOrderByFields() {
        return String.format("%s DESC ", "averageMillisecond");
    }

    @Override
    public String getGroupByFields() {
        return "T.FASSIGNEEID";
    }
}

