/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.plugin;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowProcessInstanceRunningStatusPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String UNDERWAY = "underway";
    private static final String SUSPENDED = "suspended";
    private static final String TERMINAL = "terminal";
    private static final String FINISH = "finish";
    private static final String UNDERWAYLABEL = "underwaylabel";
    private static final String EXCEPTIONLABEL = "exceptionlabel";
    private static final String TERMINALLABEL = "terminallabel";
    private static final String FINISHLABEL = "finishlabel";

    public void registerListener(EventObject e) {
        Label underwaylabel = (Label)this.getControl(UNDERWAYLABEL);
        underwaylabel.addClickListener((ClickListener)this);
        Label exceptionlabel = (Label)this.getControl(EXCEPTIONLABEL);
        exceptionlabel.addClickListener((ClickListener)this);
        Label terminallabel = (Label)this.getControl(TERMINALLABEL);
        terminallabel.addClickListener((ClickListener)this);
        Label finishlabel = (Label)this.getControl(FINISHLABEL);
        finishlabel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setProgressBar();
    }

    private void setProgressBar() {
        Long allCount = 1L;
        Long underWayProcessCount = 0L;
        this.setProgressBarPercentage(UNDERWAY, underWayProcessCount, allCount);
        Long terminatedProcessCount = 0L;
        this.setProgressBarPercentage(TERMINAL, terminatedProcessCount, allCount);
        Long finishedProcessCount = 0L;
        this.setProgressBarPercentage(FINISH, finishedProcessCount, allCount);
        Long suspendedProcessCount = 0L;
        this.setProgressBarPercentage(SUSPENDED, suspendedProcessCount, allCount);
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "underwaylabel": {
                this.linkToExecutionInstance(ManagementConstants.ACTIVE.getStateCode());
                break;
            }
            case "exceptionlabel": {
                this.linkToExecutionInstance(ManagementConstants.SUSPENDED.getStateCode());
                break;
            }
            case "terminallabel": {
                this.linkToHistoricProcessInstance(TERMINAL);
                break;
            }
            case "finishlabel": {
                this.linkToHistoricProcessInstance(FINISH);
                break;
            }
        }
    }

    private void linkToHistoricProcessInstance(String state) {
        DesignerPluginUtil.openFormListPage((IFormView)this.getView(), (String)"wf_hiprocinst_layout", (Object[])new Object[]{"condition", state});
    }

    private void linkToExecutionInstance(String stateCode) {
        DesignerPluginUtil.openFormListPage((IFormView)this.getView(), (String)"wf_execution", (Object[])new Object[]{"state", stateCode});
    }

    private Long getFinishedProcessCount() {
        QFilter finishFilter1 = new QFilter("endtype", "=", (Object)"10");
        QFilter finishFilter2 = new QFilter("endTime", "is not null", null);
        return this.countByFilter("wf_hiprocinst", new QFilter[]{finishFilter1, finishFilter2});
    }

    private Long getTerminatedProcessCount() {
        QFilter terminalFilter = new QFilter("endtype", "!=", (Object)"10");
        QFilter terminalFilter2 = new QFilter("endTime", "is not null", null);
        return this.countByFilter("wf_hiprocinst", new QFilter[]{terminalFilter, terminalFilter2});
    }

    private Long getUnderWayProcessCount() {
        QFilter runningFilter = new QFilter("suspensionstate", "=", (Object)"1");
        QFilter runningFilter2 = new QFilter("scope", "=", (Object)"1");
        return this.countByFilter("wf_execution", new QFilter[]{runningFilter, runningFilter2});
    }

    private Long getSuspendedProcessCount() {
        QFilter suspendFilter = new QFilter("suspensionstate", "=", (Object)"2");
        QFilter suspendFilter2 = new QFilter("scope", "=", (Object)"1");
        return this.countByFilter("wf_execution", new QFilter[]{suspendFilter, suspendFilter2});
    }

    private Long countByFilter(String entityNumber, QFilter[] filters) {
        WorkflowService workflowService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RepositoryService service = workflowService.getRepositoryService();
        return service.getEntityCountByFilter(entityNumber, filters);
    }

    private void setProgressBarPercentage(String key, Long count, Long allCount) {
        ProgressBar suspended = (ProgressBar)this.getView().getControl(key);
        BigDecimal percentage = WorkflowAnalysisUtils.getPercentage(count, allCount);
        suspended.setPercent(percentage.intValue(), WorkflowAnalysisUtils.getPercentageText(percentage));
    }
}

