/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.plugin.data;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.workflow.analysis.enumeration.WorkflowReportType;
import kd.bos.workflow.analysis.service.WorkflowAnalysisService;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.engine.WfUtils;

public abstract class AbstractWorkflowAnalysisDataPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        return this.getAnalysisService().getAnalysisReportDataSet(this.getReportType(), param);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List<String> fields = this.getTimeUnitCorrelationFields();
        if (fields == null || fields.isEmpty()) {
            return super.getColumns(columns);
        }
        ReportQueryParam queryParam = this.getQueryParam();
        if (queryParam == null) {
            return super.getColumns(columns);
        }
        String timeUnit = (String)queryParam.getCustomParam().get("timeunit");
        if (WfUtils.isEmpty((String)timeUnit)) {
            return super.getColumns(columns);
        }
        String text = WorkflowAnalysisUtils.getTimeUnitText(timeUnit);
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn;
            String field;
            if (!(column instanceof ReportColumn) || !fields.contains(field = (reportColumn = (ReportColumn)column).getFieldKey())) continue;
            String caption = String.valueOf(reportColumn.getCaption());
            caption = caption.substring(0, caption.indexOf(40));
            reportColumn.setCaption(new LocaleString(String.format("%s ( %s )", caption, text)));
        }
        return super.getColumns(columns);
    }

    protected WorkflowAnalysisService getAnalysisService() {
        return WorkflowAnalysisUtils.getWorkflowAnalysisService();
    }

    protected abstract WorkflowReportType getReportType();

    protected abstract List<String> getTimeUnitCorrelationFields();
}

