/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.plugin.graph;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.mvc.report.ReportView;
import kd.bos.workflow.analysis.model.BarChartConfig;
import kd.bos.workflow.analysis.model.PieChartConfig;
import kd.bos.workflow.analysis.plugin.AbstractWorkflowAnalysisPlugin;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;

public abstract class AbstractWorkflowAnalysisGraphPlugin
extends AbstractWorkflowAnalysisPlugin {
    protected static final String PROPERTY_SHOW = "show";
    protected static final String PROPERTY_XAXIS = "xAxis";
    protected static final String PROPERTY_AXISTICK = "axisTick";
    protected static final String PROPERTY_AXISLABEL = "axisLabel";
    protected static final String PROPERTY_NAMETEXTSTYLE = "nameTextStyle";
    protected static final String PROPERTY_KEY_ALIGN = "align";
    protected static final String PROPERTY_KEY_ROTATE = "rotate";
    protected static final String PROPERTY_KEY_INTERVAL = "interval";
    protected static final String PROPERTY_KEY_FORMATTER = "formatter";
    protected static final String PROPERTY_VALUE_LEFT = "left";
    protected static final String COLOR_666666 = "#666666";
    protected static final String COLOR_CCCCCC = "#CCCCCC";
    protected static final String COLOR_40A9FF = "#40A9FF";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPieChart();
        this.initBarChart();
    }

    protected void initPieChart() {
        PieChartConfig config = this.getPieChartConfig();
        if (config == null || config.getChartKey() == null) {
            return;
        }
        PieChart chart = (PieChart)this.getControl(config.getChartKey());
        if (chart == null) {
            return;
        }
        chart.clearData();
        chart.setShowTooltip(true);
        PieSeries series = chart.createPieSeries(config.getSeriesName());
        series.setRadius(config.getInsideRadius(), config.getOuterRadius());
        series.setData(config.getData());
        if (config.getLabel() != null) {
            series.setLabel(config.getLabel());
        }
    }

    protected void initBarChart() {
        BarChartConfig config = this.getBarChartConfig();
        if (config == null || config.getChartKey() == null) {
            return;
        }
        Chart chart = (Chart)this.getControl(config.getChartKey());
        if (chart == null) {
            return;
        }
        chart.clearData();
        chart.setShowTooltip(true);
        chart.setMargin(Position.left, "20px");
        chart.setMargin(Position.right, "100px");
        BarSeries series = chart.createBarSeries(config.getSeriesName());
        series.setType(ChartType.bar);
        series.setBarWidth("20px");
        Axis xAxis = chart.createXAxis(config.getXaxisName(), AxisType.category);
        Axis yAxis = chart.createYAxis(config.getYaxisName(), AxisType.value);
        this.hideAxisTick(xAxis, yAxis);
        this.setAxisNameAlign(yAxis, PROPERTY_VALUE_LEFT);
        this.setXaxisLabelConfig(chart, xAxis, 45, config.getXaxisLabelLength());
        series.setData(config.getData());
        xAxis.setCategorys(config.getCategories());
        this.setLineColor(xAxis, COLOR_666666);
        this.setLineColor(yAxis, COLOR_666666);
        this.setSplitLineColor(yAxis, COLOR_CCCCCC);
        chart.bindData(null);
    }

    protected void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    protected void setSplitLineColor(Axis axis, String color) {
        HashMap splitLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        splitLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("splitLine", splitLineMap);
    }

    protected void hideAxisTick(Axis ... axises) {
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put(PROPERTY_SHOW, Boolean.FALSE);
        for (Axis axis : axises) {
            axis.setPropValue(PROPERTY_AXISTICK, axisTick);
        }
    }

    protected void setAxisNameAlign(Axis axis, String align) {
        HashMap<String, String> style = new HashMap<String, String>();
        style.put(PROPERTY_KEY_ALIGN, align);
        axis.setPropValue(PROPERTY_NAMETEXTSTYLE, style);
    }

    protected void rotateAxisLabel(int rotate, Axis ... axises) {
        HashMap<String, Integer> value = new HashMap<String, Integer>();
        value.put(PROPERTY_KEY_INTERVAL, 0);
        value.put(PROPERTY_KEY_ROTATE, rotate);
        for (Axis axis : axises) {
            axis.setPropValue(PROPERTY_AXISLABEL, value);
        }
    }

    protected void setXaxisLabelConfig(Chart chart, Axis xAxis, int rotate, int maxLength) {
        String template = "function(value, index){if(value && value.length > %s){ return value.substring(0, %s) + '...'; }else{ return value; }}";
        String formatter = String.format(template, maxLength, maxLength);
        this.setXaxisLabelConfig(chart, xAxis, rotate, formatter);
    }

    protected void setXaxisLabelConfig(Chart chart, Axis xAxis, int rotate, String formatter) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put(PROPERTY_KEY_INTERVAL, 0);
        config.put(PROPERTY_KEY_ROTATE, rotate);
        if (formatter != null) {
            ArrayList<String> labelFormatFunction = new ArrayList<String>();
            labelFormatFunction.add(PROPERTY_XAXIS);
            labelFormatFunction.add("0");
            labelFormatFunction.add(PROPERTY_AXISLABEL);
            labelFormatFunction.add(PROPERTY_KEY_FORMATTER);
            chart.addFuncPath(labelFormatFunction);
            config.put(PROPERTY_KEY_FORMATTER, formatter);
        }
        xAxis.setPropValue(PROPERTY_AXISLABEL, config);
    }

    protected ReportQueryParam getReportQueryParam() {
        ReportQueryParam queryParam = null;
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ReportView) {
            queryParam = ((ReportView)parentView).getQueryParam();
        }
        return queryParam;
    }

    protected String getTimeUnitText(String defaultUnit) {
        ReportQueryParam queryParam = this.getReportQueryParam();
        if (queryParam == null) {
            return null;
        }
        String timeUnit = (String)queryParam.getCustomParam().get("timeunit");
        return WorkflowAnalysisUtils.getTimeUnitText(timeUnit, defaultUnit);
    }

    protected abstract PieChartConfig getPieChartConfig();

    protected abstract BarChartConfig getBarChartConfig();
}

