/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.plugin.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.chart.ItemValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.analysis.enumeration.WorkflowReportType;
import kd.bos.workflow.analysis.model.BarChartConfig;
import kd.bos.workflow.analysis.model.PieChartConfig;
import kd.bos.workflow.analysis.plugin.graph.AbstractWorkflowAnalysisGraphPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.SimpleUserInfo;

public class WorkflowPersonnelEfficiencyGraphPlugin
extends AbstractWorkflowAnalysisGraphPlugin {
    @Override
    protected PieChartConfig getPieChartConfig() {
        return null;
    }

    @Override
    protected BarChartConfig getBarChartConfig() {
        BarChartConfig config = new BarChartConfig();
        config.setChartKey("efficiencychart");
        String timeUnitText = this.getTimeUnitText("minute");
        config.setSeriesName(String.format(ResManager.loadKDString((String)"\u5e73\u5747\u8017\u65f6 ( %s ) ", (String)"WorkflowPersonnelEfficiencyGraphPlugin_1", (String)"bos-wf-analysis", (Object[])new Object[0]), timeUnitText));
        config.setXaxisName(ResManager.loadKDString((String)"\u59d3\u540d", (String)"WorkflowPersonnelEfficiencyGraphPlugin_2", (String)"bos-wf-analysis", (Object[])new Object[0]));
        config.setYaxisName(ResManager.loadKDString((String)"\u5e73\u5747\u8017\u65f6", (String)"WorkflowPersonnelEfficiencyGraphPlugin_3", (String)"bos-wf-analysis", (Object[])new Object[0]));
        config.setXaxisLabelLength(5);
        this.setGraphData(config);
        return config;
    }

    private void setGraphData(BarChartConfig config) {
        HashMap<Long, SimpleUserInfo> userMap = new HashMap<Long, SimpleUserInfo>(16);
        LinkedHashMap<Long, Double> durationMap = new LinkedHashMap<Long, Double>(16);
        ReportQueryParam queryParam = this.getReportQueryParam();
        if (queryParam != null) {
            queryParam.getCustomParam().put("dimension", "graph");
        }
        DataSet ds = this.getAnalysisService().getAnalysisReportDataSet(WorkflowReportType.PERSON, queryParam);
        Object object = null;
        try {
            for (Row row : ds) {
                Long uid = row.getLong("userid");
                Double average = row.getDouble("averageduration");
                durationMap.put(uid, average);
            }
        }
        catch (Throwable iter) {
            object = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)object).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (durationMap.isEmpty()) {
            config.setData(new ItemValue[0]);
            return;
        }
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", durationMap.keySet())});
        for (DynamicObject user : users) {
            Long uid = user.getLong("id");
            String userName = user.getString("name");
            String userNumber = user.getString("number");
            userMap.put(uid, new SimpleUserInfo(uid, userName, userNumber));
        }
        int index = 0;
        SimpleUserInfo userInfo = null;
        ItemValue[] data = new ItemValue[durationMap.size()];
        ArrayList<String> categories = new ArrayList<String>(16);
        for (Map.Entry entry : durationMap.entrySet()) {
            Long userId = (Long)entry.getKey();
            userInfo = (SimpleUserInfo)userMap.get(userId);
            if (userInfo == null) {
                categories.add(String.valueOf(userId));
            } else {
                categories.add(this.getUserInfoText(userInfo));
            }
            data[index] = new ItemValue((Number)entry.getValue(), "#40A9FF");
            ++index;
        }
        config.setData(data);
        config.setCategories(categories);
    }

    private String getUserInfoText(SimpleUserInfo userInfo) {
        if (WfUtils.isEmpty((String)userInfo.getNumber())) {
            return userInfo.getName();
        }
        if (WfUtils.isEmpty((String)userInfo.getName())) {
            return String.format("(%s)", userInfo.getNumber());
        }
        return String.format("%s (%s)", userInfo.getName(), userInfo.getNumber());
    }
}

