/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.plugin.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.ItemValue;
import kd.bos.workflow.analysis.model.BarChartConfig;
import kd.bos.workflow.analysis.model.PieChartConfig;
import kd.bos.workflow.analysis.model.ProcAnalysisBarChartData;
import kd.bos.workflow.analysis.plugin.graph.AbstractWorkflowAnalysisGraphPlugin;

public class WorkflowProcessEfficiencyGraphPlugin
extends AbstractWorkflowAnalysisGraphPlugin {
    private static String[] colors = new String[]{"#42A8FF", "#6382FB", "#A26AE1", "#F37683", "#FBC439", "#FFA740", "#73D13F", "#45DAD1"};

    @Override
    protected PieChartConfig getPieChartConfig() {
        PieChartConfig config = new PieChartConfig();
        config.setChartKey("piechartap");
        config.setSeriesName(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f", (String)"WorkflowProcessEfficiencyGraphPlugin_1", (String)"bos-wf-analysis", (Object[])new Object[0]));
        int index = 0;
        Map<String, Long> data = this.getAnalysisService().getEntityProcessStatistics(this.getReportQueryParam());
        ItemValue[] items = new ItemValue[data.size()];
        for (Map.Entry<String, Long> entry : data.entrySet()) {
            items[index] = new ItemValue(entry.getKey(), (Number)entry.getValue(), colors[index]);
            ++index;
        }
        config.setData(items);
        return config;
    }

    @Override
    protected BarChartConfig getBarChartConfig() {
        BarChartConfig config = new BarChartConfig();
        config.setChartKey("customchartap");
        String timeUnitText = this.getTimeUnitText("hour");
        config.setSeriesName(String.format(ResManager.loadKDString((String)"\u5e73\u5747\u8017\u65f6 ( %s ) ", (String)"WorkflowProcessEfficiencyGraphPlugin_2", (String)"bos-wf-analysis", (Object[])new Object[0]), timeUnitText));
        config.setXaxisName(ResManager.loadKDString((String)"\u6d41\u7a0b", (String)"WorkflowProcessEfficiencyGraphPlugin_3", (String)"bos-wf-analysis", (Object[])new Object[0]));
        config.setYaxisName(ResManager.loadKDString((String)"\u5e73\u5747\u8017\u65f6", (String)"WorkflowProcessEfficiencyGraphPlugin_4", (String)"bos-wf-analysis", (Object[])new Object[0]));
        List<ProcAnalysisBarChartData> datas = this.getAnalysisService().getProcAnalysisBarChartDatas(this.getReportQueryParam());
        int size = datas.size();
        ProcAnalysisBarChartData data = null;
        ItemValue[] items = new ItemValue[size];
        ArrayList<String> categories = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            data = datas.get(i);
            String value = String.format("%s\uff1a%s", data.getProcName(), data.getProcNumber());
            items[i] = new ItemValue((Number)data.getAverageDuration(), "#40A9FF");
            categories.add(value);
        }
        config.setData(items);
        config.setCategories(categories);
        return config;
    }
}

