/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.plugin.layout;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.analysis.service.WorkflowAnalysisService;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public abstract class AbstractWorkflowHistoryLayoutListPlugin
extends AbstractListPlugin {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final String BTN_EXIT = "exitbtn";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object years = parameter.getCustomParam("years");
        String minYears = (String)parameter.getCustomParam("min_years");
        QFilter dateFilter = this.getDateFilter(years, minYears);
        if (dateFilter != null) {
            e.addCustomQFilter(dateFilter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (BTN_EXIT.equals(evt.getItemKey())) {
            this.getView().close();
        } else {
            super.itemClick(evt);
        }
    }

    protected QFilter getDateFilter(Object years, String minYears) {
        QFilter filter = null;
        filter = years instanceof List ? this.getDateQFilter((List)years) : (years instanceof String ? this.getDateQFilter((String)years) : this.getMinYearsDateQFilter(minYears));
        QFilter timeFilter = this.getRunningTimeQFilter();
        if (filter != null && timeFilter != null) {
            filter.and(timeFilter);
        }
        return filter;
    }

    protected QFilter getMinYearsDateQFilter(String minYears) {
        Date time = null;
        QFilter minYearsFilter = null;
        if (minYears != null) {
            try {
                time = WorkflowAnalysisUtils.getYearsDateFormat().parse(minYears);
                minYearsFilter = new QFilter("endTime", ">=", (Object)time);
            }
            catch (ParseException e) {
                this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return minYearsFilter;
    }

    protected QFilter getRunningTimeQFilter() {
        Date time = null;
        QFilter timeFilter = null;
        String key = (String)this.getView().getFormShowParameter().getCustomParam("runningTimeConfigKey");
        String runningTime = (String)WfConfigurationUtil.getConfigCenterVal((String)key);
        if (runningTime != null) {
            try {
                time = WorkflowAnalysisUtils.getRunningTimeDateFormat().parse(runningTime);
                timeFilter = new QFilter("endTime", "<=", (Object)time);
            }
            catch (ParseException e) {
                this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return timeFilter;
    }

    protected QFilter getDateQFilter(String years) {
        Date date = null;
        String property = "endTime";
        try {
            date = new SimpleDateFormat("yyyyMM").parse(years);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            QFilter filter = new QFilter(property, ">=", (Object)date);
            calendar.add(2, 1);
            filter.and(new QFilter(property, "<", (Object)calendar.getTime()));
            return filter;
        }
        catch (ParseException e) {
            this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            return null;
        }
    }

    protected QFilter getDateQFilter(List<String> yearsList) {
        QFilter filter = null;
        for (String years : yearsList) {
            if (filter == null) {
                filter = this.getDateQFilter(years);
                continue;
            }
            filter.or(this.getDateQFilter(years));
        }
        return filter;
    }

    protected WorkflowAnalysisService getAnalysisService() {
        return WorkflowAnalysisUtils.getWorkflowAnalysisService();
    }
}

