/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.plugin.report;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.workflow.analysis.enumeration.WorkflowReportType;
import kd.bos.workflow.analysis.service.WorkflowAnalysisService;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;

public abstract class AbstractWorkflowAnalysisReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final String REPORTLIST = "reportlistap";
    protected static final String TIPSPANEL = "tipspanel";
    protected static final String TIPSTEXT = "tipstext";
    protected static final String FIELD_TIMEUNIT = "timeunit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl(REPORTLIST);
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent column : allColumns) {
            column.setSort(true);
            column.setFilter(true);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Map params = queryParam.getCustomParam();
        Object value = params.get(FIELD_TIMEUNIT);
        if (value == null) {
            String timeUnit = (String)this.getModel().getValue(FIELD_TIMEUNIT);
            params.put(FIELD_TIMEUNIT, timeUnit);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.showGraphPage();
        this.showGenerationTime();
    }

    protected void showGenerationTime() {
        String runningTime = (String)WfConfigurationUtil.getConfigCenterVal((String)this.getRunningTimeConfigKey());
        if (runningTime != null && runningTime.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TIPSPANEL});
            Label tips = (Label)this.getControl(TIPSTEXT);
            tips.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6570\u636e\u4e8e %s \u751f\u6210\u3002", (String)"AbstractWorkflowAnalysisReportPlugin_8", (String)"bos-wf-analysis", (Object[])new Object[0]), runningTime));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPSPANEL});
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        this.showGraphPage();
        this.showGenerationTime();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            List filterItems = filterInfo.getFilterItems();
            for (FilterItemInfo filterItem : filterItems) {
                String tip = this.verifyFilterItem(filterItem);
                if (tip == null) continue;
                this.getView().showTipNotification(tip, Integer.valueOf(3000));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    protected String verifyFilterItem(FilterItemInfo filterItem) {
        if ("IN".equals(filterItem.getCompareType())) {
            int limit = this.getFilterItemSizeLimit();
            Object value = filterItem.getValue();
            if (value instanceof Collection && ((Collection)value).size() > limit) {
                return String.format(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u5931\u8d25\uff1a\u8fc7\u6ee4\u6761\u4ef6\u201c%1$s\u201d\u7684\u9009\u9879\u8d85\u8fc7\u6700\u5927\u9650\u5236\u201c%2$s\u201d\u3002", (String)"AbstractWorkflowAnalysisReportPlugin_1", (String)"bos-wf-analysis", (Object[])new Object[0]), this.getFilterItemName(filterItem.getPropName()), limit);
            }
        }
        return null;
    }

    protected int getFilterItemSizeLimit() {
        String count = (String)WfConfigurationUtil.getConfigCenterVal((String)"workflow.analysis.filterItemSizeLimit");
        if (count != null && count.matches("^\\d{1,4}$")) {
            return Integer.parseInt(count);
        }
        return 4000;
    }

    private String getFilterItemName(String propName) {
        if (propName.startsWith("entity")) {
            return ResManager.loadKDString((String)"\u5355\u636e", (String)"AbstractWorkflowAnalysisReportPlugin_2", (String)"bos-wf-analysis", (Object[])new Object[0]);
        }
        if (propName.startsWith("process")) {
            return ResManager.loadKDString((String)"\u6d41\u7a0b", (String)"AbstractWorkflowAnalysisReportPlugin_3", (String)"bos-wf-analysis", (Object[])new Object[0]);
        }
        if (propName.startsWith("org")) {
            return ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AbstractWorkflowAnalysisReportPlugin_4", (String)"bos-wf-analysis", (Object[])new Object[0]);
        }
        if (propName.startsWith("user")) {
            return ResManager.loadKDString((String)"\u4eba\u5458", (String)"AbstractWorkflowAnalysisReportPlugin_5", (String)"bos-wf-analysis", (Object[])new Object[0]);
        }
        switch (propName) {
            case "years": {
                return ResManager.loadKDString((String)"\u5e74\u6708", (String)"AbstractWorkflowAnalysisReportPlugin_6", (String)"bos-wf-analysis", (Object[])new Object[0]);
            }
            case "activitytype": {
                return ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b", (String)"AbstractWorkflowAnalysisReportPlugin_7", (String)"bos-wf-analysis", (Object[])new Object[0]);
            }
        }
        return "";
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        List<String> filterKeys;
        super.filterContainerInit(contInitEvent, queryParam);
        FilterColumn column = contInitEvent.getFilterColumn("years");
        if (column instanceof CommonFilterColumn) {
            this.initYearsFilterColumn((CommonFilterColumn)column);
        }
        if ((column = contInitEvent.getFilterColumn("activitytype")) instanceof CommonFilterColumn) {
            this.initNodeTypeFilterColumn((CommonFilterColumn)column);
        }
        if ((filterKeys = this.getRemovedFilterColumnKeys()) != null) {
            this.removeFilterColumns(contInitEvent, filterKeys);
        }
    }

    protected void removeFilterColumns(FilterContainerInitEvent contInitEvent, List<String> filterKeys) {
        List filters = contInitEvent.getCommonFilterColumns();
        Iterator iterator = filters.iterator();
        while (iterator.hasNext()) {
            if (!filterKeys.contains(((FilterColumn)iterator.next()).getFieldName())) continue;
            iterator.remove();
        }
    }

    protected void initYearsFilterColumn(CommonFilterColumn column) {
        List<String> yearses = this.getAnalysisService().getAnalysisYears(this.getReportType());
        if (yearses.isEmpty()) {
            return;
        }
        try {
            yearses = yearses.stream().map(s -> LocalDate.of(Integer.parseInt(s.substring(0, 4)), Integer.parseInt(s.substring(4)), 1)).sorted((d1, d2) -> d2.compareTo((ChronoLocalDate)d1)).map(date -> String.format("%04d%02d", date.getYear(), date.getMonthValue())).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.log.debug("date format error" + e.getMessage());
        }
        for (String years : yearses) {
            column.getComboItems().add(new ComboItem(new LocaleString(years), years));
        }
        Object years = this.getView().getFormShowParameter().getCustomParam("years");
        if (years instanceof List) {
            column.setDefaultValues((List)years);
        }
        String minYears = yearses.get(yearses.size() - 1);
        this.getPageCache().put("min_years", minYears);
    }

    protected void initNodeTypeFilterColumn(CommonFilterColumn column) {
        Map<String, String> nodeTypeInfo = this.getAnalysisService().getAnalysisNodeTypeInfo(this.getReportType());
        for (Map.Entry<String, String> entry : nodeTypeInfo.entrySet()) {
            column.getComboItems().add(new ComboItem(new LocaleString(entry.getValue()), entry.getKey()));
        }
    }

    protected WorkflowAnalysisService getAnalysisService() {
        return WorkflowAnalysisUtils.getWorkflowAnalysisService();
    }

    protected void openHistoricLayout(String formId, Object[] params) {
        ArrayList<Object> datas = new ArrayList<Object>(params.length + 6);
        for (Object param : params) {
            datas.add(param);
        }
        datas.add("years");
        datas.add(this.getYearsFilterItemValue());
        datas.add("min_years");
        datas.add(this.getPageCache().get("min_years"));
        datas.add("runningTimeConfigKey");
        datas.add(this.getRunningTimeConfigKey());
        DesignerPluginUtil.openFormListPage((IFormView)this.getView(), (String)formId, (Object[])datas.toArray());
    }

    protected String openReportPage(IFormView view, String formId, Object ... params) {
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(formId);
        FilterInfo filterInfo = this.getView().getQueryParam().getFilter();
        if (filterInfo != null) {
            params = this.getAddedYearsFilterParams(params);
        }
        return DesignerPluginUtil.openForm((IFormView)view, (FormShowParameter)parameter, (Object[])params);
    }

    protected Object getFilterItemValue(String filterKey) {
        FilterItemInfo filterItem = this.getFilterItem(filterKey);
        if (filterItem != null) {
            return filterItem.getValue();
        }
        return null;
    }

    protected Object getEntityFilterItemValue() {
        return this.getFilterItemValue(this.getBaseDataFilterKey("entity"));
    }

    protected Object getOrgFilterItemValue() {
        return this.getFilterItemValue(this.getBaseDataFilterKey("org"));
    }

    protected Object getProcessFilterItemValue() {
        return this.getFilterItemValue(this.getBaseDataFilterKey("process"));
    }

    protected Object getNodeTypeFilterItemValue() {
        return this.getFilterItemValue("activitytype");
    }

    protected Object getYearsFilterItemValue() {
        return this.getFilterItemValue("years");
    }

    protected FilterItemInfo getFilterItem(String key) {
        FilterInfo filterInfo = this.getView().getQueryParam().getFilter();
        if (filterInfo == null) {
            return null;
        }
        return filterInfo.getFilterItem(key);
    }

    protected Object[] getAddedYearsFilterParams(Object ... params) {
        FilterItemInfo yearsFilter = this.getFilterItem("years");
        if (yearsFilter != null) {
            ArrayList<Object> datas = new ArrayList<Object>(params.length + 2);
            for (Object param : params) {
                datas.add(param);
            }
            ArrayList<String> values = new ArrayList<String>();
            Object filterValue = yearsFilter.getValue();
            if (filterValue instanceof List) {
                values.addAll((Collection)filterValue);
            } else if (filterValue instanceof String) {
                values.add((String)filterValue);
            }
            datas.add("years");
            datas.add(values);
            params = datas.toArray();
        }
        return params;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (FIELD_TIMEUNIT.equals(property)) {
            this.timeUnitChanged((String)newValue);
        }
    }

    private void timeUnitChanged(String newValue) {
        ReportQueryParam queryParam = this.getView().getQueryParam();
        queryParam.getCustomParam().put(FIELD_TIMEUNIT, newValue);
        this.getView().refresh();
    }

    protected String getBaseDataFilterKey(String filterKey) {
        return String.format("%s.id", filterKey);
    }

    protected Set<Long> getProcessDefinitionIds(Map<String, Object> params) {
        return this.getAnalysisService().getProcessDefinitionIds(this.getReportType(), params);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("min_years");
    }

    protected List<String> getRemovedFilterColumnKeys() {
        return new ArrayList<String>();
    }

    protected abstract WorkflowReportType getReportType();

    protected abstract String getRunningTimeConfigKey();

    protected abstract void showGraphPage();
}

