/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.plugin.report;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.analysis.enumeration.WorkflowReportType;
import kd.bos.workflow.analysis.plugin.report.AbstractWorkflowAnalysisReportPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;

public class WorkflowNodeEfficiencyReportPlugin
extends AbstractWorkflowAnalysisReportPlugin {
    @Override
    protected WorkflowReportType getReportType() {
        return WorkflowReportType.NODE;
    }

    @Override
    protected List<String> getRemovedFilterColumnKeys() {
        List<String> keys = super.getRemovedFilterColumnKeys();
        String procNumber = (String)this.getView().getFormShowParameter().getCustomParam("processNumber");
        if (procNumber != null) {
            keys.add("process");
            keys.add("entity");
            keys.add("org");
        }
        return keys;
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String procNumber = (String)this.getView().getFormShowParameter().getCustomParam("processNumber");
        if (procNumber != null) {
            QFilter[] filters = new QFilter[]{new QFilter("procnumber", "=", (Object)procNumber)};
            queryParam.getCustomParam().put("filters", filters);
        }
    }

    @Override
    protected void showGraphPage() {
        DesignerPluginUtil.openFormInContainer((IFormView)this.getView(), (String)"wf_nodeefficiency_graph", (String)"flexpanelap");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (!WfAdminUtil.isWfAdmin((Long)RequestContext.get().getCurrUserId()) && !PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodeefficiencyanls", (String)"47150e89000000ac")) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u6548\u7387\u5206\u6790\u201d\u9875\u9762\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\u3002", (String)"AbstractWorkflowAnalysisGraphPlugin_1", (String)"bos-wf-analysis", (Object[])new Object[0]), "wf_nodeefficiencyanls"));
            return;
        }
        String fieldName = evt.getFieldName();
        DynamicObject rowData = evt.getRowData();
        if ("nodename".equals(fieldName)) {
            this.nodeNameLinkClick(rowData);
        } else if ("executecount".equals(fieldName)) {
            this.executeCountLinkClick(rowData);
        }
    }

    private void nodeNameLinkClick(DynamicObject rowData) {
        String caption = String.format(ResManager.loadKDString((String)"%s\u4eba\u5458\u6548\u7387\u5206\u6790", (String)"WorkflowNodeEfficiencyReportPlugin_1", (String)"bos-wf-analysis", (Object[])new Object[0]), rowData.getString("nodename"));
        Object[] params = new Object[]{"caption", caption, "nodeId", rowData.getString("nodeid"), "nodeType", rowData.getString("nodetype")};
        this.openReportPage((IFormView)this.getView(), "wf_personefficiencyanls", params);
    }

    private void executeCountLinkClick(DynamicObject rowData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("procname", rowData.getString("procname"));
        params.put("nodeid", rowData.getString("nodeid"));
        params.put("nodename", rowData.getString("nodename"));
        Object[] datas = new Object[]{"processDefinitionId", this.getProcessDefinitionIds(params), "taskDefinitionKey", rowData.getString("nodeid"), "entityNumber", rowData.getString("entitynumber"), "category", rowData.getString("nodetype")};
        this.openHistoricLayout("wf_hitask_layout", datas);
    }

    @Override
    protected String getRunningTimeConfigKey() {
        return "workflow.analysis.nodeScheduleRunningTime";
    }
}

