/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.plugin.report;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.analysis.enumeration.WorkflowReportType;
import kd.bos.workflow.analysis.plugin.report.AbstractWorkflowAnalysisReportPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;

public class WorkflowPersonnelEfficiencyReportPlugin
extends AbstractWorkflowAnalysisReportPlugin {
    private static final String FIELD_DIMENSION = "dimension";

    @Override
    protected WorkflowReportType getReportType() {
        return WorkflowReportType.PERSON;
    }

    @Override
    protected List<String> getRemovedFilterColumnKeys() {
        String nodeType;
        List<String> keys = super.getRemovedFilterColumnKeys();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String nodeId = (String)parameter.getCustomParam("nodeId");
        if (nodeId != null) {
            keys.add("process");
            keys.add("entity");
            keys.add("org");
        }
        if ((nodeType = (String)parameter.getCustomParam("nodeType")) != null) {
            keys.add("activitytype");
        }
        return keys;
    }

    @Override
    protected void showGraphPage() {
        String filterNodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
        Object[] params = new Object[]{"nodeId", filterNodeId};
        DesignerPluginUtil.openFormInContainer((IFormView)this.getView(), (String)"wf_personefficiency_graph", (String)"chartpanel", (Object[])params);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (FIELD_DIMENSION.equals(property)) {
            this.getView().refresh();
        } else {
            super.propertyChanged(e);
        }
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String dimension = (String)this.getModel().getValue(FIELD_DIMENSION);
        queryParam.getCustomParam().put(FIELD_DIMENSION, dimension);
        String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
        if (nodeId != null) {
            QFilter[] filters = new QFilter[]{new QFilter("nodeid", "=", (Object)nodeId)};
            queryParam.getCustomParam().put("filters", filters);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (!WfAdminUtil.isWfAdmin((Long)RequestContext.get().getCurrUserId()) && !PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_personefficiencyanls", (String)"47150e89000000ac")) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u6548\u7387\u5206\u6790\u201d\u9875\u9762\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\u3002", (String)"AbstractWorkflowAnalysisGraphPlugin_1", (String)"bos-wf-analysis", (Object[])new Object[0]), "wf_personefficiencyanls"));
            return;
        }
        String fieldName = evt.getFieldName();
        DynamicObject rowData = evt.getRowData();
        if ("approvecount".equals(fieldName)) {
            this.approveCountLinkClick(rowData);
        }
    }

    private void approveCountLinkClick(DynamicObject rowData) {
        String dimension = (String)this.getModel().getValue(FIELD_DIMENSION);
        long userId = rowData.getLong("userid");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(FIELD_DIMENSION, dimension);
        params.put("userid", userId);
        Object[] datas = null;
        if ("personnel".equals(dimension)) {
            String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
            params.put("org", this.getOrgFilterItemValue());
            params.put("entity", this.getEntityFilterItemValue());
            params.put("process", this.getProcessFilterItemValue());
            datas = new Object[]{"assigneeId", userId, "taskDefinitionKey", nodeId, "processDefinitionId", this.getProcessDefinitionIds(params), "category", this.getNodeTypeFilterItemValue()};
        } else {
            String nodeId = rowData.getString("nodeid");
            String nodeName = rowData.getString("nodename");
            params.put("nodeid", nodeId);
            params.put("nodename", nodeName);
            datas = new Object[]{"assigneeId", userId, "taskDefinitionKey", nodeId, "processDefinitionId", this.getProcessDefinitionIds(params), "category", this.getNodeTypeFilterItemValue()};
        }
        this.openHistoricLayout("wf_hitask_layout", datas);
    }

    @Override
    protected String getRunningTimeConfigKey() {
        return "workflow.analysis.personScheduleRunningTime";
    }
}

