/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.workflow.analysis.cmd.InitNodeAnalysisDatasCmd;
import kd.bos.workflow.analysis.cmd.InitPersonAnalysisDatasCmd;
import kd.bos.workflow.analysis.cmd.InitProcAnalysisDatasCmd;
import kd.bos.workflow.analysis.entity.AnalysisEntityManager;
import kd.bos.workflow.analysis.entity.NodeAnalysisEntityManager;
import kd.bos.workflow.analysis.entity.PersonAnalysisEntityManager;
import kd.bos.workflow.analysis.entity.ProcAnalysisEntityManager;
import kd.bos.workflow.analysis.enumeration.WorkflowReportType;
import kd.bos.workflow.analysis.model.NodeAnalysisBarChartData;
import kd.bos.workflow.analysis.model.ProcAnalysisBarChartData;
import kd.bos.workflow.analysis.service.WorkflowAnalysisService;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.interceptor.Command;

public class WorkflowAnalysisServiceImpl
extends ServiceImpl
implements WorkflowAnalysisService {
    public WorkflowAnalysisServiceImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public void initNodeAnalysisDatas() {
        this.commandExecutor.execute((Command)new InitNodeAnalysisDatasCmd());
    }

    @Override
    public void initProcAnalysisDatas() {
        this.commandExecutor.execute((Command)new InitProcAnalysisDatasCmd());
    }

    @Override
    public void initPersonAnalysisDatas() {
        this.commandExecutor.execute((Command)new InitPersonAnalysisDatasCmd());
    }

    @Override
    public Map<String, Long> getEntityProcessStatistics(ReportQueryParam queryParam) {
        return this.getProcAnalysisEntityManager().getEntityProcessStatistics(queryParam);
    }

    @Override
    public List<ProcAnalysisBarChartData> getProcAnalysisBarChartDatas(ReportQueryParam queryParam) {
        return this.getProcAnalysisEntityManager().getProcAnalysisBarChartDatas(queryParam);
    }

    @Override
    public List<NodeAnalysisBarChartData> getNodeAnalysisBarChartDatas(ReportQueryParam queryParam) {
        return this.getNodeAnalysisEntityManager().getNodeAnalysisBarChartDatas(queryParam);
    }

    @Override
    public List<String> getAnalysisYears(WorkflowReportType type) {
        return this.getAnalysisEntityManager(type).getAnalysisYears();
    }

    @Override
    public Map<String, String> getAnalysisNodeInfo(WorkflowReportType type) {
        return this.getAnalysisEntityManager(type).getAnalysisNodeInfo();
    }

    @Override
    public Map<String, String> getAnalysisNodeTypeInfo(WorkflowReportType type) {
        return this.getAnalysisEntityManager(type).getAnalysisNodeTypeInfo();
    }

    @Override
    public DataSet getAnalysisReportDataSet(WorkflowReportType type, ReportQueryParam param) {
        return this.getAnalysisEntityManager(type).getAnalysisReportDataSet(param);
    }

    @Override
    public Set<Long> getProcessDefinitionIds(WorkflowReportType type, Map<String, Object> params) {
        return this.getAnalysisEntityManager(type).getProcessDefinitionIds(params);
    }

    @Override
    public long getPersonAnalysisCountByUserIdAndNodeType(Long userId, String nodeType) {
        return this.getPersonAnalysisEntityManager().countByUserIdAndNodeType(userId, nodeType);
    }

    private AnalysisEntityManager<?> getAnalysisEntityManager(WorkflowReportType type) {
        switch (type) {
            case NODE: {
                return this.getNodeAnalysisEntityManager();
            }
            case PERSON: {
                return this.getPersonAnalysisEntityManager();
            }
        }
        return this.getProcAnalysisEntityManager();
    }

    private ProcAnalysisEntityManager getProcAnalysisEntityManager() {
        return (ProcAnalysisEntityManager)this.processEngineConfiguration.getEntityManager(ProcAnalysisEntityManager.class);
    }

    private NodeAnalysisEntityManager getNodeAnalysisEntityManager() {
        return (NodeAnalysisEntityManager)this.processEngineConfiguration.getEntityManager(NodeAnalysisEntityManager.class);
    }

    private PersonAnalysisEntityManager getPersonAnalysisEntityManager() {
        return (PersonAnalysisEntityManager)this.processEngineConfiguration.getEntityManager(PersonAnalysisEntityManager.class);
    }
}

