/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.analysis.service.WorkflowAnalysisService;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;

public abstract class AbstractWorkflowAnalysisTask
extends AbstractTask {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        try (DLock tlock = DLock.create((String)String.format("wf/analysis/%s", this.getLockKey()), (String)ResManager.loadKDString((String)"\u5206\u6790\u4e2d\u5fc3\u7edf\u8ba1\u6570\u636e\u521d\u59cb\u5316", (String)"AbstractWorkflowAnalysisTask_1", (String)"bos-wf-analysis", (Object[])new Object[0])).fastMode();){
            boolean lockSuccess = tlock.tryLock(60000L);
            if (lockSuccess) {
                this.initAnalysisDatas(context, param);
            } else {
                this.log.debug(String.format("Task(%s) is locked and executing by another thread.", this.getLockKey()));
            }
        }
    }

    protected WorkflowAnalysisService getAnalysisService() {
        return WorkflowAnalysisUtils.getWorkflowAnalysisService();
    }

    protected abstract String getLockKey();

    protected abstract void initAnalysisDatas(RequestContext var1, Map<String, Object> var2);
}

