/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.analysis.task.AbstractWorkflowAnalysisTask;
import kd.bos.workflow.analysis.task.WorkflowNodeAnalysisTask;
import kd.bos.workflow.analysis.task.WorkflowPersonAnalysisTask;
import kd.bos.workflow.analysis.task.WorkflowProcAnalysisTask;
import kd.bos.workflow.engine.WfUtils;

public class WorkFlowAnalysisTask
extends AbstractTask {
    protected Log log = LogFactory.getLog(WorkFlowAnalysisTask.class);

    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        List<AbstractWorkflowAnalysisTask> analysisTasks = this.getAnalysisTask();
        for (AbstractWorkflowAnalysisTask analysisTask : analysisTasks) {
            try {
                analysisTask.execute(context, param);
            }
            catch (Exception ex) {
                this.log.warn(String.format("Task(%s) is errored. %s", analysisTask.getLockKey(), WfUtils.getExceptionStacktrace((Throwable)ex)));
            }
        }
    }

    private List<AbstractWorkflowAnalysisTask> getAnalysisTask() {
        ArrayList<AbstractWorkflowAnalysisTask> analysisTasks = new ArrayList<AbstractWorkflowAnalysisTask>(3);
        analysisTasks.add(new WorkflowProcAnalysisTask());
        analysisTasks.add(new WorkflowNodeAnalysisTask());
        analysisTasks.add(new WorkflowPersonAnalysisTask());
        return analysisTasks;
    }
}

