/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.util;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.analysis.personnel.DimensionHelperFactory;
import kd.bos.workflow.analysis.personnel.IDimensionHelper;
import kd.bos.workflow.analysis.service.WorkflowAnalysisService;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.beanutils.MethodUtils;

public class WorkflowAnalysisUtils {
    private static Log log = LogFactory.getLog(WorkflowAnalysisUtils.class);

    private WorkflowAnalysisUtils() {
    }

    public static String createAlgoKey(String key) {
        return String.format("wf.analysis.%s", key);
    }

    public static String getManagedOrgIds() {
        String userId = RequestContext.get().getUserId();
        Map ret = WfAdminUtil.getWfAdminCache((String)userId);
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        return (String)ret.get("withSubordinateByConf");
    }

    public static String getOrgFilterSQL(String field) {
        if (!WfConfigurationUtil.isFilterDataByOrg()) {
            return "";
        }
        String ids = WorkflowAnalysisUtils.getManagedOrgIds();
        if (WfUtils.isEmpty((String)ids)) {
            return " AND 1 != 1 ";
        }
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        Collection orgIds = WfUtils.stringToCollection((String)ids, (String)",");
        if (orgIds.contains(rootOrgId)) {
            return "";
        }
        return String.format(" AND %s IN (%s) ", field, ids);
    }

    public static BigDecimal getPercentage(Long count, Long allCount) {
        String regex;
        if (WfUtils.isEmpty((Long)count) || WfUtils.isEmpty((Long)allCount)) {
            return new BigDecimal(0);
        }
        BigDecimal result = new BigDecimal(count).divide(new BigDecimal(allCount), 10, RoundingMode.HALF_UP);
        String percentage = result.stripTrailingZeros().toPlainString();
        if (percentage.matches(regex = "0\\.(0*)([1-9][0-9]*)")) {
            String zeros = percentage.replaceFirst(regex, "$1");
            String nums = String.format("%.3f", Double.valueOf(percentage.replaceFirst(regex, "0.$2"))).replace("0.", "").replaceFirst("1\\.\\d+", "1");
            return new BigDecimal(String.format("0.%s%s", zeros, nums)).multiply(new BigDecimal(100));
        }
        return result;
    }

    public static String getPercentageText(BigDecimal percentage) {
        return String.format("%s%%", percentage.stripTrailingZeros().toPlainString());
    }

    public static ILocaleString getDynamicNodeLocaleStringName() {
        return WfUtils.getPromptWordLocaleString((String)"\u52a8\u6001\u8282\u70b9", (String)"WorkflowAnalysisUtils_1", (String)"bos-wf-analysis");
    }

    public static IDimensionHelper getPersonDimensionQuery(ReportQueryParam param) {
        String dimension = "graph";
        String timeUnit = "minute";
        if (param != null) {
            dimension = (String)param.getCustomParam().get("dimension");
            String paramTimeUnit = (String)param.getCustomParam().get("timeunit");
            if (paramTimeUnit != null) {
                timeUnit = paramTimeUnit;
            }
        }
        IDimensionHelper dimensionHelper = DimensionHelperFactory.getInstance().getDimensionQuery(dimension);
        dimensionHelper.setTimeUnit(timeUnit);
        return dimensionHelper;
    }

    public static SimpleDateFormat getYearsDateFormat() {
        return new SimpleDateFormat("yyyyMM");
    }

    public static SimpleDateFormat getRunningTimeDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static boolean isEnableWorkCalendar() {
        try {
            Boolean enableWorkCalendar = (Boolean)WorkflowAnalysisUtils.invokeWorkflowSupportToolService("isOpenWorkCalendar", null);
            return Boolean.TRUE.equals(enableWorkCalendar);
        }
        catch (Exception e) {
            log.warn(String.format("invoke isOpenWorkCalendar failed. %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            return false;
        }
    }

    public static boolean isUpdateRealDurationReady() {
        try {
            Boolean isReady = (Boolean)WorkflowAnalysisUtils.invokeWorkflowSupportToolService("isCompleteUpdateApprovedDuration", null);
            return Boolean.TRUE.equals(isReady);
        }
        catch (Exception e) {
            log.warn(String.format("invoke isCompleteUpdateApprovedDuration failed. %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            return true;
        }
    }

    public static String getTotalDurationField() {
        return WorkflowAnalysisUtils.isEnableWorkCalendar() ? "FTOTALREALDURATION" : "FTOTALDURATION";
    }

    public static String getMaxDurationField() {
        return WorkflowAnalysisUtils.isEnableWorkCalendar() ? "FMAXREALDURATION" : "FMAXDURATION";
    }

    private static Object invokeWorkflowSupportToolService(String method, Object ... params) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> toolServiceCls = Class.forName("kd.bos.workflow.support.service.WorkflowSupportToolService");
        Object toolService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getService(toolServiceCls);
        return MethodUtils.invokeMethod((Object)toolService, (String)method, (Object[])params);
    }

    public static int getTimeUnitMillisecond(String timeUnit) {
        int millisecond = 1;
        switch (timeUnit) {
            case "minute": {
                millisecond = 60000;
                break;
            }
            case "hour": {
                millisecond = 3600000;
                break;
            }
            case "day": {
                millisecond = 86400000;
                break;
            }
        }
        return millisecond;
    }

    public static String getTimeUnitText(String timeUnit) {
        return WorkflowAnalysisUtils.getTimeUnitText(timeUnit, null);
    }

    public static String getTimeUnitText(String timeUnit, String defaultUnit) {
        String text = "";
        timeUnit = timeUnit != null ? timeUnit : "";
        String minute = ResManager.loadKDString((String)"\u5206\u949f", (String)"WorkflowAnalysisUtils_2", (String)"bos-wf-analysis", (Object[])new Object[0]);
        String hour = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"WorkflowAnalysisUtils_3", (String)"bos-wf-analysis", (Object[])new Object[0]);
        String day = ResManager.loadKDString((String)"\u5929", (String)"WorkflowAnalysisUtils_4", (String)"bos-wf-analysis", (Object[])new Object[0]);
        switch (timeUnit) {
            case "minute": {
                text = minute;
                break;
            }
            case "hour": {
                text = hour;
                break;
            }
            case "day": {
                text = day;
                break;
            }
            default: {
                text = "minute".equals(defaultUnit) ? minute : ("hour".equals(defaultUnit) ? hour : day);
            }
        }
        return text;
    }

    public static WorkflowAnalysisService getWorkflowAnalysisService() {
        return (WorkflowAnalysisService)((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getService(WorkflowAnalysisService.class);
    }

    public static String getGeneralLangSQL(String entityNumber, String fieldName, String propertyName) {
        StringBuilder sql = new StringBuilder();
        String masterTableSQL = "T." + fieldName;
        String multiLangTableSQL = "TL." + fieldName;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty property = entityType.getProperty(propertyName);
        if (property instanceof MuliLangTextProp && !property.isDbIgnore()) {
            sql.append("case when ").append(multiLangTableSQL).append(" is null then ").append(masterTableSQL).append(" when ").append(multiLangTableSQL).append(" = ' ' THEN ").append(masterTableSQL).append(" else ").append(multiLangTableSQL).append(" end");
            return sql.toString();
        }
        return sql.append(multiLangTableSQL).toString();
    }
}

