/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.autogonext.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.autogonext.util.TaskFeatureUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;
import kd.bos.workflow.taskcenter.plugin.util.WorkflowTCDataPluginUtil;

public class ApprovalBeforeClosedPlugin
extends AbstractWorkflowPlugin {
    public static final String PLUGIN_NAME = "kd.bos.workflow.autogonext.plugin.ApprovalBeforeClosedPlugin";
    public static final String CACHEKEY_APPROVALSCENE = "approvalScene";
    public static final String AUTOEXENEXTTASKLIST = "autoExeNextTaskList";

    public void beforeClosed(BeforeClosedEvent e) {
        String approvalScene = this.getPageCache().get(CACHEKEY_APPROVALSCENE);
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        ShowType showType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (WfUtils.isEmpty((String)approvalScene) || "false".equals(approvalScene) || !TaskFeatureUtil.isAutoExeNextTask() || !WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue()) {
            if ("wf_mobilelist_mob".equals(parentFormId) && ShowType.ReplaceHomePage.equals((Object)showType)) {
                ApprovalPluginUtil.showProcessAssistantPage((IFormView)this.getView());
                e.setCancel(true);
                return;
            }
            return;
        }
        FormShowParameter formShowParameter = null;
        boolean isPC = true;
        try {
            if ("wf_msg_center".equals(parentFormId)) {
                formShowParameter = this.getNextFormShowParameterForPC();
            } else if ("wf_mobilelist_mob".equals(parentFormId)) {
                isPC = false;
                formShowParameter = this.getNextFormShowParameterForMob();
            }
        }
        catch (Exception e1) {
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e1));
        }
        if (null == formShowParameter) {
            if (isPC) {
                return;
            }
            if (ShowType.ReplaceHomePage.equals((Object)showType)) {
                ApprovalPluginUtil.showProcessAssistantPage((IFormView)this.getView());
            }
            return;
        }
        this.formatFormShowParameter(formShowParameter);
        Set keySet = this.getPageCache().getAll().keySet();
        keySet.remove(FormShowParameter.class.getSimpleName());
        if (null != keySet && !keySet.isEmpty()) {
            this.getPageCache().batchRemove(new ArrayList(keySet));
        }
        this.getView().showForm(formShowParameter);
        e.setCancel(true);
    }

    private FormShowParameter getNextFormShowParameterForMob() {
        List taskIdsList = (List)this.getView().getFormShowParameter().getCustomParams().get(AUTOEXENEXTTASKLIST);
        if (null == taskIdsList || taskIdsList.isEmpty()) {
            return null;
        }
        String currentSelectRow = this.getPageCache().get("taskid");
        taskIdsList.remove(Long.parseLong(currentSelectRow));
        if (null == taskIdsList || taskIdsList.isEmpty()) {
            return null;
        }
        List<Map<String, Object>> result = this.getApprovalInfo(null, "mobile", taskIdsList);
        if (null == result || result.isEmpty()) {
            return null;
        }
        Long taskId = (Long)result.get(0).get("taskId");
        String formId = (String)result.get(0).get("formId");
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        Map para = this.getView().getFormShowParameter().getCustomParams();
        para.put("taskId", taskId);
        para.put("type", "toHandle");
        formShowParameter.getCustomParams().putAll(para);
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.ReplaceHomePage);
        return formShowParameter;
    }

    private List<Map<String, Object>> getApprovalInfo(String orderBy, String endType, List<Object> taskIds) {
        ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(RequestContext.get().getCurrUserId()), 0, 1, "toHandle", orderBy);
        processDataEntityQueryParams.setEndType(endType);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("taskid", "in", taskIds));
        qFilters.add(new QFilter("source", "=", (Object)"WF"));
        processDataEntityQueryParams.setqFilters(qFilters);
        return this.getTaskService().getProcessAssistantData(processDataEntityQueryParams);
    }

    private void formatFormShowParameter(FormShowParameter formShowParameter) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey(null);
        formShowParameter.setCloseCallBack(parameter.getCloseCallBack());
        formShowParameter.setParentFormId(parameter.getParentFormId());
        formShowParameter.setParentPageId(parameter.getParentPageId());
        formShowParameter.addCustPlugin(PLUGIN_NAME);
    }

    private FormShowParameter getNextFormShowParameterForPC() {
        boolean dealWithSelectedScene;
        IFormView parentView = this.getView().getParentView();
        IListView toHandleListView = (IListView)parentView.getView(parentView.getPageCache().get("menupageid"));
        if (null == toHandleListView) {
            return null;
        }
        ArrayList<Object> taskIds = new ArrayList<Object>();
        ListSelectedRowCollection selectedRows = toHandleListView.getSelectedRows();
        boolean bl = dealWithSelectedScene = selectedRows.size() > 1;
        if (!dealWithSelectedScene) {
            selectedRows = toHandleListView.getCurrentListAllRowCollection();
        }
        if (null == selectedRows || selectedRows.isEmpty()) {
            return null;
        }
        String currentSelectRow = this.getPageCache().get("taskid");
        if (null == currentSelectRow) {
            currentSelectRow = this.getPageCache().get("taskId");
        }
        boolean findCurrentRow = false;
        Object selectedRowValue = null;
        for (ListSelectedRow row : selectedRows) {
            selectedRowValue = row.getPrimaryKeyValue();
            if (findCurrentRow) {
                taskIds.add(selectedRowValue);
                continue;
            }
            if (null == selectedRowValue || !selectedRowValue.toString().equals(currentSelectRow)) continue;
            findCurrentRow = true;
        }
        if (dealWithSelectedScene && taskIds.isEmpty()) {
            return null;
        }
        StringBuilder orderBy = new StringBuilder();
        String orderByStr = toHandleListView.getPageCache().get("pc_filterSqlOrderBy");
        if (null != orderByStr && orderByStr.contains("handlestate")) {
            orderByStr = orderByStr.replace("handlestate", "taskstate");
        }
        orderBy.append(WfUtils.isEmpty((String)orderByStr) ? "" : orderByStr + ",").append(" PRIORITY desc, CREATEDATE desc");
        List<Map<String, Object>> result = this.getApprovalInfo(orderBy.toString(), "pc", taskIds);
        if (null == result || result.isEmpty()) {
            return null;
        }
        Long taskId = (Long)result.get(0).get("taskId");
        FormShowParameter formShowParameter = WorkflowTCDataPluginUtil.getApprovalParameter((Long)taskId, (CloseCallBack)this.getView().getFormShowParameter().getCloseCallBack(), (IFormView)this.getView());
        if (WfUtils.isNotEmptyString((Object)formShowParameter.getCustomParam("errorInfo"))) {
            return null;
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        formShowParameter.setPageId(this.getView().getPageId());
        return formShowParameter;
    }
}

