/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.billapproval.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.billapproval.dto.BillApprovalValidateResult;
import kd.bos.workflow.billapproval.dto.TaskInfoDto;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetTaskInfoForBillApprovalCmd
implements Command<BillApprovalValidateResult>,
Serializable {
    private static Log log = LogFactory.getLog(GetTaskInfoForBillApprovalCmd.class);
    private static final String BATCH_APPROVAL_TRUE = "1-0";
    private static final String BATCH_APPROVAL_REJECT_TRUE = "1-1";
    private static final String BATCH_REJECT_TRUE = "0-1";
    private static final String BATCH_APPROVAL_REJECT_FALSE = "0-0";
    private static final String ALL_APPROVAL = "allapproval";
    private static final String ALL_REJECT = "allreject";
    private static final String ALL_APPROVAL_AND_REJECT = "allapprovalandreject";
    private static final String UN_APPROVAL_AND_REJECT = "unapprovalandreject";
    private static final List<String> CATEGORY = Arrays.asList("AuditTask", "YunzhijiaTask");
    private Map<String, String> variable;
    private Map<String, String> dataEntities;
    private String invokeFrom;

    public GetTaskInfoForBillApprovalCmd(Map<String, String> dataEntities, Map<String, String> variable, String invokeFrom) {
        this.dataEntities = dataEntities;
        this.variable = variable;
        this.invokeFrom = invokeFrom;
    }

    public BillApprovalValidateResult execute(CommandContext commandContext) {
        log.debug("enter GetTaskInfoForBillApprovalCmd.execute");
        if (this.dataEntities == null || this.variable == null || this.invokeFrom == null) {
            return null;
        }
        return GetTaskInfoForBillApprovalCmd.getBillApprovalValidateResult(this.dataEntities, this.variable, this.invokeFrom);
    }

    private static BillApprovalValidateResult getBillApprovalValidateResult(Map<String, String> dataEntities, Map<String, String> variable, String invokeFrom) {
        BillApprovalValidateResult approvalDocumentListResult = new BillApprovalValidateResult(Boolean.TRUE);
        Set<String> businessKeys = dataEntities.keySet();
        Map<String, List<TaskInfoDto>> approvalTaskInfo = GetTaskInfoForBillApprovalCmd.collectTaskInfo(businessKeys);
        Long currentUserId = RequestContext.get().getCurrUserId();
        String openFrom = variable.get("modeltypeforwf");
        String operateName = variable.get("operatename");
        if (approvalTaskInfo != null && approvalTaskInfo.size() > 0) {
            if ("bill".equalsIgnoreCase(openFrom)) {
                approvalDocumentListResult = GetTaskInfoForBillApprovalCmd.getOpenBatchApprovalPage(approvalTaskInfo, currentUserId, dataEntities, invokeFrom, operateName, openFrom);
            } else {
                ArrayList allTask = new ArrayList(16);
                for (Map.Entry<String, List<TaskInfoDto>> temp : approvalTaskInfo.entrySet()) {
                    allTask.addAll(temp.getValue());
                }
                approvalDocumentListResult = allTask.size() > 1 ? GetTaskInfoForBillApprovalCmd.getOpenBatchApprovalPage(approvalTaskInfo, currentUserId, dataEntities, invokeFrom, operateName, null) : GetTaskInfoForBillApprovalCmd.getOpenApprovalPage(approvalTaskInfo, currentUserId, dataEntities, invokeFrom, operateName);
            }
        } else {
            String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("notinprocess", operateName);
            HashMap<String, String> errorInfo = new HashMap<String, String>(dataEntities.size());
            GetTaskInfoForBillApprovalCmd.buildErrorInfo(showTips, approvalTaskInfo, errorInfo, dataEntities);
            GetTaskInfoForBillApprovalCmd.buildErrorResult(approvalDocumentListResult, 1, errorInfo);
        }
        return approvalDocumentListResult;
    }

    private static BillApprovalValidateResult getOpenApprovalPage(Map<String, List<TaskInfoDto>> approvalTaskInfo, Long currentUserId, Map<String, String> dataEntities, String invokeFrom, String operateName) {
        BillApprovalValidateResult result = new BillApprovalValidateResult(Boolean.TRUE, 1);
        HashMap<String, String> errorInfo = new HashMap<String, String>(approvalTaskInfo.size());
        for (Map.Entry<String, List<TaskInfoDto>> map : approvalTaskInfo.entrySet()) {
            List<TaskInfoDto> temp = map.getValue();
            String businessKey = map.getKey();
            if (temp != null && temp.size() > 0) {
                ArrayList<TaskInfoDto> filterTask = new ArrayList<TaskInfoDto>(16);
                for (TaskInfoDto task : temp) {
                    if (!CATEGORY.contains(task.getCategory())) continue;
                    filterTask.add(task);
                }
                if (filterTask.size() > 0) {
                    Set participant = filterTask.stream().map(r -> r.getUserId()).collect(Collectors.toSet());
                    if (participant != null && participant.contains(currentUserId) && participant.size() == 1) {
                        result.setTaskIds(GetTaskInfoForBillApprovalCmd.buildTaskIds(filterTask));
                        continue;
                    }
                    String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("nottaskparticipants", operateName);
                    GetTaskInfoForBillApprovalCmd.buildErrorResultForSingle(showTips, businessKey, errorInfo, result, dataEntities);
                    continue;
                }
                String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("nosuitabletask", operateName);
                GetTaskInfoForBillApprovalCmd.buildErrorResultForSingle(showTips, businessKey, errorInfo, result, dataEntities);
                continue;
            }
            String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("notaskscene", operateName);
            GetTaskInfoForBillApprovalCmd.buildErrorResultForSingle(showTips, businessKey, errorInfo, result, dataEntities);
        }
        if (dataEntities.size() > approvalTaskInfo.size()) {
            String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("notinprocess", operateName);
            GetTaskInfoForBillApprovalCmd.buildErrorInfo(showTips, approvalTaskInfo, errorInfo, dataEntities);
            GetTaskInfoForBillApprovalCmd.buildErrorResult(result, 1, errorInfo);
        }
        return result;
    }

    private static BillApprovalValidateResult getOpenBatchApprovalPage(Map<String, List<TaskInfoDto>> approvalTaskInfo, Long currentUserId, Map<String, String> dataEntities, String invokeFrom, String operateName, String openFrom) {
        BillApprovalValidateResult result = new BillApprovalValidateResult(Boolean.TRUE, 2);
        HashMap<String, String> errorDataMap = new HashMap<String, String>(8);
        if (approvalTaskInfo.size() == dataEntities.size()) {
            ArrayList<TaskInfoDto> afterFilterTask = new ArrayList<TaskInfoDto>(16);
            for (Map.Entry<String, List<TaskInfoDto>> map : approvalTaskInfo.entrySet()) {
                ArrayList<TaskInfoDto> filterCategoryTasks = new ArrayList<TaskInfoDto>(16);
                String businessKey = map.getKey();
                List<TaskInfoDto> taskInfoDtoList = map.getValue();
                for (TaskInfoDto taskInfo : taskInfoDtoList) {
                    if (!CATEGORY.contains(taskInfo.getCategory())) continue;
                    filterCategoryTasks.add(taskInfo);
                }
                if (filterCategoryTasks.size() > 0) {
                    List<TaskInfoDto> filterParticipantTasks = GetTaskInfoForBillApprovalCmd.getFilterTaskByParticipant(currentUserId, filterCategoryTasks);
                    if (filterParticipantTasks.size() > 0) {
                        afterFilterTask.addAll(filterParticipantTasks);
                        continue;
                    }
                    String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("nottaskparticipants", operateName);
                    String errorMessage = dataEntities.get(businessKey) + " :  " + showTips;
                    errorDataMap.put(businessKey, errorMessage);
                    continue;
                }
                String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("nosuitabletask", operateName);
                String errorMessage = dataEntities.get(businessKey) + " :  " + showTips;
                errorDataMap.put(businessKey, errorMessage);
            }
            if (afterFilterTask.size() > 0 && errorDataMap.size() > 0) {
                GetTaskInfoForBillApprovalCmd.buildErrorResult(result, 2, errorDataMap);
                return result;
            }
            if (afterFilterTask.size() == 0) {
                String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("nosuitabletask", operateName);
                GetTaskInfoForBillApprovalCmd.buildErrorInfo(showTips, approvalTaskInfo, errorDataMap, dataEntities);
                GetTaskInfoForBillApprovalCmd.buildErrorResult(result, 2, errorDataMap);
                return result;
            }
            String decisionType = GetTaskInfoForBillApprovalCmd.getDecisionType(afterFilterTask);
            if (decisionType.equalsIgnoreCase(UN_APPROVAL_AND_REJECT)) {
                String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("cannotbatchapproval", operateName);
                result.setSuccess(false);
                result.setErrorMessage(showTips);
                return result;
            }
            result.setDecisionType(decisionType);
            result.setTaskIds(GetTaskInfoForBillApprovalCmd.buildTaskIds(afterFilterTask));
            if (afterFilterTask.size() == 1 && WfUtils.isEmpty((String)openFrom)) {
                result.setApprovalType(1);
            }
        } else {
            String showTips = GetTaskInfoForBillApprovalCmd.getMessageByType("inprocesspart", operateName);
            GetTaskInfoForBillApprovalCmd.buildErrorInfo(showTips, approvalTaskInfo, errorDataMap, dataEntities);
            GetTaskInfoForBillApprovalCmd.buildErrorResult(result, 2, errorDataMap);
        }
        return result;
    }

    private static List<TaskInfoDto> getFilterTaskByParticipant(Long currentUserId, List<TaskInfoDto> taskInfoDtoList) {
        ArrayList<TaskInfoDto> filterTaskParticipants = new ArrayList<TaskInfoDto>(taskInfoDtoList.size());
        for (TaskInfoDto task : taskInfoDtoList) {
            if (currentUserId.longValue() != task.getUserId().longValue()) continue;
            filterTaskParticipants.add(task);
        }
        return filterTaskParticipants;
    }

    private static void buildErrorResultForSingle(String showTips, String pk, Map<String, String> errorInfo, BillApprovalValidateResult result, Map<String, String> dataEntities) {
        String billNo = dataEntities.get(pk);
        errorInfo.put(pk, billNo + " :  " + showTips);
        GetTaskInfoForBillApprovalCmd.buildErrorResult(result, 1, errorInfo);
    }

    private static void buildErrorInfo(String errorMessage, Map<String, List<TaskInfoDto>> approvalTaskInfo, Map<String, String> errorInfo, Map<String, String> dataEntities) {
        Set<String> inProcessPks = approvalTaskInfo.keySet();
        for (Map.Entry<String, String> item : dataEntities.entrySet()) {
            if (inProcessPks.contains(item.getKey())) continue;
            String showTips = item.getValue() + " :  " + errorMessage;
            errorInfo.put(item.getKey(), showTips);
        }
    }

    private static void buildErrorResult(BillApprovalValidateResult result, int approvalType, Map<String, String> errorInfo) {
        result.setSuccess(Boolean.FALSE);
        result.setApprovalType(approvalType);
        result.setErrorInfo(errorInfo);
    }

    private static String getMessageByType(String type, String operateName) {
        String showTips = "";
        switch (type) {
            case "nottaskparticipants": {
                showTips = String.format(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u6d41\u7a0b\u7684\u5f53\u524d\u5904\u7406\u4eba\uff0c\u4e0d\u80fd\u8fdb\u884c%s\u3002", (String)"WfApprovalOperate_4", (String)"bos-wf-feature", (Object[])new Object[0]), operateName);
                break;
            }
            case "nosuitabletask": 
            case "notaskscene": {
                showTips = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u5f85\u5ba1\u6279\u7684\u6d41\u7a0b\u4efb\u52a1\u3002", (String)"WfApprovalOperate_5", (String)"bos-wf-feature", (Object[])new Object[0]);
                break;
            }
            case "inprocesspart": 
            case "notinprocess": {
                showTips = ResManager.loadKDString((String)"\u5355\u636e\u672a\u8fdb\u5165\u6d41\u7a0b\uff0c\u4e0d\u80fd\u8fdb\u884c\u6d41\u7a0b\u5ba1\u6279\u3002", (String)"WfApprovalOperate_6", (String)"bos-wf-feature", (Object[])new Object[0]);
                break;
            }
            case "cannotbatchapproval": {
                showTips = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e2d\uff0c\u5305\u542b\u672a\u5f00\u542f\u6d41\u7a0b\u6279\u91cf\u540c\u610f\u6216\u6279\u91cf\u9a73\u56de\u529f\u80fd\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u6279\u91cf\u5904\u7406\uff0c\u8bf7\u8054\u7cfb\u6d41\u7a0b\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e\u3002", (String)"WfApprovalOperate_8", (String)"bos-wf-feature", (Object[])new Object[0]);
                break;
            }
        }
        return showTips;
    }

    private static String buildTaskIds(List<TaskInfoDto> taskList) {
        String taskIdStr = "";
        if (taskList.size() > 1) {
            Set taskIds = taskList.stream().map(r -> r.getTaskId().toString()).collect(Collectors.toSet());
            taskIdStr = taskIds.stream().collect(Collectors.joining(","));
        } else {
            taskIdStr = taskList.get(0).getTaskId().toString();
        }
        return taskIdStr;
    }

    private static List<String> buildBillNos(Map<String, String> dataEntities, Set<String> businessKeys, String invokeFrom) {
        ArrayList<String> billnoList = new ArrayList<String>(16);
        Set<String> chooseBusinessKeys = dataEntities.keySet();
        Set<Object> tipsBusinessKeys = new HashSet(8);
        if ("invokefromnewop".equalsIgnoreCase(invokeFrom)) {
            tipsBusinessKeys = chooseBusinessKeys.stream().filter(e -> !businessKeys.contains(e)).collect(Collectors.toSet());
        } else if ("invokefromauditop".equalsIgnoreCase(invokeFrom)) {
            tipsBusinessKeys = chooseBusinessKeys.stream().filter(businessKeys::contains).collect(Collectors.toSet());
        }
        for (Map.Entry<String, String> item : dataEntities.entrySet()) {
            for (String string : tipsBusinessKeys) {
                if (!string.equalsIgnoreCase(item.getKey())) continue;
                billnoList.add(item.getValue());
            }
        }
        return billnoList;
    }

    private static String getDecisionType(List<TaskInfoDto> taskInfoDtoList) {
        String result = "";
        int approvalSize = 0;
        int rejectSize = 0;
        int approvalAndRejectSize = 0;
        int approvalAndRejectNoSize = 0;
        int allTaskSize = taskInfoDtoList.size();
        for (TaskInfoDto taskInfoDto : taskInfoDtoList) {
            if (BATCH_APPROVAL_TRUE.equalsIgnoreCase(taskInfoDto.getBatchOp())) {
                ++approvalSize;
                continue;
            }
            if (BATCH_APPROVAL_REJECT_TRUE.equalsIgnoreCase(taskInfoDto.getBatchOp())) {
                ++approvalAndRejectSize;
                continue;
            }
            if (BATCH_REJECT_TRUE.equalsIgnoreCase(taskInfoDto.getBatchOp())) {
                ++rejectSize;
                continue;
            }
            if (!BATCH_APPROVAL_REJECT_FALSE.equalsIgnoreCase(taskInfoDto.getBatchOp())) continue;
            ++approvalAndRejectNoSize;
        }
        result = allTaskSize == approvalSize || approvalSize + approvalAndRejectSize == allTaskSize && allTaskSize != approvalAndRejectSize ? ALL_APPROVAL : (allTaskSize == rejectSize || rejectSize + approvalAndRejectSize == allTaskSize && allTaskSize != approvalAndRejectSize ? ALL_REJECT : (allTaskSize == approvalAndRejectSize ? ALL_APPROVAL_AND_REJECT : UN_APPROVAL_AND_REJECT));
        return result;
    }

    private static Map<String, List<TaskInfoDto>> collectTaskInfo(Set<String> businessKeys) {
        String executeSql = "";
        HashMap<String, List<TaskInfoDto>> ret = new HashMap<String, List<TaskInfoDto>>(8);
        StringBuilder sql = new StringBuilder();
        Object[] params = businessKeys.toArray(new Object[businessKeys.size()]);
        sql.append("select  p.fuserid ,p.fcategory ,t.fbatchop ,p.ftaskid,p.fbusinesskey");
        sql.append(" from t_wf_task t  left join  t_wf_participant p  on  t.fid =p.ftaskid");
        sql.append(" where t.fbusinesskey in (?) ");
        sql.append(" and p.ftype='participant'");
        sql.append(" and p.ftaskid > 0 and p.fcompositetaskid = 0 and t.fisdisplay = '1' and t.fendtype != 'mobile' and p.fisdisplay = '1' ");
        executeSql = sql.toString().replaceAll("\\?", WfUtils.getQuestionMarkList((int)businessKeys.size()));
        try (DataSet ds = DB.queryDataSet((String)"GetTaskInfoForBillApprovalCmd.collectTaskInfo", (DBRoute)DBRoute.workflow, (String)executeSql, (Object[])params);){
            for (Row row : ds) {
                TaskInfoDto taskInfoDto = new TaskInfoDto();
                taskInfoDto.setUserId(row.getLong("fuserid"));
                taskInfoDto.setTaskId(row.getLong("ftaskid"));
                taskInfoDto.setBatchOp(row.getString("fbatchop"));
                taskInfoDto.setCategory(row.getString("fcategory"));
                String businessKey = row.getString("fbusinesskey");
                ArrayList<TaskInfoDto> taskInfoDtos = (ArrayList<TaskInfoDto>)ret.get(businessKey);
                if (taskInfoDtos != null) {
                    taskInfoDtos.add(taskInfoDto);
                } else {
                    taskInfoDtos = new ArrayList<TaskInfoDto>();
                    taskInfoDtos.add(taskInfoDto);
                }
                ret.put(businessKey, taskInfoDtos);
            }
        }
        catch (Exception e) {
            log.error("GetTaskInfoForBillApprovalCmd.collectTaskInfo occurred exception:" + e.getMessage());
        }
        return ret;
    }
}

