/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.billapproval.operate;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.workflow.billapproval.cmd.GetTaskInfoForBillApprovalCmd;
import kd.bos.workflow.billapproval.dto.BillApprovalValidateResult;
import kd.bos.workflow.engine.WfCommandUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.feature.FeatureService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WfApprovalOperate
extends FormOperate {
    public OperationResult invokeOperation() {
        IFormView view = this.getView();
        String modelType = view.getFormShowParameter().getFormConfig().getModelType();
        if ("mobilebase".equalsIgnoreCase(modelType) || "mobilebill".equalsIgnoreCase(modelType) || "mobileform".equalsIgnoreCase(modelType) || "mobilelist".equalsIgnoreCase(modelType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\u201c\u6d41\u7a0b\u5ba1\u6279\u201d\u64cd\u4f5c\u3002", (String)"WfApprovalOperate_1", (String)"bos-wf-feature", (Object[])new Object[0]), Integer.valueOf(3000));
            return null;
        }
        ListSelectedRowCollection chooseData = this.getListSelectedData();
        if (null == chooseData) {
            StandardTips.view((IFormView)view).notSelectRow();
            return null;
        }
        try {
            int chooseSize = 0;
            String entityNumber = this.getEntityNumber(view);
            Map<String, String> dataEntities = null;
            if ("bill".equalsIgnoreCase(modelType)) {
                chooseSize = 1;
                dataEntities = this.buildDataEntityForEditPage();
            } else {
                chooseSize = chooseData.size();
                dataEntities = this.buildDataEntity(chooseData);
            }
            Map variables = this.getOption().getVariables();
            if (variables != null) {
                variables.put("operatename", this.getOperateName().toString());
                variables.put("modeltypeforwf", modelType);
                variables.put("choosesize", String.valueOf(chooseSize));
            }
            FeatureService featureService = (FeatureService)ServiceFactory.getService(FeatureService.class);
            BillApprovalValidateResult validateResult = (BillApprovalValidateResult)WfCommandUtil.getCommandExecutor().execute((Command)new GetTaskInfoForBillApprovalCmd(dataEntities, variables, "invokefromnewop"));
            if (validateResult != null) {
                if (validateResult.isSuccess().booleanValue()) {
                    this.openApprovalPage(featureService, validateResult, variables);
                } else {
                    this.showErrorMessage(entityNumber, validateResult, dataEntities, view, chooseSize);
                }
            }
        }
        catch (Exception e) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u5ba1\u6279\u201d\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WfApprovalOperate_2", (String)"bos-wf-feature", (Object[])new Object[0]), e.getMessage()));
            return null;
        }
        return null;
    }

    private void showErrorMessage(String entityNumber, BillApprovalValidateResult validateResult, Map<String, String> dataEntities, IFormView view, int chooseSize) {
        if (validateResult != null) {
            if (WfUtils.isNotEmpty((String)validateResult.getErrorMessage())) {
                view.showTipNotification(validateResult.getErrorMessage(), Integer.valueOf(3000));
            } else if (validateResult.getErrorInfo() != null) {
                this.showOperationResult(entityNumber, validateResult, chooseSize, dataEntities);
            }
        }
    }

    private void openApprovalPage(FeatureService featureService, BillApprovalValidateResult validateResult, Map<String, String> variables) {
        FormShowParameter formShowParameter = null;
        String taskIds = validateResult.getTaskIds();
        String[] taskIdArray = taskIds.split(",");
        if (validateResult.getApprovalType() == 1) {
            Long taskId = Long.valueOf(taskIdArray[0]);
            formShowParameter = featureService.getWfBillApprovalPageParameter(variables, taskId, null);
        } else if (this.checkBatchApproval(taskIdArray)) {
            String decisionType = validateResult.getDecisionType();
            if (variables != null) {
                variables.put("decisiontype", decisionType);
            }
            formShowParameter = featureService.getWfBillBatchApprovalPageParameter(variables, taskIds, null);
        }
        if (formShowParameter != null) {
            this.getView().showForm(formShowParameter);
        }
    }

    private Map<String, String> buildDataEntity(ListSelectedRowCollection chooseData) {
        HashMap<String, String> dataMap = new HashMap<String, String>(8);
        for (int i = 0; i < chooseData.size(); ++i) {
            String businessKey = chooseData.get(i).getPrimaryKeyValue().toString();
            String billNo = chooseData.get(i).getBillNo();
            dataMap.put(businessKey, billNo);
        }
        return dataMap;
    }

    private Map<String, String> buildDataEntityForEditPage() {
        HashMap<String, String> dataMap = new HashMap<String, String>(8);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        String billno = "";
        if (dataEntity != null) {
            billno = dataEntity.getString("billno");
            String pk = dataEntity.getPkValue() != null ? dataEntity.getPkValue().toString() : "";
            dataMap.put(pk, billno);
        }
        return dataMap;
    }

    private String getEntityNumber(IFormView view) {
        String entityNumber = "";
        if (view instanceof ListView) {
            entityNumber = ((ListView)view).getEntityTypeId();
        } else if (view instanceof BillView) {
            entityNumber = ((BillView)view).getEntityId();
        } else if (view instanceof BaseView) {
            entityNumber = ((BaseView)view).getEntityId();
        }
        return entityNumber;
    }

    private void showOperationResult(String entityNumber, BillApprovalValidateResult validateResult, int chooseSize, Map<String, String> dataEntities) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_operationresult");
        parameter.setPageId(UUID.randomUUID().toString());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        JSONArray jsonArray = new JSONArray();
        int errorSize = 0;
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        for (Map.Entry<String, String> errorMessage : validateResult.getErrorInfo().entrySet()) {
            jsonArray.add((Object)errorMessage.getValue());
            ++errorSize;
        }
        if (chooseSize == 1) {
            this.getView().showErrorNotification(jsonArray.get(0).toString());
            return;
        }
        customParams.put("title", String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4s\u6761", (String)"WfApprovalOperate_9", (String)"bos-wf-feature", (Object[])new Object[0]), chooseSize, this.getOperateName(), 0, errorSize));
        customParams.put("errorMsg", jsonArray);
        customParams.put("message", ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u5b58\u5728\u6821\u9a8c\u672a\u901a\u8fc7\u7684\u6570\u636e\uff0c\u6d41\u7a0b\u5ba1\u6279\u64cd\u4f5c\u5c06\u4e0d\u4f1a\u6267\u884c\u3002", (String)"WfApprovalOperate_11", (String)"bos-wf-feature", (Object[])new Object[0]));
        if (errorSize > 5) {
            customParams.put("hasMore", true);
            customParams.put("pkNumbers", validateResult.getErrorInfo());
            customParams.put("operateName", this.getOperateName().toString());
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            OperationResult operationResult = this.buildOperationResult(entityNumber, validateResult, dataEntities);
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(true);
            String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
            pageCache.put("operationresult", serialResult);
        }
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private OperationResult buildOperationResult(String entityNumber, BillApprovalValidateResult billApprovalValidateResult, Map<String, String> dataEntities) {
        OperationResult operationResult = new OperationResult();
        ValidateResultCollection validateResultCollection = new ValidateResultCollection();
        String title = this.getOperateName().toString();
        Map<String, String> errorInfo = billApprovalValidateResult.getErrorInfo();
        if (billApprovalValidateResult != null && errorInfo != null) {
            int i = 0;
            for (Map.Entry<String, String> item : errorInfo.entrySet()) {
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)item.getKey(), i++, 0, "errorcode_001", title, item.getValue(), ErrorLevel.FatalError);
                info.setEntityKey(entityNumber);
                info.setSubRowIndex(0);
                ValidateResult validateResult = new ValidateResult();
                validateResult.addErrorInfo((OperateErrorInfo)info);
                validateResult.setValidatorKey(title);
                validateResult.setSuccess(Boolean.FALSE.booleanValue());
                validateResult.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"WfApprovalOperate_10", (String)"bos-wf-feature", (Object[])new Object[0]));
                validateResultCollection.addValidateError(title, validateResult);
            }
            operationResult.setValidateResult(validateResultCollection);
            operationResult.setBillCount(dataEntities.size());
            operationResult.setSuccess(false);
        }
        return operationResult;
    }

    private boolean checkBatchApproval(String[] taskId) {
        int maxCount = WfConfigurationUtil.getMaxBatchDealCount();
        if (taskId.length > maxCount) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u6279\u91cf\u5904\u7406%s\u6761\u4efb\u52a1\u3002", (String)"WorkflowTCDataPlugin_58", (String)"bos-wf-formplugin", (Object[])new Object[0]), maxCount));
            return false;
        }
        ArrayList<Long> taskIds = new ArrayList<Long>(taskId.length);
        for (String id : taskId) {
            taskIds.add(Long.parseLong(id));
        }
        boolean isContainCoordinateRecored = CoordinateRecordUtil.getIsContainCoordinateRecored(taskIds);
        if (isContainCoordinateRecored) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5305\u542b\u201c%s\u201d\u4efb\u52a1\uff0c\u65e0\u6cd5\u6279\u91cf\u5ba1\u6279\u3002", (String)"WorkflowTCDataPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName()), Integer.valueOf(3000));
            return false;
        }
        return true;
    }
}

