/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.billapproval.service;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.billapproval.plugin.callback.WfBillApprovalPageCloseCallBack;
import kd.bos.workflow.billapproval.plugin.callback.WfBillBatchApprovalPageCloseCallBack;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.feature.FeatureService;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WfBillApprovalServiceImpl
extends ServiceImpl
implements FeatureService {
    private static Log log = LogFactory.getLog(WfBillApprovalServiceImpl.class);

    public FormShowParameter getWfBillApprovalPageParameter(Map<String, String> variables1, Long taskId, CloseCallBack closeCallBack) {
        Boolean active;
        FormShowParameter parameter = new FormShowParameter();
        String ERROR_INFO = "errorInfo";
        String TYPE = "toHandle";
        TaskInfo entity = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService().findTaskByIdAndType(taskId, "toHandle");
        if (entity == null) {
            parameter.setCustomParam("errorInfo", (Object)"taskIsNotExist");
            return parameter;
        }
        String entityNumber = entity.getEntityNumber();
        String businessKey = entity.getBusinessKey();
        if (WfUtils.isNotEmpty((String)entityNumber) && WfUtils.isNotEmpty((String)businessKey)) {
            boolean isBillExist = true;
            try {
                isBillExist = WfUtils.exist((String)entity.getEntityNumber(), (Object)entity.getBusinessKey());
            }
            catch (Exception e) {
                isBillExist = false;
            }
            if (!isBillExist) {
                parameter.setCustomParam("errorInfo", (Object)WFMultiLangConstants.getBillNotExistTip());
                return parameter;
            }
        }
        if (StringUtils.isNotBlank((Object)(active = Boolean.valueOf(entity.isActive()))) && !active.booleanValue()) {
            parameter.setCustomParam("errorInfo", (Object)ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u80fd\u5904\u7406\u3002", (String)"WorkflowTCDataPluginUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return parameter;
        }
        String processingpage = entity.getProcessingPage();
        if (WfUtils.isEmpty((String)processingpage) || processingpage.equals("wf_approvalpage")) {
            processingpage = "wf_approvalpage_bac";
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("taskId", taskId);
        customParams.put("type", "toHandle");
        customParams.put("billExist", Boolean.TRUE);
        ILocaleString captain = entity.getCaptionPC();
        if (null == captain || WfUtils.isEmpty((ILocaleString)captain)) {
            ILocaleString entityNameLocal = entity.getEntityName();
            ILocaleString entityName = WfUtils.isNotEmpty((ILocaleString)entityNameLocal) ? entityNameLocal : WfUtils.getMultiLangValue((String)"");
            captain = WfMultiLangUtils.getMultiLangValueCaption((ILocaleString)entity.getStartName(), (ILocaleString)entityName);
        }
        if (captain != null && !WfUtils.isEmpty((String)captain.getLocaleValue())) {
            customParams.put("pCaption", captain.getLocaleValue());
        }
        if (!"toHandle".equals("toHandle")) {
            customParams.put("onlyView", Boolean.TRUE);
        }
        if ("botp_convertop".equals(processingpage)) {
            processingpage = "wf_approvalpage_bac";
            customParams.put("onlyView", Boolean.TRUE);
        }
        if (entity.getControl() != null) {
            customParams.put("control", entity.getControl());
        }
        if (entity.getEntityNumber() != null) {
            customParams.put("entityNumber", entity.getEntityNumber());
        }
        if (entity.getBusinessKey() != null) {
            customParams.put("businessKey", entity.getBusinessKey());
        }
        if (entity.getProcessInstanceId() != null) {
            customParams.put("procInstId", entity.getProcessInstanceId());
        }
        customParams.put("processDefinitionId", entity.getProcessDefinitionId());
        customParams.put("processInstanceId", entity.getProcessInstanceId());
        customParams.put("category", entity.getCategory());
        customParams.put("taskdefinitionkey", entity.getTaskDefinitionKey());
        parameter.setPageId(UUID.randomUUID().toString());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParams(customParams);
        parameter.setFormId(processingpage);
        if (closeCallBack != null) {
            parameter.setCloseCallBack(closeCallBack);
        } else {
            closeCallBack = new CloseCallBack(WfBillApprovalPageCloseCallBack.class.getName(), "wfBillApprovalPage");
            parameter.setCloseCallBack(closeCallBack);
        }
        return parameter;
    }

    public FormShowParameter getWfBillBatchApprovalPageParameter(Map<String, String> variables, String taskIds, CloseCallBack closeCallBack) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_bill_batchapprovalpage");
        parameter.setPageId(UUID.randomUUID().toString());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        customParams.put("taskIds", taskIds);
        if (variables != null && variables.get("decisiontype") != null) {
            customParams.put("decisiontype", variables.get("decisiontype"));
        }
        if (variables != null) {
            customParams.put("choosesize", variables.get("choosesize") == null ? "0" : variables.get("choosesize"));
        }
        parameter.setCustomParams(customParams);
        if (closeCallBack == null) {
            closeCallBack = new CloseCallBack(WfBillBatchApprovalPageCloseCallBack.class.getName(), "wfBillBatchApprovalPage");
            parameter.setCloseCallBack(closeCallBack);
        } else {
            parameter.setCloseCallBack(closeCallBack);
        }
        return parameter;
    }
}

