/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.cache;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.workflow.engine.WfUtils;

public class WfFeaturesCacheHelper {
    public static final String WORKFLOWDISTRICT = "workflow";
    private static DistributeSessionlessCache disCache = null;
    private static final int EightHours = 28800;
    private static final int TenMinutes = 600;
    private static final int FourHours = 14400;
    private static final int OneHour = 3600;
    private static final int ThreeDays = 259200;
    private static final int TwoMINITUE = 120;
    private static final String CROSSTENANTTOKEN = "crossTenantToken";
    private static final String TRDBUSINESSOBJECTDATASOURCE = "trdBusinessObjectDataSource";
    private static final String AUTOGONEXTTASK = "autoGoNextTask";

    private static DistributeSessionlessCache getDisCache() {
        if (disCache == null) {
            disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(WORKFLOWDISTRICT, new DistributeCacheHAPolicy());
        }
        return disCache;
    }

    public static String getAccountId() {
        return CacheKeyUtil.getAcctId();
    }

    public static String getWholeKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(WfFeaturesCacheHelper.getAccountId()).append(".wf.features");
        return WfUtils.strAppend((String)sb.toString(), (String)".", (String[])args);
    }

    public static void putTenantToken(String tenantId, String accountId, String token) {
        String key = WfFeaturesCacheHelper.getWholeKey(CROSSTENANTTOKEN, String.format("%s.%s", tenantId, accountId));
        WfFeaturesCacheHelper.getDisCache().put(key, (Object)token, 6600);
    }

    public static String getTenantToken(String tenantId, String accountId) {
        String key = WfFeaturesCacheHelper.getWholeKey(CROSSTENANTTOKEN, String.format("%s.%s", tenantId, accountId));
        return (String)WfFeaturesCacheHelper.getDisCache().get(key);
    }

    public static void putAutoGoNextTask(String userId, boolean value) {
        String key = WfFeaturesCacheHelper.getWholeKey(AUTOGONEXTTASK, userId);
        WfFeaturesCacheHelper.getDisCache().put(key, (Object)Boolean.toString(value), 28800);
    }

    public static void removeAutoGoNextTask(String userId) {
        String key = WfFeaturesCacheHelper.getWholeKey(AUTOGONEXTTASK, userId);
        WfFeaturesCacheHelper.getDisCache().remove(key);
    }

    public static Boolean isAutoGoNextTask(String userId) {
        String key = WfFeaturesCacheHelper.getWholeKey(AUTOGONEXTTASK, userId);
        String value = (String)WfFeaturesCacheHelper.getDisCache().get(key);
        return WfUtils.isEmpty((String)value) ? null : Boolean.valueOf(value);
    }
}

