/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.crosstenant;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.workflow.crosstenant.CrossTenantUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.crosstenant.CrossTenantInfo;
import kd.bos.workflow.engine.crosstenant.CrossTenantProcessHandler;
import kd.bos.workflow.exception.WFEngineException;

public class CrossTenantStartAndEndProcess
implements CrossTenantProcessHandler {
    protected Log logger = LogFactory.getLog((String)this.getClass().getName());

    public void tryTriggerProcess(CrossTenantInfo crossTenantInfo, String businesskey, String operation, String entityNumber, Map<String, Object> variables) {
        Map<String, String> targetTenantTokenAndUrlInfo = CrossTenantUtil.getCrossTenantTorken(crossTenantInfo);
        Map<String, String> header = CrossTenantUtil.getHeaderMap("application/json;charset=UTF-8", "application/json;charset=UTF-8", targetTenantTokenAndUrlInfo.get("token"));
        String postBody = this.getPostBodyForStart(businesskey, operation, entityNumber, variables);
        try {
            HttpClientUtils.postjson((String)CrossTenantUtil.getUrlCarryApi(targetTenantTokenAndUrlInfo.get("targetTenantUrl"), "/kapi/v2/wf/tryTriggerProcess"), header, (String)postBody, (int)6000, (int)10000);
        }
        catch (IOException e) {
            this.logger.error(String.format("Subprocess addressing error:%s", WfUtils.getExceptionStacktrace((Throwable)e)));
            throw new WFEngineException(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public void completeCallActivity(CrossTenantInfo crossTenantInfo, Long parentId, Map<String, Object> variablesForParent) {
        Map<String, String> targetTenantTokenAndUrlInfo = CrossTenantUtil.getCrossTenantTorken(crossTenantInfo);
        String targetUrl = targetTenantTokenAndUrlInfo.get("targetTenantUrl");
        Map<String, String> header = CrossTenantUtil.getHeaderMap("application/json;charset=UTF-8", "application/json;charset=UTF-8", targetTenantTokenAndUrlInfo.get("token"));
        JSONObject postBodyJO = new JSONObject();
        postBodyJO.put("executionId", (Object)parentId);
        postBodyJO.put("variablesForParent", variablesForParent);
        try {
            HttpClientUtils.postjson((String)CrossTenantUtil.getUrlCarryApi(targetUrl, "/kapi/v2/wf/completeCallActivity"), header, (String)postBodyJO.toJSONString());
        }
        catch (IOException e) {
            this.logger.error(String.format("Subprocess over error:%s", WfUtils.getExceptionStacktrace((Throwable)e)));
            throw new WFEngineException(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private String getPostBodyForStart(String businesskey, String operation, String entityNumber, Map<String, Object> variables) {
        JSONObject body = new JSONObject();
        body.put("businesskey", (Object)businesskey);
        body.put("operation", (Object)operation);
        body.put("entityNumber", (Object)entityNumber);
        body.put("variables", variables);
        return body.toJSONString();
    }
}

