/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.crosstenant;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ISVInfo;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import kd.bos.workflow.cache.WfFeaturesCacheHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.crosstenant.CrossTenantInfo;
import kd.bos.workflow.engine.crosstenant.CrossTenantInformationHelper;
import kd.bos.workflow.engine.crosstenant.TargetTenantInfo;
import kd.bos.workflow.exception.WFErrorCode;
import org.apache.commons.lang.exception.ExceptionUtils;

public class CrossTenantUtil {
    private static Log logger = LogFactory.getLog(CrossTenantUtil.class);
    public static final String KEY_TARGETTENANTURL = "targetTenantUrl";
    public static final String KEY_TOKEN = "token";
    public static final String KEY_TARGETTENANTACCOUNTID = "targetTenantAccountId";
    public static final String KEY_TARGETTENANTNOLOGINTHIRDAPPID = "targetTenantNoLoginThirdAppId";

    public static Map<String, String> getCrossTenantTorken(CrossTenantInfo crossTenantInfo) {
        if (crossTenantInfo == null) {
            return new HashMap<String, String>();
        }
        TargetTenantInfo targetTenantTokenAndUrl = CrossTenantInformationHelper.getCrossTenantInformation((String)CrossTenantUtil.getIsvInfo().getId()).getTargetTenantInfo(crossTenantInfo);
        if (targetTenantTokenAndUrl == null) {
            logger.error("targetTenantTokenAndUrl is null");
            return Collections.emptyMap();
        }
        logger.info("targetTenantTokenAndUrl value is:" + SerializationUtils.toJsonString((Object)targetTenantTokenAndUrl));
        String targetTenantUrl = targetTenantTokenAndUrl.getTargetTenantUrl();
        targetTenantUrl = targetTenantUrl.endsWith("/") ? targetTenantUrl.substring(0, targetTenantUrl.length() - 1) : targetTenantUrl;
        String targetTenantAppId = targetTenantTokenAndUrl.getTargetTenantAppId();
        String targetTenantNoLoginThirdAppId = targetTenantTokenAndUrl.getTargetTenantNoLoginThirdAppId();
        String targetTenantAppSecret = targetTenantTokenAndUrl.getTargetTenantAppSecret();
        String targetTenantUserName = targetTenantTokenAndUrl.getTargetTenantUserName();
        String targetTenantAccountId = targetTenantTokenAndUrl.getTargetTenantAccountId();
        String language = targetTenantTokenAndUrl.getLanguage();
        String nonce = targetTenantTokenAndUrl.getNonce();
        String timestamp = targetTenantTokenAndUrl.getTimestamp();
        logger.info(String.format(" targetTenantAppId is: %s;targetTenantAppSecret is: %s;targetTenantUserName is:%s;targetTenantAccountId is:%s;language is:%s;timestamp is:%s;targetTenantUrl is:%s;", targetTenantAppId, targetTenantAppSecret, targetTenantUserName, targetTenantAccountId, language, timestamp, targetTenantUrl));
        nonce = StringUtils.isEmpty((String)nonce) ? UUID.randomUUID().toString() : nonce;
        timestamp = StringUtils.isEmpty((String)timestamp) ? String.valueOf(System.currentTimeMillis()) : timestamp;
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put(KEY_TARGETTENANTURL, targetTenantUrl);
        result.put(KEY_TARGETTENANTACCOUNTID, targetTenantAccountId);
        result.put(KEY_TARGETTENANTNOLOGINTHIRDAPPID, targetTenantNoLoginThirdAppId);
        String token = WfFeaturesCacheHelper.getTenantToken(crossTenantInfo.getTargetTenantId(), targetTenantAccountId);
        JSONObject postBodyJSONObject = new JSONObject();
        postBodyJSONObject.put("client_id", (Object)targetTenantAppId);
        postBodyJSONObject.put("token_type_hint", (Object)"access_token");
        postBodyJSONObject.put("accountId", (Object)targetTenantAccountId);
        postBodyJSONObject.put("nonce", (Object)nonce);
        postBodyJSONObject.put("timestamp", (Object)timestamp);
        boolean tokenCheckResult = false;
        Map<String, String> headerMap = CrossTenantUtil.getHeaderMap(null, "application/json;charset=UTF-8", null);
        try {
            if (WfUtils.isNotEmpty((String)token)) {
                postBodyJSONObject.put(KEY_TOKEN, (Object)token);
                String checkResult = HttpClientUtils.postjson((String)CrossTenantUtil.getUrlCarryApi(targetTenantUrl, "/kapi/oauth2/verifyToken"), headerMap, (String)postBodyJSONObject.toJSONString());
                JSONObject checkResultJsonObject = JSONObject.parseObject((String)checkResult);
                JSONObject data = checkResultJsonObject == null ? new JSONObject() : checkResultJsonObject.getJSONObject("data");
                tokenCheckResult = data == null ? false : data.getBoolean("active");
            }
            logger.info(String.format("tokenCheckResult is: %s", tokenCheckResult));
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new KDException(WFErrorCode.crossTenantTokenCheckError(), new Object[]{e.getMessage()});
        }
        if (StringUtils.isNotEmpty((String)token) && tokenCheckResult) {
            result.put(KEY_TOKEN, token);
            return result;
        }
        postBodyJSONObject.put("client_secret", (Object)targetTenantAppSecret);
        postBodyJSONObject.put("username", (Object)targetTenantUserName);
        postBodyJSONObject.put("language", (Object)language);
        try {
            postBodyJSONObject.put("nonce", (Object)UUID.randomUUID().toString());
            String tokenResult = HttpClientUtils.postjson((String)CrossTenantUtil.getUrlCarryApi(targetTenantUrl, "/kapi/oauth2/getToken"), headerMap, (String)postBodyJSONObject.toJSONString());
            String access_token = null;
            if (WfUtils.isNotEmpty((String)tokenResult)) {
                JSONObject tokenResultJSONObject = JSONObject.parseObject((String)tokenResult);
                JSONObject data = tokenResultJSONObject.getJSONObject("data");
                if (data == null) {
                    throw new KDException(WFErrorCode.crossTenantTokenGetError(), new Object[]{"Call getToken this Api returns empty data, please check getToken"});
                }
                access_token = data.getString("access_token");
                if (WfUtils.isEmpty((String)access_token)) {
                    throw new KDException(WFErrorCode.crossTenantTokenGetError(), new Object[]{"Call getToken this Api returns empty token, please check getToken"});
                }
            }
            result.put(KEY_TOKEN, access_token);
            WfFeaturesCacheHelper.putTenantToken(crossTenantInfo.getTargetTenantId(), targetTenantAccountId, access_token);
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new KDException(WFErrorCode.crossTenantTokenGetError(), new Object[]{e.getMessage()});
        }
        return result;
    }

    public static Map<String, String> getHeaderMap(String accept, String contentType, String accesstoken) {
        HashMap<String, String> header = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)accept)) {
            header.put("Accept", accept);
        }
        if (StringUtils.isNotEmpty((String)contentType)) {
            header.put("Content-Type", contentType);
        }
        if (StringUtils.isNotEmpty((String)accesstoken)) {
            header.put("accesstoken", accesstoken);
        }
        return header;
    }

    public static ISVInfo getIsvInfo() {
        return ISVServiceHelper.getISVInfo();
    }

    public static String getUrlCarryApi(String url, String api) {
        return url + api;
    }
}

