/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.relservice.biz;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.workflow.crosstenant.CrossTenantUtil;
import kd.bos.workflow.engine.crosstenant.CrossTenantInfo;
import kd.bos.workflow.relservice.biz.BusinessObjectQuery;
import kd.bos.workflow.relservice.biz.context.BusinessObjectQueryContext;
import kd.bos.workflow.util.WfCommonUtil;

public abstract class AbstractHttpBusinessObjectQuery
implements BusinessObjectQuery {
    private static Log logger = LogFactory.getLog(AbstractHttpBusinessObjectQuery.class);
    public static final String REQUESTTYPE_GET = "GET";
    public static final String REQUESTTYPE_POST = "POST";
    public static final int DEFAULT_CONNECTIONTIMEOUT = 3000;
    public static final int DEFAULT_READTIMEOUT = 5000;
    public static final String SUCCESSCODEVALUE = "0";
    public static final String ERRORCODE = "errorCode";
    public static final String STATUS = "status";
    public static final String DATA = "data";
    public static final String ACCESSTOKEN = "accessToken";
    public static final String TARGETTENANTURL = "targetTenantURL";

    public DynamicObject findBusinessObject(String businessKey, String entityNumber, String fields, BusinessObjectQueryContext context) {
        String requestType = this.getRequestType();
        String apiFormat = this.getAPIFormat();
        Map<String, String> requestInfo = this.getRequestInfo(context);
        String accessToken = this.getAccessToken(requestInfo);
        String domain = this.getDomain(requestInfo);
        if (!StringUtils.equalsIgnoreCase((CharSequence)requestType, (CharSequence)REQUESTTYPE_GET) && !StringUtils.equalsIgnoreCase((CharSequence)requestType, (CharSequence)REQUESTTYPE_POST) || StringUtils.isBlank((CharSequence)apiFormat) || StringUtils.isBlank((CharSequence)accessToken) || StringUtils.isBlank((CharSequence)domain) || StringUtils.isBlank((CharSequence)entityNumber)) {
            logger.info(String.format("\u901a\u8fc7HTTP\u8bf7\u6c42\u67e5\u8be2\u4e1a\u52a1\u5bf9\u8c61\u3002API\u8bf7\u6c42\u4fe1\u606f\u9519\u8bef\u6216\u4e0d\u5168\u3002requestType[%s], entityNumber:[%s], businessKey:[%s], fields:[%s]", requestInfo, entityNumber, businessKey, fields));
            return null;
        }
        HashMap<String, Object> param = this.getParam(businessKey, entityNumber, fields);
        param = param != null ? param : new HashMap<String, Object>();
        StringJoiner paramStr = new StringJoiner("&");
        param.forEach((k, v) -> paramStr.add(k + "=" + v));
        String url = String.format("%s/%s", domain, apiFormat);
        if (StringUtils.equalsIgnoreCase((CharSequence)REQUESTTYPE_GET, (CharSequence)requestType) && StringUtils.isNotBlank((CharSequence)paramStr.toString())) {
            url = String.format("%s?%s", url, paramStr);
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("access_token", accessToken);
        Map<Object, Object> extHeader = this.getHeader() == null ? new HashMap() : this.getHeader();
        header.putAll(extHeader);
        Map<String, Object> body = this.getBody(businessKey, entityNumber, fields);
        JSONObject json = new JSONObject();
        json.putAll(body);
        int connectionTimeout = this.getConnectionTimeout() < 0 ? 3000 : this.getConnectionTimeout();
        int readTimeout = this.getReadTimeout() < 0 ? 5000 : this.getReadTimeout();
        logger.info(String.format("\u5f00\u59cb\u8c03\u7528API\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u3002requestType[%s], entityNumber:[%s], businessKey:[%s], fields:[%s]", requestType, entityNumber, businessKey, fields));
        try {
            boolean status;
            String resultStr = "";
            if (StringUtils.equalsIgnoreCase((CharSequence)REQUESTTYPE_GET, (CharSequence)requestType)) {
                resultStr = HttpClientUtils.get((String)url, header, body, (int)connectionTimeout, (int)readTimeout);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)REQUESTTYPE_POST, (CharSequence)requestType)) {
                resultStr = HttpClientUtils.postjson((String)url, header, (String)SerializationUtils.toJsonString((Object)json), (int)connectionTimeout, (int)readTimeout);
            }
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                logger.error("API\u8c03\u7528\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return null;
            }
            JSONObject ret = JSONObject.parseObject((String)resultStr);
            String errorCode = ret.getString(ERRORCODE);
            boolean bl = status = ret.getBoolean(STATUS) != null && ret.getBoolean(STATUS) != false;
            if (SUCCESSCODEVALUE.equals(errorCode) && status) {
                String data = ret.getString(DATA);
                if (StringUtils.isBlank((CharSequence)fields)) {
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)data, (IDataEntityType)dataEntityType);
                }
                List properties = Arrays.stream(fields.trim().split(",")).map(String::trim).collect(Collectors.toList());
                MainEntityType subEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)entityNumber, properties);
                return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)data, (IDataEntityType)subEntityType);
            }
            logger.error(String.format("API\u8c03\u7528\u5931\u8d25\u3002state[%s], errorCode[%s], message[%s]", status, errorCode, ret.get((Object)"message")));
            return null;
        }
        catch (Exception e) {
            logger.error(String.format("\u8c03\u7528API\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f:[%s]", WfCommonUtil.getExceptionDetailStacktrace((Throwable)e)));
            return null;
        }
    }

    public boolean exist(String entityNumber, Object businessKey, BusinessObjectQueryContext context) {
        return true;
    }

    protected Map<String, String> getRequestInfo(BusinessObjectQueryContext context) {
        HashMap<String, String> requestInfo = new HashMap<String, String>();
        if (context == null) {
            return requestInfo;
        }
        String dataSource = context.getDataSourceType();
        if ("CT".equals(dataSource)) {
            CrossTenantInfo crossTenantInfo = null;
            if (context.getExtraQueryParam("crossTenantInfo") != null) {
                String crossTenantInfoStr = (String)context.getExtraQueryParam("crossTenantInfo");
                logger.info("crossTenantInfoStr value is: " + crossTenantInfoStr);
                crossTenantInfo = (CrossTenantInfo)SerializationUtils.fromJsonString((String)crossTenantInfoStr, CrossTenantInfo.class);
            }
            try {
                Map<String, String> targetTenantTokenAndUrlInfo = CrossTenantUtil.getCrossTenantTorken(crossTenantInfo);
                String token = targetTenantTokenAndUrlInfo.get("token");
                String targetTenantURL = targetTenantTokenAndUrlInfo.get("targetTenantUrl");
                requestInfo.put(ACCESSTOKEN, token);
                requestInfo.put(TARGETTENANTURL, targetTenantURL);
            }
            catch (Exception e) {
                logger.error("get crossTenantToken error, message: " + WfCommonUtil.getExceptionDetailStacktrace((Throwable)e));
                throw e;
            }
        }
        return requestInfo;
    }

    protected String getAccessToken(Map<String, String> requestInfo) {
        return requestInfo != null && requestInfo.get(ACCESSTOKEN) != null ? requestInfo.get(ACCESSTOKEN) : null;
    }

    protected String getDomain(Map<String, String> requestInfo) {
        return requestInfo != null && requestInfo.get(TARGETTENANTURL) != null ? requestInfo.get(TARGETTENANTURL) : null;
    }

    protected abstract String getRequestType();

    protected abstract String getAPIFormat();

    protected abstract Map<String, Object> getParam(String var1, String var2, String var3);

    protected abstract Map<String, String> getHeader();

    protected abstract Map<String, Object> getBody(String var1, String var2, String var3);

    protected int getConnectionTimeout() {
        return 3000;
    }

    protected int getReadTimeout() {
        return 5000;
    }
}

