/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.basedata.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;

public class BpmBillRelationModelPlugin
extends AbstractWorkflowPlugin {
    public static final String RELATIONTYPE = "relationtype";
    public static final String PARAMJSON = "paramjson";
    public static final String SRCBILL = "srcbill";
    public static final String TARGETBILL = "targetbill";
    private static final String RELATIONTYPEID = "relationtypeid";
    public static final String RELATIONTYPE_BOTP = "botp";
    public static final String RELATIONTYPE_DAP = "dap";
    public static final String RELATIONTYPE_CORRELATION = "correlation";
    public static final String NUMBER = "number";
    public static final String PROCESS_NUMBER_REGULAR = "^[A-Za-z][A-Za-z0-9_.]*$";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARAMJSON});
    }

    public void afterBindData(EventObject e) {
        this.setParamJsonVisibleState((DynamicObject)this.getModel().getValue(RELATIONTYPEID));
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (PARAMJSON.equals(key)) {
            DynamicObject srcBill = (DynamicObject)this.getModel().getValue(SRCBILL);
            DynamicObject targetBill = (DynamicObject)this.getModel().getValue(TARGETBILL);
            if (srcBill != null && targetBill != null) {
                DynamicObject relationType = (DynamicObject)this.getModel().getValue(RELATIONTYPEID);
                String modelFormId = relationType.getString("modelformid");
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put(SRCBILL, srcBill.get(NUMBER));
                params.put(TARGETBILL, targetBill.get(NUMBER));
                params.put("value", this.getModel().getValue(PARAMJSON));
                this.showForm(PARAMJSON, modelFormId, params);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355\u548c\u76ee\u6807\u5355\u3002", (String)"BpmBillRelationModelPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        String callBackID = event.getActionId();
        if (PARAMJSON.equals(callBackID) && (returnData = event.getReturnData()) instanceof Map && !((Map)returnData).isEmpty()) {
            this.getModel().setValue(PARAMJSON, (Object)SerializationUtils.toJsonString((Object)returnData));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        if (RELATIONTYPEID.equals(propName)) {
            ChangeData[] changeData = e.getChangeSet();
            Object newValue = changeData[0].getNewValue();
            DynamicObject relationType = null;
            if (newValue instanceof DynamicObject) {
                relationType = (DynamicObject)newValue;
                this.getModel().setValue(RELATIONTYPE, (Object)relationType.getString(NUMBER));
            } else {
                this.getModel().setValue(RELATIONTYPE, null);
            }
            this.setParamJsonVisibleState(relationType);
        }
    }

    private void setParamJsonVisibleState(DynamicObject relationType) {
        if (relationType != null && RELATIONTYPE_CORRELATION.equals(relationType.getString(NUMBER))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PARAMJSON});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PARAMJSON});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String number;
        Object key = evt.getSource();
        if (key instanceof Save && ((number = (String)this.getModel().getValue(NUMBER)) == null || !this.matchPattern(PROCESS_NUMBER_REGULAR, number))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u8bf7\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u6216\u70b9\u7684\u7ec4\u5408\u65b9\u5f0f\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"BpmBillRelationTypeListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public boolean matchPattern(String patternStr, String value) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }
}

