/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.basedata.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class BpmCorrelationTypePlugin
extends AbstractWorkflowPlugin {
    public static final String SRCENTITY = "srcentity";
    public static final String TARGETENTITY = "targetentity";
    public static final String FILTERGRIDAP = "filtergridap";
    public static final String SRCFIELD = "srcfield";
    public static final String TARGETFIELD = "targetfield";
    public static final String BTNOK = "btnok";
    private static final String TEXT_TPL = "%s(%s)";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object srcEntity = params.get("srcbill");
        Object targetEntity = params.get("targetbill");
        if (srcEntity == null || targetEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7f3a\u5c11\u6e90\u5355\u548c\u76ee\u6807\u5355\u3002", (String)"BpmCorrelationTypePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        filterGrid.setEntityNumber((String)targetEntity);
        this.getModel().setValue(SRCENTITY, srcEntity);
        this.getModel().setValue(TARGETENTITY, targetEntity);
        this.chanageCustomRelationCfg((String)srcEntity, (String)targetEntity);
        String value = (String)params.get("value");
        if (WfUtils.isNotEmpty((String)value)) {
            Map data = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            String filterGridJson = (String)data.get(FILTERGRIDAP);
            if (WfUtils.isNotEmpty((String)filterGridJson)) {
                this.getPageCache().put(FILTERGRIDAP, filterGridJson);
            }
            this.getModel().setValue(SRCFIELD, data.get(SRCFIELD));
            this.getModel().setValue(TARGETFIELD, data.get(TARGETFIELD));
        }
    }

    private void chanageCustomRelationCfg(String srcEntity, String targetEntity) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String primaryKeyText = String.format(TEXT_TPL, ResManager.loadKDString((String)"\u4e1a\u52a1\u4e3b\u952e", (String)"BpmCorrelationTypePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), "id");
        ComboItem pkItem = new ComboItem(new LocaleString(primaryKeyText), "id");
        ComboItem billNoItem = null;
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)srcEntity);
        String billNo = null;
        if (srcEntityType instanceof BillEntityType) {
            billNo = ((BillEntityType)srcEntityType).getBillNo();
            if (WfUtils.isNotEmpty((String)billNo)) {
                String billNoText = String.format(TEXT_TPL, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"BpmCorrelationTypePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), billNo);
                billNoItem = new ComboItem(new LocaleString(billNoText), billNo);
                items.add(pkItem);
                items.add(billNoItem);
            } else {
                items.add(pkItem);
            }
        } else {
            items.add(pkItem);
        }
        Collection props = srcEntityType.getFields().values();
        for (IDataEntityProperty prop : props) {
            if (billNo != null && billNo.equals(prop.getName()) || !(prop instanceof TextProp) || prop instanceof TextAreaProp || prop instanceof MuliLangTextProp) continue;
            String text = String.format(TEXT_TPL, prop.getDisplayName(), prop.getName());
            ComboItem item = new ComboItem(new LocaleString(text), prop.getName());
            items.add(item);
        }
        ComboEdit combEdit = (ComboEdit)this.getControl(SRCFIELD);
        combEdit.setComboItems(items);
        this.getModel().setValue(SRCFIELD, (Object)"id");
        combEdit.getView().updateView();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        Collection values = entityType.getAllFields().values();
        ArrayList<ComboItem> downItems = new ArrayList<ComboItem>();
        for (IDataEntityProperty prop : values) {
            if (prop instanceof BigIntProp || prop instanceof PKFieldProp || prop instanceof TextProp && !(prop instanceof TextAreaProp) && !(prop instanceof MuliLangTextProp)) {
                IDataEntityType parent = prop.getParent();
                StringBuilder perfix = new StringBuilder();
                if (parent instanceof EntryType) {
                    EntryType et = (EntryType)parent;
                    perfix.append(et.getName()).append('.');
                } else if (parent instanceof SubEntryType) continue;
                perfix.append(prop.getName());
                String text = String.format(TEXT_TPL, prop.getDisplayName(), prop.getName());
                ComboItem tmp = new ComboItem(new LocaleString(text), perfix.toString());
                downItems.add(tmp);
                continue;
            }
            if (!(prop instanceof BasedataProp)) continue;
            BasedataProp bp = (BasedataProp)prop;
            String text = String.format(TEXT_TPL, String.format(ResManager.loadKDString((String)"%s\u4e3b\u952e", (String)"BpmCorrelationTypePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), bp.getDisplayName()), bp.getName());
            downItems.add(new ComboItem(new LocaleString(text), bp.getName()));
        }
        ComboEdit combEditDown = (ComboEdit)this.getControl(TARGETFIELD);
        combEditDown.setComboItems(downItems);
        combEditDown.getView().updateView();
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        if (WfUtils.isNotEmpty((String)filterGrid.getEntityNumber())) {
            Map afterfilterFields = TaskExtendFieldUtil.filterTaskBusinessField((String)filterGrid.getEntityNumber());
            filterGrid.setFilterFieldKeys(new ArrayList(afterfilterFields.keySet()));
        }
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String filterGridJson = this.getPageCache().get(FILTERGRIDAP);
        if (WfUtils.isNotEmpty((String)filterGridJson)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            filterGrid.SetValue((FilterCondition)SerializationUtils.fromJsonString((String)filterGridJson, FilterCondition.class));
            this.getPageCache().remove(FILTERGRIDAP);
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTNOK.equals(key)) {
            Object srcField = this.getModel().getValue(SRCFIELD);
            Object targetField = this.getModel().getValue(TARGETFIELD);
            if (srcField != null && targetField != null) {
                HashMap<String, Object> ret = new HashMap<String, Object>(8);
                FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
                FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
                ret.put(SRCENTITY, this.getView().getFormShowParameter().getCustomParam("srcbill"));
                ret.put(TARGETENTITY, this.getView().getFormShowParameter().getCustomParam("targetbill"));
                ret.put(SRCFIELD, srcField);
                ret.put(TARGETFIELD, targetField);
                ret.put(FILTERGRIDAP, SerializationUtils.toJsonString((Object)filterCondition));
                this.getView().returnDataToParent(ret);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5173\u8054\u5173\u7cfb\u201d\u3002", (String)"BpmCorrelationTypePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
    }
}

