/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.ISupportDesignerModelChange;
import kd.bos.workflow.design.plugin.WorkflowDesignerIDEPlugin;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class BizFlowDesignerIDEPlugin
extends WorkflowDesignerIDEPlugin
implements ISupportDesignerModelChange {
    private static final String PROCESS_CONFIG_RELOAD = "reload";

    @Override
    protected void initStencils(JSONArray stencils, JSONArray confPanels, List<StencilConfig> configs, Set<String> types) {
        String category = null;
        ArrayList<StencilConfig> cfgs = null;
        LinkedHashMap<String, ArrayList<StencilConfig>> classfiedConfigs = new LinkedHashMap<String, ArrayList<StencilConfig>>(8);
        for (StencilConfig stencilConfig : configs) {
            if ("RPATask".equals(stencilConfig.getId()) && DevVerifyServiceHelper.isOEMEnv()) {
                stencilConfig.setCategory("HiddenControl");
                stencilConfig.setVisible(Boolean.FALSE);
            }
            if ("BoundaryCompensateEvent".equals(stencilConfig.getId()) || "CompensateTask".equals(stencilConfig.getId())) {
                this.hideCompensateTaskConfig(stencilConfig);
            }
            if ((cfgs = (List)classfiedConfigs.get(category = stencilConfig.getCategory())) == null) {
                cfgs = new ArrayList<StencilConfig>(8);
                classfiedConfigs.put(category, cfgs);
            }
            cfgs.add(stencilConfig);
        }
        for (Map.Entry entry : classfiedConfigs.entrySet()) {
            category = (String)entry.getKey();
            JSONObject categoryPanel = this.getCategoryJSON(category);
            cfgs = (ArrayList<StencilConfig>)entry.getValue();
            JSONArray items = new JSONArray();
            this.initStencils(category, items, confPanels, types, cfgs);
            if (items.isEmpty()) continue;
            categoryPanel.put("items", (Object)items);
            stencils.add((Object)categoryPanel);
        }
    }

    private void hideCompensateTaskConfig(StencilConfig config) {
        if (config != null && "bizflow".equals(config.getBaseType())) {
            if (WfConfigurationUtil.isHideCompensateTaskConfig()) {
                config.setCategory("HiddenControl");
                config.setVisible(false);
            } else {
                config.setCategory("EventMessageControl");
                config.setVisible(true);
            }
        }
    }

    private JSONObject getCategoryJSON(String category) {
        JSONObject categoryPanel = new JSONObject();
        categoryPanel.put("type", (Object)"flexpanel");
        categoryPanel.put("id", (Object)String.format("%s_category", category));
        JSONObject text = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)text, category);
        categoryPanel.put("text", (Object)text);
        JSONObject style = new JSONObject();
        JSONObject border = new JSONObject();
        border.put("t", (Object)"1px_solid_#e5e5e5");
        style.put("b", (Object)border);
        categoryPanel.put("s", (Object)style);
        categoryPanel.put("wr", (Object)Boolean.TRUE);
        categoryPanel.put("gr", (Object)"1");
        categoryPanel.put("dr", (Object)"row");
        return categoryPanel;
    }

    @Override
    protected JSONObject getStencilJSON(String type, String name, String imgPath) {
        JSONObject stencil = new JSONObject();
        JSONObject width = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)width, "50%");
        stencil.put("w", (Object)width);
        JSONObject style = new JSONObject();
        JSONObject padding = new JSONObject();
        padding.put("b", (Object)"12px");
        padding.put("t", (Object)"12px");
        style.put("m", (Object)padding);
        stencil.put("s", (Object)style);
        stencil.put("ai", (Object)"center");
        stencil.put("jc", (Object)"center");
        stencil.put("id", (Object)String.format("%s_panel", type));
        JSONObject text = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)text, name);
        stencil.put("text", (Object)text);
        stencil.put("wr", (Object)Boolean.FALSE);
        stencil.put("sk", (Object)"0");
        stencil.put("type", (Object)"flexpanel");
        stencil.put("dr", (Object)"column");
        stencil.put("items", (Object)this.getStencilItems(type, name, imgPath));
        return stencil;
    }

    @Override
    protected JSONArray getStencilItems(String type, String name, String imgPath) {
        JSONArray items = new JSONArray();
        items.add((Object)this.getStencilImagePanel(type, name, imgPath));
        JSONObject label = new JSONObject();
        label.put("showStyle", (Object)0);
        JSONObject caption = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)caption, name);
        label.put("caption", (Object)caption);
        label.put("id", (Object)DesignerModelUtil.getStencilLabelKey(type));
        label.put("text", (Object)caption);
        label.put("type", (Object)"label");
        label.put("text-align", (Object)"center");
        label.put("gr", (Object)"0");
        label.put("sk", (Object)"0");
        JSONObject lableWidth = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)lableWidth, "50px");
        label.put("w", (Object)lableWidth);
        label.put("atw", (Object)"true");
        JSONObject style = new JSONObject();
        JSONObject padding = new JSONObject();
        padding.put("t", (Object)"8px");
        style.put("p", (Object)padding);
        label.put("s", (Object)style);
        items.add((Object)label);
        return items;
    }

    private JSONObject getStencilImagePanel(String type, String name, String imgPath) {
        JSONObject imagePanel = new JSONObject();
        imagePanel.put("bc", (Object)"#e3ebff");
        JSONObject width = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)width, "32px");
        imagePanel.put("w", (Object)width);
        JSONObject height = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)height, "32px");
        imagePanel.put("h", (Object)height);
        JSONObject style = new JSONObject();
        JSONObject padding = new JSONObject();
        padding.put("b", (Object)"12px");
        style.put("m", (Object)padding);
        imagePanel.put("s", (Object)style);
        imagePanel.put("rd", (Object)"16px");
        imagePanel.put("ai", (Object)"center");
        imagePanel.put("jc", (Object)"center");
        imagePanel.put("id", (Object)String.format("%s_imgpanel", type));
        JSONObject text = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)text, name);
        imagePanel.put("text", (Object)text);
        imagePanel.put("wr", (Object)Boolean.FALSE);
        imagePanel.put("sk", (Object)Boolean.FALSE);
        imagePanel.put("type", (Object)"flexpanel");
        imagePanel.put("dr", (Object)"column");
        JSONObject image = new JSONObject();
        image.put("showStyle", (Object)0);
        width = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)width, "24px");
        image.put("w", (Object)width);
        image.put("imageKey", (Object)imgPath);
        image.put("clickable", (Object)Boolean.TRUE);
        height = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)height, "24px");
        image.put("h", (Object)height);
        image.put("id", (Object)DesignerModelUtil.getStencilImageKey(type));
        text = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)text, name);
        image.put("text", (Object)text);
        image.put("type", (Object)"image");
        JSONArray items = new JSONArray();
        items.add((Object)image);
        imagePanel.put("items", (Object)items);
        return imagePanel;
    }

    @Override
    protected JSONObject createStencilPairPanel(String panelId) {
        JSONObject pairPanel = super.createStencilPairPanel(panelId);
        pairPanel.remove((Object)"ai");
        return pairPanel;
    }

    @Override
    protected String showNodeConfigure(String formId, String targetKey, String itemId, String type, String nodeTplNumber) {
        String pageId = super.showNodeConfigure(formId, targetKey, itemId, type, nodeTplNumber);
        if ("Diagram".equals(type)) {
            this.getPageCache().remove(PROCESS_CONFIG_RELOAD);
        }
        return pageId;
    }

    @Override
    protected boolean isNodeChanged(String type, String itemId, String nodeId) {
        boolean reload = "true".equals(this.getPageCache().get(PROCESS_CONFIG_RELOAD));
        return "Diagram".equals(type) && reload || super.isNodeChanged(type, itemId, nodeId);
    }

    @Override
    public void beforeRemoveCells(List<GraphCell> cells) {
        GraphModel graphModel = this.getGraphModel();
        for (GraphCell cell : cells) {
            if (!BizFlowPluginUtil.isStartItemCorrelationStencil(cell.getStencil().getId())) continue;
            Map properties = graphModel.getGraphCell(cell.getResourceId()).getProperties();
            cell.getProperties().put("entityNumber", properties.get("entityNumber"));
        }
    }

    @Override
    public void afterRemoveCells(List<GraphCell> cells) {
        GraphCell process = this.getGraphModel().getGraphCell("node_1");
        Map properties = process.getProperties();
        List startItems = (List)properties.get("startItems");
        if (startItems == null) {
            this.log.debug("startItems is null!");
            super.afterRemoveCells(cells);
            return;
        }
        boolean hasCorrelationStencil = false;
        for (GraphCell cell : cells) {
            if (!BizFlowPluginUtil.isStartItemCorrelationStencil(cell.getStencil().getId())) continue;
            hasCorrelationStencil = true;
            String entityNumber = (String)cell.getProperties().get("entityNumber");
            Map<String, Object> startItem = BizFlowPluginUtil.getStartItemByEntityNumber(startItems, entityNumber);
            if (startItem == null) {
                this.log.debug(String.format("startItem is null! cellId: %s", cell.getResourceId()));
                continue;
            }
            String nodeIds = (String)startItem.get("nodeid");
            if ("".equals((nodeIds = this.removeNodeId(nodeIds, cell.getResourceId())).trim())) {
                BizFlowPluginUtil.deleteListItem(startItems, "entitynumber", entityNumber);
                continue;
            }
            startItem.put("nodeid", nodeIds);
        }
        if (hasCorrelationStencil) {
            this.setProcessConfigNeedReload();
        }
        super.afterRemoveCells(cells);
    }

    private String removeNodeId(String nodeIds, String nodeId) {
        if (WfUtils.isEmpty((String)nodeIds) || WfUtils.isEmpty((String)nodeId)) {
            return nodeIds;
        }
        String[] ids = nodeIds.split("\\s+");
        int size = ids.length;
        if (size <= 1) {
            return nodeIds.replace(nodeId, "");
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            String id = ids[i];
            if ("".equals(id.trim()) || id.equals(nodeId)) continue;
            str.append(id);
            if (i >= size - 1) continue;
            str.append(' ');
        }
        return str.toString().trim();
    }

    @Override
    public void afterInsertCells(GraphCell cell) {
        super.afterInsertCells(cell);
    }

    @Override
    public void afterInsertCells(GraphCell edge, String sourceId, GraphCell target, String type) {
        super.afterInsertCells(edge, sourceId, target, type);
    }

    private void setProcessConfigNeedReload() {
        this.getPageCache().put(PROCESS_CONFIG_RELOAD, "true");
    }

    @Override
    protected String getDesignerFormId() {
        return "ide_bizflowdesigner";
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(PROCESS_CONFIG_RELOAD);
    }

    @Override
    public void removeListProperty(String nodeId, String property, String idKey, String idValue) {
        try {
            List<Map<String, Object>> list = this.getListPropertyValue(nodeId, property);
            if (list != null) {
                BizFlowPluginUtil.deleteListItem(list, idKey, idValue);
                if (this.isProcessNode(nodeId)) {
                    this.setProcessConfigNeedReload();
                }
                this.cacheModelJson();
            }
        }
        catch (Exception e) {
            this.log.error(String.format("removeListProperty failed! %s %s %s %s %s", nodeId, property, idKey, idValue, WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    @Override
    public void updateListProperty(String nodeId, String property, String idKey, String idValue, String ... datas) {
        try {
            List<Map<String, Object>> list = this.getListPropertyValue(nodeId, property);
            if (list == null) {
                this.log.debug(String.format("%s's %s is null!", nodeId, property));
                return;
            }
            for (Map<String, Object> item : list) {
                if (!idValue.equals(item.get(idKey))) continue;
                this.setItemPropertiesValues(item, datas);
                if (!this.isProcessNode(nodeId)) break;
                this.setProcessConfigNeedReload();
                break;
            }
            this.cacheModelJson();
        }
        catch (Exception e) {
            this.log.error(String.format("updateListProperty failed! %s %s %s %s %s", nodeId, property, idKey, idValue, WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    private void setItemPropertiesValues(Map<String, Object> item, String ... datas) {
        int length = datas.length;
        for (int i = 0; i < length; ++i) {
            String itemKey = datas[i];
            String itemValue = datas[++i];
            item.put(itemKey, itemValue);
        }
    }

    private boolean isProcessNode(String nodeId) {
        return "node_1".equals(nodeId);
    }

    @Override
    public List<Map<String, Object>> getListPropertyValue(String nodeId, String property) {
        GraphModel graphModel = this.getGraphModel();
        return BizFlowPluginUtil.getListPropertyValue(graphModel, nodeId, property);
    }

    @Override
    public void setObjectProperty(String nodeId, String property, Object value) {
        GraphModel graphModel = this.getGraphModel();
        GraphCell cell = graphModel.getGraphCell(nodeId);
        if (cell != null) {
            BpmnModelUtil.setProperty((Map)cell.getProperties(), (String)property, (Object)value);
            if (this.isProcessNode(nodeId)) {
                this.setProcessConfigNeedReload();
            }
            this.cacheModelJson();
        }
    }

    @Override
    protected String getDefaultNodeStyle(String stencilType) {
        if ("Lane".equals(stencilType) || "Pool".equals(stencilType)) {
            return super.getDefaultNodeStyle(stencilType);
        }
        return String.format("%s%s=%s;", "whiteSpace=wrap;spacingLeft=50;spacingRight=10;overflow=hidden;", "resizable", "0");
    }

    @Override
    public void connect(GraphCell edge, String sourceId, String targetId) {
        GraphModel graphModel;
        GraphCell source;
        if (sourceId != null && "BoundaryCompensateEvent".equals((source = (graphModel = this.getGraphModel()).getGraphCell(sourceId)).getStencil().getId())) {
            GraphCell target = graphModel.getGraphCell(targetId);
            graphModel.setProperty(targetId, target.getStencil().getId(), "forCompensation", true);
        }
        super.connect(edge, sourceId, targetId);
    }
}

