/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.WorkflowProcessPropConfPlugin;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public class BizFlowProcessPropConfPlugin
extends WorkflowProcessPropConfPlugin {
    private static final String ENTITY_STARTITEMS = "startitems";
    private static final String STARTITEMS_CONDITION = "startitems_condition";
    private static final String SV_STARTITEMS_CONDITION = "sv_startitems_condition";
    private static final String STARTITEMS_OPERATION = "startitems_operation";
    private static final String SV_STARTITEMS_OPERATION = "sv_startitems_operation";
    private static final String STARTITEMS_ENTITYNUMBER = "startitems_entitynumber";
    private static final String STARTITEMS_BATCHNUMBER = "startitems_batchnumber";
    private static final String STARTITEMS_BATCHNUMNAME = "startitems_batchnumname";
    private static final String STARTITEMS_NODEID = "startitems_nodeid";
    private static final String STARTITEMS_ALLOWSTART = "startitems_allowstart";
    private static final String BIZEVENT = "bizevent";
    private static final String EVENTCONDITION = "eventcondition";
    private static final String EVENTCONDITIONPANEL = "eventconditionpanel";
    private static final String PROPERTY_EVTSTARTITEMS = "evtStartItems";
    private static final String PROPERTY_EVTSTARTITEMS_CONDITION = "condition";
    private static final String PROPERTY_EVTSTARTITEMS_EVENTNAME = "eventName";
    private static final String PROPERTY_EVTSTARTITEMS_EVENTNUMBER = "eventNumber";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(EVENTCONDITION, BIZEVENT);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit operation = (TextEdit)this.getControl(SV_STARTITEMS_OPERATION);
        operation.addButtonClickListener((ClickListener)this);
        TextEdit batchNumName = (TextEdit)this.getControl(STARTITEMS_BATCHNUMNAME);
        batchNumName.addButtonClickListener((ClickListener)this);
        TextEdit bizEvent = (TextEdit)this.getControl(BIZEVENT);
        bizEvent.addButtonClickListener((ClickListener)this);
        TextEdit eventCondition = (TextEdit)this.getControl(EVENTCONDITION);
        eventCondition.addButtonClickListener((ClickListener)this);
    }

    @Override
    protected void addStartConditionListener() {
        TextEdit startCondition = (TextEdit)this.getControl(SV_STARTITEMS_CONDITION);
        startCondition.addButtonClickListener((ClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        try {
            super.afterCreateNewData(e);
            this.initStartItemsFieldState();
            this.initEventStartItems();
        }
        catch (Exception ex) {
            this.showErrorMessage(ResManager.loadKDString((String)"\u6d41\u7a0b\u5c5e\u6027\u914d\u7f6e\u754c\u9762\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"WorkflowProcessPropConfPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), ex);
        }
        finally {
            this.initComplete(BizFlowProcessPropConfPlugin.class);
        }
    }

    private void initStartItemsFieldState() {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(ENTITY_STARTITEMS);
        if (count < 1) {
            return;
        }
        FieldEdit condition = (FieldEdit)this.getControl(SV_STARTITEMS_CONDITION);
        FieldEdit batchNumber = (FieldEdit)this.getControl(STARTITEMS_BATCHNUMNAME);
        for (int i = 0; i < count; ++i) {
            Object allowStart = model.getValue(STARTITEMS_ALLOWSTART, i);
            if (!Boolean.FALSE.equals(allowStart)) continue;
            BizFlowPluginUtil.setEntryFieldEnable(false, i, condition, batchNumber);
        }
    }

    private void initEventStartItems() {
        JSONObject condition;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{EVENTCONDITIONPANEL});
        JSONArray eventItems = this.getCellProperties().getJSONArray(PROPERTY_EVTSTARTITEMS);
        if (eventItems == null || eventItems.isEmpty()) {
            return;
        }
        JSONObject eventItem = eventItems.getJSONObject(0);
        this.getModel().setValue(BIZEVENT, eventItem.get((Object)PROPERTY_EVTSTARTITEMS_EVENTNAME));
        if (eventItem.get((Object)PROPERTY_EVTSTARTITEMS_EVENTNAME) != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{EVENTCONDITIONPANEL});
        }
        if ((condition = eventItem.getJSONObject(PROPERTY_EVTSTARTITEMS_CONDITION)) != null) {
            this.setEventConditionText((Map<String, Object>)condition);
        }
    }

    private void setEventConditionText(Map<String, Object> condition) {
        Object value = condition.get("showtext");
        String showText = DesignerPluginUtil.getLocaleValue(value);
        this.getModel().setValue(EVENTCONDITION, (Object)showText);
    }

    @Override
    protected void initStartUpCondition(JSONObject properties) {
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "sv_startitems_operation": {
                this.openOperationPage();
                break;
            }
            case "sv_startitems_condition": {
                this.openConditionalRule();
                break;
            }
            case "startitems_batchnumname": {
                this.openBatchNumberPage();
                break;
            }
            case "bizevent": {
                this.openBizEventListPage();
                break;
            }
            case "eventcondition": {
                this.openEventCondition();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void openBizEventListPage() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bpm", (String)"evt_event", (String)"47150e89000000ac")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4e8b\u4ef6\u5b9a\u4e49\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizFlowProcessPropConfPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        BizFlowPluginUtil.openBizEventListPage(this.getView(), (IFormPlugin)this, BIZEVENT);
    }

    private void openOperationPage() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTITY_STARTITEMS);
        int focusRow = grid.getEntryState().getFocusRow();
        Object entityNumber = this.getModel().getValue(STARTITEMS_ENTITYNUMBER, focusRow);
        HashMap<String, Object> processProperties = new HashMap<String, Object>();
        processProperties.put("entraBill", entityNumber);
        HashMap<String, HashMap<String, Object>> context = new HashMap<String, HashMap<String, Object>>();
        context.put("processProperties", processProperties);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("context", context);
        params.put("selchexkbox", Boolean.valueOf(true));
        String operationStr = (String)this.getModel().getValue(STARTITEMS_OPERATION, focusRow);
        if (WfUtils.isNotEmpty((String)operationStr)) {
            StringBuilder selectValues = new StringBuilder();
            List operations = SerializationUtils.fromJsonStringToList((String)operationStr, Map.class);
            int size = operations.size();
            for (int i = 0; i < size; ++i) {
                Map operation = (Map)operations.get(i);
                selectValues.append(operation.get("number"));
                if (i >= size - 1) continue;
                selectValues.append(",");
            }
            params.put("selectValues", selectValues);
        }
        FormShowParameter showParameter = this.getShowParameter(STARTITEMS_OPERATION, "wf_formoperation");
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    private void openEventCondition() {
        String conditionValue = null;
        JSONObject cellProps = this.getCellProperties();
        JSONArray eventItems = cellProps.getJSONArray(PROPERTY_EVTSTARTITEMS);
        if (eventItems != null && !eventItems.isEmpty()) {
            JSONObject conditionRule = eventItems.getJSONObject(0).getJSONObject(PROPERTY_EVTSTARTITEMS_CONDITION);
            conditionValue = conditionRule != null ? conditionRule.toJSONString() : null;
        }
        DesignerPluginUtil.openConditionalRule(ConditionalRuleType.eventStartUp, this.getView(), (IFormPlugin)this, conditionValue, this.getModelJsonString(), this.itemId, "", EVENTCONDITION);
    }

    private String openConditionalRule() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTITY_STARTITEMS);
        int focusRow = grid.getEntryState().getFocusRow();
        Object value = this.getModel().getValue(STARTITEMS_CONDITION, focusRow);
        String conditionValue = value != null ? value.toString() : null;
        String nodeId = (String)this.getModel().getValue(STARTITEMS_NODEID, focusRow);
        return DesignerPluginUtil.openConditionalRule(ConditionalRuleType.bpmProcStartUp, this.getView(), (IFormPlugin)this, conditionValue, this.getModelJsonString(), nodeId, "", SV_STARTITEMS_CONDITION);
    }

    private void openBatchNumberPage() {
        BizFlowPluginUtil.showBatchNumberPage(this.getView(), (IFormPlugin)this, ENTITY_STARTITEMS, STARTITEMS_BATCHNUMNAME, STARTITEMS_ENTITYNUMBER, STARTITEMS_BATCHNUMBER);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "eventcondition": {
                this.eventConditionalRuleChanged(newValue);
                break;
            }
            case "bizevent": {
                this.bizEventChanged(newValue);
                break;
            }
            case "sv_startitems_condition": {
                this.startItemPropertyChanged(STARTITEMS_CONDITION, propName, newValue, oldValue, rowIndex);
                break;
            }
            case "sv_startitems_operation": {
                this.startItemPropertyChanged(STARTITEMS_OPERATION, propName, newValue, oldValue, rowIndex);
                break;
            }
            case "startitems_batchnumname": {
                this.startItemBatchNumberChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "startitems_allowstart": {
                this.startItemAllowStartChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void startItemAllowStartChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
        BizFlowPluginUtil.setEntryFieldEnable(Boolean.TRUE.equals(newValue), rowIndex, (FieldEdit)this.getControl(SV_STARTITEMS_CONDITION), (FieldEdit)this.getControl(STARTITEMS_BATCHNUMNAME));
        this.updateOtherRows(propName, newValue, rowIndex);
    }

    private void updateOtherRows(String propName, Object newValue, int rowIndex) {
        Object startBillOperationOnlyHasOne = WfConfigurationUtil.getConfigCenterVal((String)"wf.bizflow.start.billoperation.onlyhasone");
        if (startBillOperationOnlyHasOne != null && !"true".equals(startBillOperationOnlyHasOne)) {
            return;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTITY_STARTITEMS);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            if (i == rowIndex) continue;
            boolean allowStart = (Boolean)this.getModel().getValue(propName, i);
            if (allowStart) {
                this.getModel().beginInit();
                this.getModel().setValue(propName, (Object)false, i);
                this.getModel().endInit();
                super.propertyChanged(propName, false, true, i);
                BizFlowPluginUtil.setEntryFieldEnable(false, i, (FieldEdit)this.getControl(SV_STARTITEMS_CONDITION), (FieldEdit)this.getControl(STARTITEMS_BATCHNUMNAME));
                continue;
            }
            BizFlowPluginUtil.setEntryFieldEnable(false, i, (FieldEdit)this.getControl(SV_STARTITEMS_CONDITION), (FieldEdit)this.getControl(STARTITEMS_BATCHNUMNAME));
        }
        this.getView().updateView(ENTITY_STARTITEMS);
    }

    private void startItemBatchNumberChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue(STARTITEMS_BATCHNUMNAME, null, rowIndex);
            this.getModel().setValue(STARTITEMS_BATCHNUMBER, null, rowIndex);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void startItemPropertyChanged(String property, String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue(property, null);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void bizEventChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            JSONArray eventItems = this.getCellProperties().getJSONArray(PROPERTY_EVTSTARTITEMS);
            eventItems = this.updateEventStartItem(eventItems, PROPERTY_EVTSTARTITEMS_EVENTNAME, null, PROPERTY_EVTSTARTITEMS_EVENTNUMBER, null);
            this.setProperty(PROPERTY_EVTSTARTITEMS, eventItems);
        }
    }

    private void eventConditionalRuleChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            JSONArray eventItems = this.getCellProperties().getJSONArray(PROPERTY_EVTSTARTITEMS);
            eventItems = this.updateEventStartItem(eventItems, PROPERTY_EVTSTARTITEMS_CONDITION, null);
            this.setProperty(PROPERTY_EVTSTARTITEMS, eventItems);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "sv_startitems_condition": {
                this.setStartItemCondition(returnData);
                break;
            }
            case "startitems_batchnumname": {
                this.setStartItemBatchNumber(returnData);
                break;
            }
            case "startitems_operation": {
                this.setStartItemOperation(returnData);
                break;
            }
            case "bizevent": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{EVENTCONDITIONPANEL});
                this.setBizEvent(returnData);
                break;
            }
            case "eventcondition": {
                this.setEventCondition(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setStartItemOperation(Object returnData) {
        if (returnData instanceof List) {
            List datas = (List)returnData;
            List<Map<String, Object>> operations = BizFlowPluginUtil.getNotOverlengthOperations(datas, 300);
            this.getModel().setValue(STARTITEMS_OPERATION, (Object)SerializationUtils.toJsonString(operations));
            if (operations.size() < datas.size()) {
                this.getView().showTipNotification(WFMultiLangConstants.getOperationOverlengthTip());
            }
        }
    }

    private void setEventCondition(Object returnData) {
        if (returnData instanceof Map) {
            Map condition = (Map)returnData;
            JSONArray eventItems = this.getCellProperties().getJSONArray(PROPERTY_EVTSTARTITEMS);
            if (condition.isEmpty()) {
                this.getModel().setValue(EVENTCONDITION, null);
                eventItems = this.updateEventStartItem(eventItems, PROPERTY_EVTSTARTITEMS_CONDITION, null);
            } else {
                this.setEventConditionText(condition);
                eventItems = this.updateEventStartItem(eventItems, PROPERTY_EVTSTARTITEMS_CONDITION, condition);
            }
            this.setProperty(PROPERTY_EVTSTARTITEMS, eventItems);
        }
    }

    private JSONArray updateEventStartItem(JSONArray eventItems, Object ... datas) {
        String KEY_ID = "id";
        JSONObject eventItem = null;
        if (eventItems != null && !eventItems.isEmpty()) {
            eventItem = eventItems.getJSONObject(0);
        } else {
            eventItems = new JSONArray();
            eventItem = new JSONObject();
            eventItems.add((Object)eventItem);
            if (eventItem.get((Object)"id") == null) {
                eventItem.put("id", (Object)BpmnDiffUtil.getListElementId((String)PROPERTY_EVTSTARTITEMS));
            }
        }
        for (int i = 0; i < datas.length; ++i) {
            String key = String.valueOf(datas[i]);
            Object value = datas[++i];
            eventItem.put(key, value);
        }
        return eventItems;
    }

    private void setBizEvent(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            Object name = data.get("name");
            Object number = data.get("number");
            this.getModel().setValue(BIZEVENT, name);
            JSONArray eventItems = this.getCellProperties().getJSONArray(PROPERTY_EVTSTARTITEMS);
            eventItems = this.updateEventStartItem(eventItems, PROPERTY_EVTSTARTITEMS_EVENTNAME, name, PROPERTY_EVTSTARTITEMS_EVENTNUMBER, number);
            this.setProperty(PROPERTY_EVTSTARTITEMS, eventItems);
        }
    }

    private void setStartItemBatchNumber(Object returnData) {
        BizFlowPluginUtil.setStartItemBatchNumber(this.getView(), returnData, ENTITY_STARTITEMS, STARTITEMS_BATCHNUMBER, STARTITEMS_BATCHNUMNAME);
    }

    private void setStartItemCondition(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(STARTITEMS_CONDITION, (Object)SerializationUtils.toJsonString((Object)data));
        }
    }

    @Override
    protected Object getEntryFieldShowValue(String property, Object value) {
        if (PROPERTY_EVTSTARTITEMS_CONDITION.equals(property)) {
            return this.getConditionShowValue(value);
        }
        if ("operation".equals(property) && value instanceof String && WfUtils.isNotEmpty((String)value.toString())) {
            return DesignerPluginUtil.getOperationShowValue((String)value);
        }
        return super.getEntryFieldShowValue(property, value);
    }

    private Object getConditionShowValue(Object value) {
        Map data = new HashMap();
        if (value instanceof Map) {
            data = (Map)value;
        } else if (value instanceof String && WfUtils.isNotEmpty((String)value.toString())) {
            data = (Map)SerializationUtils.fromJsonString((String)value.toString(), Map.class);
        }
        return DesignerPluginUtil.getLocaleValue(data.get("showtext"));
    }

    @Override
    protected Object getGridCellVal(String name, DynamicObject dynObj) {
        if (STARTITEMS_CONDITION.equals(name)) {
            String condition = (String)dynObj.get(STARTITEMS_CONDITION);
            if (WfUtils.isNotEmpty((String)condition)) {
                return JSON.parseObject((String)condition);
            }
            return condition;
        }
        return super.getGridCellVal(name, dynObj);
    }
}

