/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessEventEntity;

public class BizFlowWaitActionsPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "confirmbtn";
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_EVENTID = "eventid";
    private static final String FIELD_EVENTNUMBER = "eventnumber";
    private static final String FIELD_EVENTNAME = "eventname";
    private static final String FIELD_EVENTPARAMS = "eventparams";
    private static final String FIELD_TERMINATINGCONDITION = "terminatingcondition";
    private static final String VALUE_OPERATION = "operation";
    private static final String VALUE_CONDITION = "conditionValue";
    private static final String VALUE_EVENTPARAMS = "eventParamsValue";
    private static final String OPERATION_ID = "id";
    public static final String OPERATION_NAME = "name";
    private static final String OPERATION_NUMBER = "number";
    public static final String CLOSEEVENT_EVENTID = "id";
    public static final String CLOSEEVENT_EVENTNAME = "name";
    private static final String CLOSEEVENT_EVENTNUMBER = "number";
    private static final String CLOSEEVENT_EVENTPARAMS = "params";
    private static final String CLOSEEVENT_CONDITION = "condition";
    public static final String WAITACTIONS_OPERATIONS = "operations";
    public static final String WAITACTIONS_CLOSEEVENT = "closeEvent";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM, "operation", FIELD_EVENTPARAMS, FIELD_TERMINATINGCONDITION});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        JSONObject value = (JSONObject)parameter.getCustomParam("value");
        this.initWaitExecutedActions(value);
    }

    private void initWaitExecutedActions(JSONObject value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        JSONArray operations = value.getJSONArray(WAITACTIONS_OPERATIONS);
        this.setOperationValue((List<Object>)operations);
        JSONObject closeEvent = value.getJSONObject(WAITACTIONS_CLOSEEVENT);
        if (closeEvent != null) {
            Long eventId;
            Object eventName = closeEvent.get((Object)"name");
            this.getModel().setValue(FIELD_EVENTNAME, eventName);
            Object eventNumber = closeEvent.get((Object)"number");
            this.getModel().setValue(FIELD_EVENTNUMBER, eventNumber);
            JSONArray eventParams = closeEvent.getJSONArray(CLOSEEVENT_EVENTPARAMS);
            this.setEventParamsValue(eventParams);
            Long l = eventId = closeEvent.get((Object)"id") != null ? closeEvent.getLong("id") : null;
            if (eventNumber != null && !WfUtils.isEmpty((String)((String)eventNumber)) && eventId == null) {
                ProcessEventEntity processEventEntity = this.getRepositoryService().createProcessEvent((String)eventNumber, eventName != null ? (String)eventName : "", eventParams);
                eventId = processEventEntity.getId();
            }
            this.getModel().setValue(FIELD_EVENTID, (Object)eventId);
            JSONObject condition = closeEvent.getJSONObject(CLOSEEVENT_CONDITION);
            this.setTerminatingConditionValue((Map<String, Object>)condition);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (propName) {
            case "operation": {
                this.operationChanged(newValue);
                break;
            }
            case "eventid": {
                Object eventId = null;
                if (newValue != null && (DynamicObject)newValue != null) {
                    eventId = ((DynamicObject)newValue).get("id");
                }
                this.getModel().setValue(FIELD_EVENTID, eventId);
                break;
            }
            case "terminatingcondition": {
                this.terminatingConditionChanged(newValue);
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    private void operationChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setOperationValue(null);
        }
    }

    private void eventParamsChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setEventParamsValue(null);
        }
    }

    private void terminatingConditionChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setTerminatingConditionValue(null);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "confirmbtn": {
                this.confirm();
                break;
            }
            case "operation": {
                this.showOperation();
                break;
            }
            case "eventparams": {
                this.showEventParams();
                break;
            }
            case "terminatingcondition": {
                this.showTerminatingCondition();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void confirm() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JSONArray operations = null;
        String opers = this.getPageCache().get("operation");
        if (opers != null) {
            operations = JSON.parseArray((String)opers);
            result.put(WAITACTIONS_OPERATIONS, operations);
        }
        HashMap<String, Object> closeEvent = new HashMap<String, Object>();
        result.put(WAITACTIONS_CLOSEEVENT, closeEvent);
        Object event = this.getModel().getValue(FIELD_EVENTID);
        String eventName = " ";
        String eventNumber = " ";
        if (event != null) {
            Long eventId = ((DynamicObject)event).getLong("id");
            closeEvent.put("id", eventId);
            eventName = ((DynamicObject)event).getString(FIELD_EVENTNAME);
            eventNumber = ((DynamicObject)event).getString(FIELD_EVENTNUMBER);
            JSONArray evtParams = this.getRepositoryService().getProcessEventParams(eventId);
            closeEvent.put(CLOSEEVENT_EVENTPARAMS, evtParams);
        }
        closeEvent.put("name", eventName);
        closeEvent.put("number", eventNumber);
        JSONObject condition = null;
        String terminatingCondition = this.getPageCache().get(VALUE_CONDITION);
        if (terminatingCondition != null) {
            condition = JSON.parseObject((String)terminatingCondition);
            closeEvent.put(CLOSEEVENT_CONDITION, condition);
        }
        if ((operations == null || operations.isEmpty()) && event == null && WfUtils.isEmpty((String)terminatingCondition)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u9700\u8981\u7b49\u5f85\u6267\u884c\u7684\u64cd\u4f5c\u6216\u4e8b\u4ef6\u3002", (String)"BizFlowWaitActionsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private String validateCloseEvent(String eventNumber, String eventName, JSONArray evtParams, JSONObject condition) {
        if (WfUtils.isNotEmpty((String)eventNumber) && WfUtils.isNotEmpty((String)eventName) && evtParams != null || this.isCloseEventEmpty(eventNumber, eventName, evtParams, condition)) {
            return null;
        }
        if (eventNumber == null || !eventNumber.matches("^[A-Za-z][A-Za-z0-9_]*$")) {
            return ResManager.loadKDString((String)"\u201c\u4e8b\u4ef6\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"BizFlowWaitActionsPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (WfUtils.isEmpty((String)eventName)) {
            return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4e8b\u4ef6\u540d\u79f0\u201d\u3002", (String)"BizFlowWaitActionsPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (evtParams == null) {
            return ResManager.loadKDString((String)"\u4e8b\u4ef6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizFlowWaitActionsPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private boolean isCloseEventEmpty(String eventNumber, String eventName, JSONArray evtParams, JSONObject condition) {
        return WfUtils.isEmpty((String)eventNumber) && WfUtils.isEmpty((String)eventName) && evtParams == null && condition == null;
    }

    private void showOperation() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityId = (String)parameter.getCustomParam("entityId");
        String entityNumber = (String)parameter.getCustomParam("entityNumber");
        String value = this.getPageCache().get("operation");
        StringBuilder selected = new StringBuilder();
        if (value != null) {
            JSONArray operations = JSON.parseArray((String)value);
            int size = operations.size();
            for (int i = 0; i < size; ++i) {
                selected.append(operations.getJSONObject(i).getString("number"));
                if (i >= size - 1) continue;
                selected.append(",");
            }
        }
        Map params = BillPagePluginUtil.getParamstersOperation((Object)entityNumber, (Object)entityId, (FormShowParameter)this.getView().getFormShowParameter(), (Boolean)true, (String)selected.toString());
        this.showForm(this.getShowParameter("operation", "wf_formoperation", params));
    }

    private void showEventParams() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_EVENTPARAMS));
        showParameter.setFormId("wf_nodeeventparams");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String entityId = (String)parameter.getCustomParam("entityId");
        String modelJson = (String)parameter.getCustomParam("modelJson");
        String value = this.getPageCache().get(VALUE_EVENTPARAMS);
        JSONArray evtParams = null;
        if (value != null) {
            evtParams = JSON.parseArray((String)value);
        }
        showParameter.setCustomParam("value", (Object)evtParams);
        showParameter.setCustomParam("entityId", (Object)entityId);
        showParameter.setCustomParam("modelJson", (Object)modelJson);
        showParameter.setCustomParam("hideValueColumn", (Object)Boolean.TRUE);
        this.getView().showForm(showParameter);
    }

    private void showTerminatingCondition() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String modelJson = (String)parameter.getCustomParam("modelJson");
        String itemId = (String)parameter.getCustomParam("itemId");
        String conditionValue = this.getPageCache().get(VALUE_CONDITION);
        DesignerPluginUtil.openConditionalRule(ConditionalRuleType.timingWait, this.getView(), (IFormPlugin)this, conditionValue, modelJson, itemId, "billCloseConfig.waitActions.closeEvent.condition", FIELD_TERMINATINGCONDITION);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "operation": {
                this.operationCallBack(returnData);
                break;
            }
            case "eventparams": {
                this.eventParamsCallBack(returnData);
                break;
            }
            case "terminatingcondition": {
                this.terminatingConditionCallBack(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void operationCallBack(Object returnData) {
        if (returnData instanceof List) {
            int maxSize = 300;
            boolean overlength = false;
            List operations = (List)returnData;
            if (!operations.isEmpty()) {
                ArrayList<Object> data = new ArrayList<Object>(operations.size());
                StringBuilder numbers = new StringBuilder();
                for (Map operation : operations) {
                    numbers.append((String)operation.get("number"));
                    if (numbers.length() > maxSize) {
                        overlength = true;
                        break;
                    }
                    if (operation.get("id") == null) {
                        operation.put("id", BpmnDiffUtil.getListElementId((String)WAITACTIONS_OPERATIONS));
                    }
                    data.add(operation);
                    numbers.append(",");
                }
                this.setOperationValue(data);
            }
            if (overlength) {
                this.getView().showTipNotification(WFMultiLangConstants.getOperationOverlengthTip());
            }
        }
    }

    private void setOperationValue(List<Object> operations) {
        if (operations != null && !operations.isEmpty()) {
            this.getPageCache().put("operation", JSON.toJSONString(operations));
            this.getModel().setValue("operation", (Object)BillPagePluginUtil.getOperationInfosFromReturnValues(operations, (String)"name"));
        } else {
            this.getPageCache().remove("operation");
            this.getModel().setValue("operation", null);
        }
    }

    private void eventParamsCallBack(Object returnData) {
        if (returnData instanceof JSONArray) {
            JSONArray params = (JSONArray)returnData;
            this.setEventParamsValue(params);
        }
    }

    private void setEventParamsValue(JSONArray params) {
        if (params != null && !params.isEmpty()) {
            this.getPageCache().put(VALUE_EVENTPARAMS, JSON.toJSONString((Object)params));
            this.getModel().setValue(FIELD_EVENTPARAMS, (Object)DesignerPluginUtil.getNodeParamsShowText(params));
        } else {
            this.getPageCache().remove(VALUE_EVENTPARAMS);
            this.getModel().setValue(FIELD_EVENTPARAMS, null);
        }
    }

    private void terminatingConditionCallBack(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.setTerminatingConditionValue(data);
        }
    }

    private void setTerminatingConditionValue(Map<String, Object> condition) {
        if (condition != null && !condition.isEmpty()) {
            this.getPageCache().put(VALUE_CONDITION, JSON.toJSONString(condition));
            this.getModel().setValue(FIELD_TERMINATINGCONDITION, (Object)DesignerPluginUtil.getLocaleValue(condition.get("showtext")));
        } else {
            this.getPageCache().remove(VALUE_CONDITION);
            this.getModel().setValue(FIELD_TERMINATINGCONDITION, null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(VALUE_CONDITION);
        this.getPageCache().remove(VALUE_EVENTPARAMS);
    }
}

