/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.management.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.bpm.model.BpmStartupItem;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.management.util.ConditionalRuleConvertUtil;

public class BizFlowProcessStartupConditionPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "confirm";
    private static final String ENTRYENTITY_STARTITEMS = "startitems";
    private static final String STARTITEMS_ENTITYNAME = "entityname";
    private static final String STARTITEMS_ENTITYNUMBER = "entitynumber";
    private static final String STARTITEMS_STARTUPCONDITION = "startupcondition";
    private static final String STARTITEMS_ALLOWSTART = "allowstart";
    private static final String STARTITEMS_PROCESSCONFIGID = "processconfigid";
    private static final String STARTITEMS_CONDITIONID = "conditionid";
    private static final String STARTITEMS_CONDITION = "condition";
    private static final String STARTITEMS_BATCHNUMNAME = "batchnumname";
    private static final String STARTITEMS_BATCHNUMBER = "batchnumber";
    private static final String STARTITEMS_OPERATION = "operation";
    private static final String STARTITEMS_OPERATIONVALUE = "operationvalue";
    private static final String STARTITEMS_OPERATIONNAME = "operationname";
    private static final String EVTSTARTITEMS_EVENTNAME = "eventname";
    private static final String EVTSTARTITEMS_EVENTNUMBER = "eventnumber";
    private static final String EVTSTARTITEMS_EVENTCONDITION = "eventcondition";
    private static final String EVTSTARTITEMS_EVENTCONDITIONID = "eventconditionid";
    private static final String EVTSTARTITEMS_EVENTCONDITIONVALUE = "eventconditionvalue";
    private static final String EVTSTARTITEMS_EVTPROCESSCONFIGID = "evtprocessconfigid";
    private static final String KEY_BIZEVENT = "bizevent";
    private static final String KEY_CONDITION = "condition";
    private static final String KEY_EVENTCONDITION = "eventCondition";
    private static final String KEY_BATCHNUMBER = "batchnumber";
    private static final String KEY_DELETED = "deleted_ids";
    private static final String KEY_SCHEME_ID = "schemeId";
    private static final String KEY_SCHEME_MODIFYTIME = "schemeModifyTime";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        TextEdit startCondition = (TextEdit)this.getControl(STARTITEMS_STARTUPCONDITION);
        startCondition.addButtonClickListener((ClickListener)this);
        TextEdit batchNumberName = (TextEdit)this.getControl(STARTITEMS_BATCHNUMNAME);
        batchNumberName.addButtonClickListener((ClickListener)this);
        TextEdit bizEvent = (TextEdit)this.getControl(EVTSTARTITEMS_EVENTNAME);
        bizEvent.addButtonClickListener((ClickListener)this);
        TextEdit eventCondition = (TextEdit)this.getControl(EVTSTARTITEMS_EVENTCONDITION);
        eventCondition.addButtonClickListener((ClickListener)this);
        TextEdit operationName = (TextEdit)this.getControl(STARTITEMS_OPERATIONNAME);
        operationName.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long procDefId = (Long)this.getView().getFormShowParameter().getCustomParam("procDefId");
        this.initStartItemList(procDefId);
        this.initStartItemsFieldState();
        this.cacheSchemeModifyTime(procDefId);
    }

    private void cacheSchemeModifyTime(Long procDefId) {
        QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)procDefId), new QFilter("isdefault", "=", (Object)true)};
        List schemes = this.getManagementService().getDynamicConfigSchemeByFilters(filters);
        if (schemes.isEmpty()) {
            return;
        }
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)schemes.get(0);
        this.getPageCache().put(KEY_SCHEME_ID, String.valueOf(scheme.getId()));
        this.getPageCache().put(KEY_SCHEME_MODIFYTIME, String.valueOf(scheme.getModifyDate().getTime()));
    }

    private void initStartItemList(Long procDefId) {
        if (WfUtils.isEmpty((Long)procDefId)) {
            this.log.debug("procDefId is null! init startItems failed!");
            return;
        }
        BpmStartupItem eventItem = null;
        List items = this.getManagementService().findBpmStartupItemsByProcDefId(procDefId);
        IDataModel model = this.getModel();
        int index = 0;
        for (BpmStartupItem item : items) {
            if ("event".equals(item.getStartType())) {
                eventItem = item;
                continue;
            }
            model.createNewEntryRow(ENTRYENTITY_STARTITEMS);
            model.setValue(STARTITEMS_ENTITYNAME, (Object)item.getEntityName(), index);
            model.setValue(STARTITEMS_ENTITYNUMBER, (Object)item.getEntityNumber(), index);
            model.setValue(STARTITEMS_STARTUPCONDITION, (Object)item.getCondShowText(), index);
            model.setValue(STARTITEMS_ALLOWSTART, (Object)item.isAllowStart(), index);
            model.setValue(STARTITEMS_PROCESSCONFIGID, (Object)item.getProcessConfigId(), index);
            model.setValue(STARTITEMS_CONDITIONID, (Object)item.getConditionId(), index);
            model.setValue("batchnumber", (Object)item.getBatchNumber(), index);
            model.setValue(STARTITEMS_BATCHNUMNAME, (Object)item.getBatchNumName(), index);
            model.setValue(STARTITEMS_OPERATION, (Object)item.getOperation(), index);
            ArrayList<Map<String, String>> operations = new ArrayList<Map<String, String>>();
            model.setValue(STARTITEMS_OPERATIONNAME, (Object)this.getOperationName(item.getEntityNumber(), item.getOperation(), operations), index);
            model.setValue(STARTITEMS_OPERATIONVALUE, (Object)SerializationUtils.toJsonString(operations), index);
            ++index;
        }
        if (eventItem != null) {
            this.initEventStartUpItem(eventItem);
        }
    }

    private String getOperationName(String entityNumber, String operation, List<Map<String, String>> operations) {
        if (WfUtils.isEmpty((String)operation)) {
            return "";
        }
        String separator = ",";
        StringBuilder names = new StringBuilder();
        try {
            String[] numbers = operation.split(separator);
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            List opers = metadata.getRootEntity().getOperations();
            HashMap<String, String> operMap = new HashMap<String, String>(8);
            for (Operation oper : opers) {
                operMap.put(oper.getKey(), String.valueOf(oper.getName()));
            }
            int length = numbers.length;
            for (int i = 0; i < length; ++i) {
                String number = numbers[i];
                String name = (String)operMap.get(number);
                if (WfUtils.isEmpty((String)name)) continue;
                names.append(name);
                if (i < length - 1) {
                    names.append(separator);
                }
                HashMap<String, String> op = new HashMap<String, String>();
                op.put("number", number);
                op.put("name", name);
                operations.add(op);
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return names.toString();
    }

    private void initEventStartUpItem(BpmStartupItem eventItem) {
        IDataModel model = this.getModel();
        model.setValue(EVTSTARTITEMS_EVENTNAME, (Object)eventItem.getEventName());
        model.setValue(EVTSTARTITEMS_EVENTNUMBER, (Object)eventItem.getEventNumber());
        model.setValue(EVTSTARTITEMS_EVENTCONDITION, (Object)eventItem.getCondShowText());
        model.setValue(EVTSTARTITEMS_EVENTCONDITIONID, (Object)eventItem.getConditionId());
        model.setValue(EVTSTARTITEMS_EVTPROCESSCONFIGID, (Object)eventItem.getProcessConfigId());
    }

    private void initStartItemsFieldState() {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(ENTRYENTITY_STARTITEMS);
        if (count < 1) {
            return;
        }
        FieldEdit condition = (FieldEdit)this.getControl(STARTITEMS_STARTUPCONDITION);
        FieldEdit batchNumber = (FieldEdit)this.getControl(STARTITEMS_BATCHNUMNAME);
        for (int i = 0; i < count; ++i) {
            Object allowStart = model.getValue(STARTITEMS_ALLOWSTART, i);
            if (!Boolean.FALSE.equals(allowStart)) continue;
            BizFlowPluginUtil.setEntryFieldEnable(false, i, condition, batchNumber);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        switch (propName) {
            case "batchnumname": {
                this.batchNumberChanged(newValue, rowIndex);
                break;
            }
            case "eventname": {
                this.bizEventChanged(newValue);
                break;
            }
            case "eventcondition": {
                this.eventConditionChanged(newValue);
                break;
            }
            case "startupcondition": {
                this.conditionChanged(newValue, rowIndex);
                break;
            }
            case "allowstart": {
                super.propertyChanged(e);
                this.changeStartItemsFieldState(propName, newValue, rowIndex);
                break;
            }
            case "operationname": {
                this.operationNameChange(newValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    private void operationNameChange(Object newValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue(STARTITEMS_OPERATION, null, rowIndex);
            this.getModel().setValue(STARTITEMS_OPERATIONNAME, null, rowIndex);
            this.getModel().setValue(STARTITEMS_OPERATIONVALUE, null, rowIndex);
        }
    }

    private void batchNumberChanged(Object newValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue("batchnumber", null, rowIndex);
        }
    }

    private void eventConditionChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue(EVTSTARTITEMS_EVENTCONDITIONVALUE, null);
            this.setDeleted(String.valueOf(this.getModel().getValue(EVTSTARTITEMS_EVENTCONDITIONID)));
        }
    }

    private void conditionChanged(Object newValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue(STARTITEMS_STARTUPCONDITION, null, rowIndex);
            this.setDeleted(String.valueOf(this.getModel().getValue(STARTITEMS_CONDITIONID, rowIndex)));
        }
    }

    private void bizEventChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue(EVTSTARTITEMS_EVENTNUMBER, null);
        }
    }

    private void changeStartItemsFieldState(String propName, Object newValue, int rowIndex) {
        BizFlowPluginUtil.setEntryFieldEnable(Boolean.TRUE.equals(newValue), rowIndex, (FieldEdit)this.getControl(STARTITEMS_STARTUPCONDITION), (FieldEdit)this.getControl(STARTITEMS_BATCHNUMNAME));
        Object startBillOperationOnlyHasOne = WfConfigurationUtil.getConfigCenterVal((String)"wf.bizflow.start.billoperation.onlyhasone");
        if (startBillOperationOnlyHasOne != null && !"true".equals(startBillOperationOnlyHasOne)) {
            return;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY_STARTITEMS);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            if (i == rowIndex) continue;
            boolean allowStart = (Boolean)this.getModel().getValue(propName, i);
            if (allowStart) {
                this.getModel().beginInit();
                this.getModel().setValue(propName, (Object)false, i);
                this.getModel().endInit();
                BizFlowPluginUtil.setEntryFieldEnable(false, i, (FieldEdit)this.getControl(STARTITEMS_STARTUPCONDITION), (FieldEdit)this.getControl(STARTITEMS_BATCHNUMNAME));
                continue;
            }
            BizFlowPluginUtil.setEntryFieldEnable(false, i, (FieldEdit)this.getControl(STARTITEMS_STARTUPCONDITION), (FieldEdit)this.getControl(STARTITEMS_BATCHNUMNAME));
        }
        this.getView().updateView(ENTRYENTITY_STARTITEMS);
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "startupcondition": {
                this.openStartCondition();
                break;
            }
            case "batchnumname": {
                this.openBatchNumberPage();
                break;
            }
            case "confirm": {
                this.confirm();
                break;
            }
            case "eventname": {
                BizFlowPluginUtil.openBizEventListPage(this.getView(), (IFormPlugin)this, KEY_BIZEVENT);
                break;
            }
            case "eventcondition": {
                this.openEventStartCondition();
                break;
            }
            case "operationname": {
                this.openOperationPage();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void openOperationPage() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY_STARTITEMS);
        int focusRow = grid.getEntryState().getFocusRow();
        Object entityNumber = this.getModel().getValue(STARTITEMS_ENTITYNUMBER, focusRow);
        HashMap<String, Object> processProperties = new HashMap<String, Object>();
        processProperties.put("entraBill", entityNumber);
        HashMap<String, HashMap<String, Object>> context = new HashMap<String, HashMap<String, Object>>();
        context.put("processProperties", processProperties);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("context", context);
        params.put("selchexkbox", Boolean.valueOf(true));
        String operationStr = (String)this.getModel().getValue(STARTITEMS_OPERATION, focusRow);
        if (WfUtils.isNotEmpty((String)operationStr)) {
            StringBuilder selectValues = new StringBuilder();
            String[] operations = operationStr.split(",");
            int size = operations.length;
            for (int i = 0; i < size; ++i) {
                String operation = operations[i];
                selectValues.append(operation);
                if (i >= size - 1) continue;
                selectValues.append(",");
            }
            params.put("selectValues", selectValues);
        }
        FormShowParameter showParameter = this.getShowParameter(STARTITEMS_OPERATION, "wf_formoperation");
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    private void openBatchNumberPage() {
        BizFlowPluginUtil.showBatchNumberPage(this.getView(), (IFormPlugin)this, ENTRYENTITY_STARTITEMS, "batchnumber", STARTITEMS_ENTITYNUMBER, "batchnumber");
    }

    private void openStartCondition() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY_STARTITEMS);
        int focusRow = grid.getEntryState().getFocusRow();
        Object conditionId = this.getModel().getValue(STARTITEMS_CONDITIONID, focusRow);
        Object conditionValue = this.getModel().getValue("condition", focusRow);
        String entityNumber = (String)this.getModel().getValue(STARTITEMS_ENTITYNUMBER, focusRow);
        this.openConditionRule(ConditionalRuleType.bpmProcStartUp, conditionId, conditionValue, "condition", entityNumber);
    }

    private void openEventStartCondition() {
        Object conditionId = this.getModel().getValue(EVTSTARTITEMS_EVENTCONDITIONID);
        Object conditionValue = this.getModel().getValue(EVTSTARTITEMS_EVENTCONDITIONVALUE);
        this.openConditionRule(ConditionalRuleType.eventStartUp, conditionId, conditionValue, KEY_EVENTCONDITION, null);
    }

    private void openConditionRule(ConditionalRuleType ruleType, Object conditionId, Object conditionValue, String callBackId, String entityNumber) {
        Long procDefId = (Long)this.getView().getFormShowParameter().getCustomParam("procDefId");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("procDefId", procDefId);
        params.put("openType", "managermentCenter");
        String type = ruleType.toString();
        params.put("type", type);
        if (WfUtils.isNotEmptyString((Object)conditionValue)) {
            params.put("value", conditionValue);
        } else {
            params.put("condruleid", String.valueOf(conditionId));
        }
        if (WfUtils.isNotEmpty((String)entityNumber)) {
            params.put("entityNumber", entityNumber);
        }
        String caption = ConditionalRuleType.getTypeName((String)type);
        FormShowParameter parameter = this.getShowParameter(callBackId, "wf_conditionrule_update", caption, params);
        parameter.setShowTitle(false);
        this.getView().showForm(parameter);
    }

    private String checkSchemeModifyState() {
        String schemeId = this.getPageCache().get(KEY_SCHEME_ID);
        if (WfUtils.isEmpty((String)schemeId)) {
            return null;
        }
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)this.getRepositoryService().findEntityById(Long.valueOf(schemeId), "wf_processdynamicconfig", "modifyDate");
        if (!String.valueOf(scheme.getModifyDate().getTime()).equals(this.getPageCache().get(KEY_SCHEME_MODIFYTIME))) {
            return ResManager.loadKDString((String)"\u52a8\u6001\u914d\u7f6e\u65b9\u6848\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u201c\u6d41\u7a0b\u542f\u52a8\u6761\u4ef6\u201d\u3002", (String)"BizFlowProcessStartupConditionPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void confirm() {
        String result = this.checkSchemeModifyState();
        if (result != null) {
            this.getView().showTipNotification(result);
            return;
        }
        String delIds = this.getPageCache().get(KEY_DELETED);
        Set ids = new HashSet();
        if (WfUtils.isNotEmpty((String)delIds)) {
            ids = (Set)SerializationUtils.fromJsonString((String)delIds, Set.class);
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY_STARTITEMS);
        ArrayList<BpmStartupItem> items = new ArrayList<BpmStartupItem>();
        for (DynamicObject row : collection) {
            Long condRuleId = row.getLong(STARTITEMS_CONDITIONID);
            BpmStartupItem item = new BpmStartupItem();
            item.setAllowStart(row.getBoolean(STARTITEMS_ALLOWSTART));
            item.setCondition(row.getString("condition"));
            item.setConditionId(condRuleId);
            item.setProcessConfigId(Long.valueOf(row.getLong(STARTITEMS_PROCESSCONFIGID)));
            item.setEntityNumber(row.getString(STARTITEMS_ENTITYNUMBER));
            item.setBatchNumber(row.getString("batchnumber"));
            item.setBatchNumName(row.getString(STARTITEMS_BATCHNUMNAME));
            item.setOperation(row.getString(STARTITEMS_OPERATION));
            item.setOperationValue(row.getString(STARTITEMS_OPERATIONVALUE));
            if (WfUtils.isNotEmpty((Long)condRuleId) && ids.contains(String.valueOf(condRuleId)) && WfUtils.isEmpty((String)item.getCondition())) {
                item.setCondRuleDeleted(true);
            }
            items.add(item);
        }
        String eventCondition = "";
        String eventName = (String)this.getModel().getValue(EVTSTARTITEMS_EVENTNAME);
        String eventNumber = (String)this.getModel().getValue(EVTSTARTITEMS_EVENTNUMBER);
        Long eventProcConfigId = (Long)this.getModel().getValue(EVTSTARTITEMS_EVTPROCESSCONFIGID);
        Object conditionValue = this.getModel().getValue(EVTSTARTITEMS_EVENTCONDITIONVALUE);
        if (conditionValue != null) {
            eventCondition = conditionValue.toString().trim();
        }
        BpmStartupItem eventItem = new BpmStartupItem();
        eventItem.setProcessConfigId(eventProcConfigId);
        eventItem.setCondition(eventCondition);
        Long conditionId = (Long)this.getModel().getValue(EVTSTARTITEMS_EVENTCONDITIONID);
        if (WfUtils.isNotEmpty((Long)conditionId)) {
            eventItem.setConditionId(conditionId);
            if (ids.contains(String.valueOf(conditionId)) || "".equals(this.getModel().getValue(EVTSTARTITEMS_EVENTCONDITION))) {
                eventItem.setCondRuleDeleted(true);
            }
        }
        Long procDefId = (Long)this.getView().getFormShowParameter().getCustomParam("procDefId");
        eventItem.setProcDefId(procDefId);
        eventItem.setStartType("event");
        eventItem.setEventName(eventName);
        eventItem.setEventNumber(eventNumber);
        items.add(eventItem);
        this.getManagementService().updateBpmStartupCondition(procDefId, items);
        this.recordOperationLog(procDefId);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BizFlowProcessStartupConditionPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            parentView.updateView("billlistap");
            this.getView().sendFormAction(parentView);
        }
        this.getView().close();
    }

    private void recordOperationLog(Long procDefId) {
        try {
            String fields = String.format("%s,%s,%s", "key", "name", "version");
            ProcessDefinitionEntity entity = (ProcessDefinitionEntity)this.getRepositoryService().findEntityById(procDefId, "wf_processdefinition", fields);
            WfUtils.addOpLog((String)"wf_processdefinition", (String)"setupcond", (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bbe\u7f6e\u542f\u52a8\u6761\u4ef6", "BizFlowProcessStartupConditionPlugin_4", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u540d\u79f0\uff1a%1$s\uff1b\u6d41\u7a0b\u7f16\u7801\uff1a%2$s\uff1b\u6d41\u7a0b\u7248\u672c\uff1a%3$s\uff1b\u6d41\u7a0b\u5b9a\u4e49ID: %4$s", "BizFlowProcessStartupConditionPlugin_3", "bos-wf-formplugin"), (Object[])new Object[]{entity.getName(), entity.getKey(), entity.getVersion(), procDefId});
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "condition": {
                this.conditionCallBack(returnData);
                break;
            }
            case "batchnumber": {
                this.batchNumberCallBack(returnData);
                break;
            }
            case "eventCondition": {
                this.eventConditionCallBack(returnData);
                break;
            }
            case "bizevent": {
                this.bizEventCallBack(returnData);
                break;
            }
            case "operation": {
                this.setStartItemOperation(returnData);
            }
        }
    }

    private void setStartItemOperation(Object returnData) {
        if (returnData instanceof List) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY_STARTITEMS);
            int focusRow = grid.getEntryState().getFocusRow();
            List datas = (List)returnData;
            List<Map<String, Object>> operations = BizFlowPluginUtil.getNotOverlengthOperations(datas, 300);
            StringBuilder operateName = new StringBuilder();
            StringBuilder operateNumber = new StringBuilder();
            int size = operations.size();
            for (int i = 0; i < size; ++i) {
                Map<String, Object> operation = operations.get(i);
                operateName.append(operation.get("name"));
                operateNumber.append(operation.get("number"));
                if (i >= size - 1) continue;
                operateName.append(',');
                operateNumber.append(',');
            }
            this.getModel().setValue(STARTITEMS_OPERATION, (Object)operateNumber, focusRow);
            this.getModel().setValue(STARTITEMS_OPERATIONNAME, (Object)operateName, focusRow);
            this.getModel().setValue(STARTITEMS_OPERATIONVALUE, (Object)SerializationUtils.toJsonString(operations), focusRow);
            if (operations.size() < datas.size()) {
                this.getView().showTipNotification(WFMultiLangConstants.getOperationOverlengthTip());
            }
        }
    }

    private void bizEventCallBack(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            Object name = data.get("name");
            Object number = data.get("number");
            this.getModel().setValue(EVTSTARTITEMS_EVENTNAME, name);
            this.getModel().setValue(EVTSTARTITEMS_EVENTNUMBER, number);
        }
    }

    private void eventConditionCallBack(Object returnData) {
        String data = null;
        if (returnData instanceof String && WfUtils.isNotEmpty((String)(data = returnData.toString()))) {
            String showText = "";
            IDataModel model = this.getModel();
            try {
                ConditionalRuleEntity condRule = ConditionalRuleConvertUtil.jsonToConditionalRuleModel((String)data);
                showText = condRule.getShowtext().getLocaleValue();
            }
            catch (Exception e) {
                this.log.warn("the returnData cann't convert to ConditionRuleEntity!" + e.getMessage());
                this.setDeleted(String.valueOf(model.getValue(EVTSTARTITEMS_EVENTCONDITIONID)));
                data = "";
            }
            model.setValue(EVTSTARTITEMS_EVENTCONDITION, (Object)showText);
            model.setValue(EVTSTARTITEMS_EVENTCONDITIONVALUE, (Object)data);
        }
    }

    private void batchNumberCallBack(Object returnData) {
        BizFlowPluginUtil.setStartItemBatchNumber(this.getView(), returnData, ENTRYENTITY_STARTITEMS, "batchnumber", STARTITEMS_BATCHNUMNAME);
    }

    private void conditionCallBack(Object returnData) {
        String data = null;
        if (returnData instanceof String && WfUtils.isNotEmpty((String)(data = returnData.toString()))) {
            String showText = "";
            IDataModel model = this.getModel();
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY_STARTITEMS);
            int focusRow = grid.getEntryState().getFocusRow();
            try {
                ConditionalRuleEntity condRule = ConditionalRuleConvertUtil.jsonToConditionalRuleModel((String)data);
                showText = condRule.getShowtext().toString();
            }
            catch (Exception e) {
                this.log.warn("the returnData cann't convert to ConditionRuleEntity!" + e.getMessage());
                this.setDeleted(String.valueOf(model.getValue(STARTITEMS_CONDITIONID, focusRow)));
                data = "";
            }
            model.setValue("condition", (Object)data, focusRow);
            model.setValue(STARTITEMS_STARTUPCONDITION, (Object)showText, focusRow);
        }
    }

    private void setDeleted(String conditionId) {
        if (conditionId == null || "".equals(conditionId.trim())) {
            return;
        }
        String delIds = this.getPageCache().get(KEY_DELETED);
        Set ids = null;
        ids = WfUtils.isEmpty((String)delIds) ? new HashSet() : (Set)SerializationUtils.fromJsonString((String)delIds, Set.class);
        ids.add(conditionId);
        this.getPageCache().put(KEY_DELETED, SerializationUtils.toJsonString(ids));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_DELETED);
        this.getPageCache().remove(KEY_SCHEME_ID);
        this.getPageCache().remove(KEY_SCHEME_MODIFYTIME);
    }
}

