/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.monitor.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bizflow.graph.handler.CardLinkManager;
import kd.bos.workflow.bizflow.graph.model.BillCardData;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public abstract class AbstractBpmBillRelationCardDetailPlugin
extends AbstractWorkflowPlugin {
    private long index = System.currentTimeMillis();
    private static final String TWO_STRINGS_TEMPLATE = "%s_%s";
    private static final String THREE_STRINGS_TEMPLATE = "%s-%s-%s";
    protected static final char DATA_SEPARATOR = '-';
    protected static final String PREFIX_CONTAINER = "container";
    protected static final String LINK_TYPE_ALL = "all";
    protected static final String LINK_TYPE_MORE = "more";
    protected static final String PREFIX_LINK = "link";
    protected static final String PREFIX_LINK_BILL = String.format("%s_bill", "link");
    protected static final String PREFIX_LINK_MORE = String.format("%s_%s", "link", "more");
    protected static final String PREFIX_LINK_ALL = String.format("%s_%s", "link", "all");
    protected static final String PANEL_MAIN = "mainpanel";
    protected static final String VALUE_START = "start";
    protected static final String VALUE_CENTER = "center";
    protected static final String VALUE_STRETCH = "stretch";
    protected static final String DIRECTION_ROW = "row";
    protected static final String DIRECTION_COLUMN = "column";
    protected static final String COLOR_LINK = "#0E5FD8";
    protected static final String COLOR_GREY = "#666666";

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith(PREFIX_LINK)) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        } else if (key.startsWith(PREFIX_CONTAINER)) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            e.setControl((Control)container);
        }
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (key.startsWith(PREFIX_LINK_BILL)) {
            this.showBillPage(key);
        } else if (key.startsWith(PREFIX_LINK_MORE)) {
            this.showMore(key);
        } else if (key.startsWith(PREFIX_LINK_ALL)) {
            this.showAll(key);
        } else {
            super.click(evt);
        }
    }

    protected String getIdentification(String key) {
        return key.substring(key.indexOf(45) + 1, key.lastIndexOf(45));
    }

    protected void showAll(String identification) {
    }

    protected void showMore(String identification) {
    }

    protected void showBillPage(String key) {
        IFormView view = this.getView();
        String businessKey = key.substring(key.lastIndexOf(45) + 1, key.length());
        String entityNumber = key.substring(key.indexOf(45) + 1, key.lastIndexOf(45));
        this.getCardLinkManager(view).clickShowSingleBillLink(view, entityNumber, businessKey);
    }

    protected void showBillList(String entityNumber, List<String> billIds) {
        IFormView view = this.getView();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String entityName = String.valueOf(entityType.getDisplayName());
        this.getCardLinkManager(view).clickShowBillListLink(view, entityName, entityNumber, billIds);
    }

    private CardLinkManager getCardLinkManager(IFormView view) {
        String permStrategy = (String)view.getFormShowParameter().getCustomParam("permStrategy");
        return new CardLinkManager(permStrategy);
    }

    protected void updateMetadata(String ctrlKey, ControlAp<?> ... controls) {
        HashMap<String, List<Map<String, Object>>> metadata = new HashMap<String, List<Map<String, Object>>>();
        List<Map<String, Object>> items = this.getCreatedControls(controls);
        metadata.put("items", items);
        this.getView().updateControlMetadata(ctrlKey, metadata);
    }

    protected List<Map<String, Object>> getCreatedControls(ControlAp<?> ... controls) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (ControlAp<?> control : controls) {
            if (control == null) continue;
            items.add(control.createControl());
        }
        return items;
    }

    protected Map<String, String> getBillNoMap(MainEntityType entityType, List<String> billIds) {
        String billNoField = null;
        if (entityType instanceof BillEntityType) {
            billNoField = ((BillEntityType)entityType).getBillNo();
        }
        String idField = "id";
        String entityNumber = entityType.getName();
        HashMap<String, String> billNoMap = new HashMap<String, String>(billIds.size());
        if (WfUtils.isNotEmpty((String)billNoField)) {
            QFilter[] filters = null;
            Class pkType = entityType.getPrimaryKey().getPropertyType();
            if (BizFlowGraphUtil.isLongType((Class)pkType)) {
                ArrayList<Long> ids = new ArrayList<Long>(billIds.size());
                for (String billId : billIds) {
                    ids.add(Long.valueOf(billId));
                }
                filters = new QFilter[]{new QFilter(idField, "in", ids)};
            } else {
                filters = new QFilter[]{new QFilter(idField, "in", billIds)};
            }
            DynamicObjectCollection datas = QueryServiceHelper.query((String)entityNumber, (String)String.format("id,%s", billNoField), (QFilter[])filters);
            for (DynamicObject data : datas) {
                String id = String.valueOf(data.get(idField));
                String billNo = data.getString(billNoField);
                billNoMap.put(String.format(TWO_STRINGS_TEMPLATE, entityNumber, id), billNo);
            }
        }
        return billNoMap;
    }

    protected FlexPanelAp createCardPanel(BillRelation relation) {
        FlexPanelAp cardPanel = new FlexPanelAp();
        cardPanel.setKey(this.getControlKey((ControlAp<?>)cardPanel));
        cardPanel.setRadius("4px");
        Style cardPanelStyle = new Style();
        Margin cardPanelMargin = new Margin();
        cardPanelMargin.setBottom("10px");
        cardPanelStyle.setMargin(cardPanelMargin);
        Border cardPanelBorder = new Border();
        String borderStyle = "1px_solid_#D9D9D9";
        cardPanelBorder.setLeft(borderStyle);
        cardPanelBorder.setRight(borderStyle);
        cardPanelBorder.setTop(borderStyle);
        cardPanelBorder.setBottom(borderStyle);
        cardPanelStyle.setBorder(cardPanelBorder);
        cardPanel.setStyle(cardPanelStyle);
        cardPanel.setWidth(new LocaleString("100%"));
        cardPanel.setHeight(new LocaleString("128px"));
        cardPanel.setShrink(0);
        cardPanel.setGrow(0);
        cardPanel.setAlignItems(VALUE_STRETCH);
        cardPanel.setWrap(false);
        cardPanel.setDirection(DIRECTION_COLUMN);
        if (relation.isHasPermission()) {
            FlexPanelAp titlePanel = this.createTitlePanel(relation);
            cardPanel.getItems().add(titlePanel);
            FlexPanelAp contentPanel = this.createContentPanel(relation);
            cardPanel.getItems().add(contentPanel);
        } else {
            cardPanel.setAlignItems(VALUE_CENTER);
            cardPanel.setJustifyContent(VALUE_CENTER);
            ImageAp noPermissionImg = new ImageAp();
            noPermissionImg.setKey(this.getControlKey((ControlAp<?>)noPermissionImg));
            noPermissionImg.setWidth(new LocaleString("126px"));
            noPermissionImg.setHeight(new LocaleString("72px"));
            noPermissionImg.setImageKey("/workflow/images/pc/other/lcfwy_customrelation_noperm_126_72.png");
            noPermissionImg.setShrink(0);
            noPermissionImg.setSectionMagnifier(false);
            noPermissionImg.setControlLoading(true);
            cardPanel.getItems().add(noPermissionImg);
            LabelAp noPermissionLabel = new LabelAp();
            noPermissionLabel.setClickable(true);
            noPermissionLabel.setKey(this.getControlKey((ControlAp<?>)noPermissionLabel));
            noPermissionLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u65e0\u67e5\u770b\u6743\u9650", (String)"AbstractBpmBillRelationCardDetailPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            noPermissionLabel.setControlLoading(true);
            noPermissionLabel.setForeColor("#999999");
            cardPanel.getItems().add(noPermissionLabel);
        }
        return cardPanel;
    }

    private FlexPanelAp createTitlePanel(BillRelation relation) {
        FlexPanelAp titlePanel = new FlexPanelAp();
        titlePanel.setKey(this.getControlKey((ControlAp<?>)titlePanel));
        titlePanel.setAlignContent(VALUE_CENTER);
        Style titlePanelStyle = new Style();
        Padding titlePanelPadding = new Padding();
        titlePanelPadding.setLeft("12px");
        titlePanelPadding.setRight("12px");
        titlePanelPadding.setTop("8px");
        titlePanelPadding.setBottom("4px");
        titlePanelStyle.setPadding(titlePanelPadding);
        Border titlePanelBorder = new Border();
        titlePanelBorder.setBottom("1px_dashed_#E5E5E5");
        titlePanelStyle.setBorder(titlePanelBorder);
        titlePanel.setStyle(titlePanelStyle);
        titlePanel.setHeight(new LocaleString("57px"));
        titlePanel.setShrink(0);
        titlePanel.setGrow(0);
        titlePanel.setAlignItems(VALUE_CENTER);
        titlePanel.setJustifyContent(VALUE_CENTER);
        titlePanel.setDirection(DIRECTION_ROW);
        FlexPanelAp titleTextPanel = this.createTitleTextPanel(relation);
        titlePanel.getItems().add(titleTextPanel);
        if (relation.isHasCustomRelation()) {
            FlexPanelAp imagePanel = this.createTitleImagePanel();
            titlePanel.getItems().add(imagePanel);
        }
        return titlePanel;
    }

    private FlexPanelAp createTitleTextPanel(BillRelation relation) {
        FlexPanelAp titleTextPanel = new FlexPanelAp();
        titleTextPanel.setKey(this.getControlKey((ControlAp<?>)titleTextPanel));
        titleTextPanel.setShrink(1);
        titleTextPanel.setAlignItems(VALUE_STRETCH);
        titleTextPanel.setGrow(1);
        titleTextPanel.setWrap(false);
        titleTextPanel.setAlignItems(VALUE_START);
        titleTextPanel.setDirection(DIRECTION_COLUMN);
        LabelAp titleLabel = new LabelAp();
        titleLabel.setKey(this.getControlKey((ControlAp<?>)titleLabel));
        Style titleLabelStyle = new Style();
        Margin titleLabelMargin = new Margin();
        titleLabelMargin.setBottom("2px");
        titleLabelStyle.setMargin(titleLabelMargin);
        titleLabel.setStyle(titleLabelStyle);
        titleLabel.setName(new LocaleString(relation.getEntityName()));
        titleLabel.setControlLoading(true);
        titleLabel.setFontSize(14);
        titleLabel.setFontWeight("400");
        titleLabel.setForeColor("#212121");
        titleLabel.setWidth(new LocaleString("220px"));
        titleLabel.setAutoTextWrap(false);
        titleTextPanel.getItems().add(titleLabel);
        LabelAp subTitleLabel = new LabelAp();
        subTitleLabel.setClickable(true);
        subTitleLabel.setKey(String.format("%s_%s-%s-%s", PREFIX_LINK_BILL, this.getControlKey((ControlAp<?>)subTitleLabel), relation.getEntityNumber(), relation.getBusinessKey()));
        subTitleLabel.setName(new LocaleString(relation.getBillNo()));
        subTitleLabel.setControlLoading(true);
        subTitleLabel.setForeColor(COLOR_LINK);
        subTitleLabel.setAutoTextWrap(false);
        subTitleLabel.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiR7XG4gIFx0dGV4dC1kZWNvcmF0aW9uOiB1bmRlcmxpbmU7XG5cdG1heC13aWR0aDogMjIwcHg7XG59In0=");
        titleTextPanel.getItems().add(subTitleLabel);
        return titleTextPanel;
    }

    private FlexPanelAp createTitleImagePanel() {
        FlexPanelAp titleImagePanel = new FlexPanelAp();
        titleImagePanel.setKey(this.getControlKey((ControlAp<?>)titleImagePanel));
        titleImagePanel.setAlignContent(VALUE_CENTER);
        titleImagePanel.setShrink(0);
        titleImagePanel.setGrow(0);
        titleImagePanel.setAlignItems(VALUE_CENTER);
        titleImagePanel.setJustifyContent(VALUE_CENTER);
        titleImagePanel.setWrap(false);
        titleImagePanel.setDirection(DIRECTION_COLUMN);
        titleImagePanel.setBackColor("#E3EBFF");
        titleImagePanel.setRadius("16px");
        titleImagePanel.setWidth(new LocaleString("32px"));
        titleImagePanel.setHeight(new LocaleString("32px"));
        ImageAp titleImage = new ImageAp();
        titleImage.setKey(this.getControlKey((ControlAp<?>)titleImage));
        titleImage.setWidth(new LocaleString("24px"));
        titleImage.setHeight(new LocaleString("24px"));
        titleImage.setImageKey("/workflow/icons/pc/other/lcfwy_customrelation_24_24.png");
        titleImage.setShrink(0);
        titleImage.setSectionMagnifier(false);
        titleImage.setControlLoading(true);
        titleImagePanel.getItems().add(titleImage);
        return titleImagePanel;
    }

    private FlexPanelAp createContentPanel(BillRelation relation) {
        BillCardData data = relation.getCardData();
        return this.createContentPanel(data.getName(), data.getDepartment(), data.getStatus());
    }

    protected FlexPanelAp createContentPanel(String textOne, String textTwo, String textThree) {
        FlexPanelAp contentPanel = new FlexPanelAp();
        contentPanel.setKey(this.getControlKey((ControlAp<?>)contentPanel));
        Style contentPanelStyle = new Style();
        Padding contentPanelPadding = new Padding();
        contentPanelPadding.setLeft("12px");
        contentPanelPadding.setRight("12px");
        contentPanelPadding.setTop("4px");
        contentPanelPadding.setBottom("8px");
        contentPanelStyle.setPadding(contentPanelPadding);
        contentPanel.setStyle(contentPanelStyle);
        contentPanel.setAlignItems(VALUE_STRETCH);
        contentPanel.setJustifyContent("space-around");
        contentPanel.setGrow(1);
        contentPanel.setWrap(false);
        contentPanel.setDirection(DIRECTION_COLUMN);
        LabelAp labelOne = new LabelAp();
        labelOne.setKey(this.getControlKey((ControlAp<?>)labelOne));
        labelOne.setName(new LocaleString(textOne));
        labelOne.setControlLoading(true);
        labelOne.setForeColor(COLOR_GREY);
        contentPanel.getItems().add(labelOne);
        LabelAp labelTwo = new LabelAp();
        labelTwo.setKey(this.getControlKey((ControlAp<?>)labelTwo));
        labelTwo.setName(new LocaleString(textTwo));
        labelTwo.setControlLoading(true);
        labelTwo.setForeColor(COLOR_GREY);
        contentPanel.getItems().add(labelTwo);
        LabelAp labelThree = new LabelAp();
        labelThree.setKey(this.getControlKey((ControlAp<?>)labelThree));
        labelThree.setName(new LocaleString(textThree));
        labelThree.setControlLoading(true);
        labelThree.setForeColor(COLOR_GREY);
        contentPanel.getItems().add(labelThree);
        return contentPanel;
    }

    protected FlexPanelAp createLinkPanel(String linkType, String identification) {
        FlexPanelAp linkPanel = new FlexPanelAp();
        linkPanel.setKey(this.getControlKey((ControlAp<?>)linkPanel));
        linkPanel.setShrink(0);
        linkPanel.setGrow(0);
        linkPanel.setWidth(new LocaleString("100%"));
        linkPanel.setJustifyContent(VALUE_CENTER);
        LabelAp linkLabel = new LabelAp();
        String caption = null;
        String ctrlKey = this.getControlKey((ControlAp<?>)linkLabel);
        if (LINK_TYPE_MORE.equals(linkType)) {
            caption = ResManager.loadKDString((String)"\u67e5\u770b\u66f4\u591a", (String)"AbstractBpmBillRelationCardDetailPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            ctrlKey = String.format(THREE_STRINGS_TEMPLATE, PREFIX_LINK_MORE, identification, ctrlKey);
        } else {
            caption = ResManager.loadKDString((String)"\u67e5\u770b\u5168\u90e8", (String)"AbstractBpmBillRelationCardDetailPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            ctrlKey = String.format(THREE_STRINGS_TEMPLATE, PREFIX_LINK_ALL, identification, ctrlKey);
        }
        linkLabel.setKey(ctrlKey);
        linkLabel.setName(new LocaleString(caption));
        linkLabel.setControlLoading(true);
        linkLabel.setClickable(true);
        linkLabel.setForeColor(COLOR_LINK);
        linkPanel.getItems().add(linkLabel);
        return linkPanel;
    }

    protected String getControlKey(ControlAp<?> controlAp) {
        return String.format("%s%s", controlAp.getClass().getSimpleName().toLowerCase(), this.index++);
    }
}

