/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.monitor.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.workflow.bizflow.graph.model.BillCardData;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.CardBillInfo;
import kd.bos.workflow.bizflow.graph.model.CustomRelationCardData;
import kd.bos.workflow.bizflow.graph.model.CustomRelationDatas;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bpm.monitor.plugin.AbstractBpmBillRelationCardDetailPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.model.BusinessModelImpl;

public class BpmBillRelationGraphCustomRelationPlugin
extends AbstractBpmBillRelationCardDetailPlugin {
    private static final String KEY_RELATIONTYPEIDS = "relationtypeIds";
    private static final String KEY_CUSTOMRELATIONENTITIES = "customRelationEntityNumbers";

    public void afterCreateNewData(EventObject evt) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)showParameter.getCustomParam("entityNumber");
        String businessKey = (String)showParameter.getCustomParam("businessKey");
        if (WfUtils.isEmpty((String)entityNumber) || WfUtils.isEmpty((String)businessKey)) {
            this.logger.debug("entityNumber or businessKey is null.");
            return;
        }
        try {
            this.initCustomRelationDatas(entityNumber, businessKey);
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            String message = ResManager.loadKDString((String)"\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u5173\u7cfb\u914d\u7f6e\u3002", (String)"BpmBillRelationGraphCustomRelationPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            if (parentView != null) {
                parentView.showErrorNotification(message);
                view.sendFormAction(parentView);
            }
            view.showErrorNotification(message);
        }
    }

    private void initCustomRelationDatas(String entityNumber, String businessKey) {
        CustomRelationDatas customRelationDatas = this.getRepositoryService().getCustomRelationDatas(entityNumber, businessKey);
        Map datasMap = customRelationDatas.getDatasMap();
        boolean noData = true;
        if (datasMap != null && !datasMap.isEmpty()) {
            Iterator iterator = datasMap.values().iterator();
            while (iterator.hasNext()) {
                if (((CustomRelationCardData)iterator.next()).getBillInfos().isEmpty()) continue;
                noData = false;
                break;
            }
        }
        if (noData) {
            this.updateMetadata("mainpanel", new ControlAp[]{this.createNoDataPanel()});
        } else {
            Map relationTypeNameMap = customRelationDatas.getTypeMap();
            Set customRelationEntities = customRelationDatas.getCustomRelationEntities();
            int index = 0;
            int initMaxSize = 3;
            HashSet<String> typeIds = new HashSet<String>(datasMap.size());
            AdvConAp[] panels = new AdvConAp[datasMap.size()];
            for (Map.Entry entry : datasMap.entrySet()) {
                Long relationTypeId = (Long)entry.getKey();
                CustomRelationCardData data = (CustomRelationCardData)entry.getValue();
                List billInfos = data.getBillInfos();
                if (billInfos.isEmpty()) {
                    this.logger.debug(String.format("%s datas is empty.", relationTypeId));
                    continue;
                }
                String relationTypeName = String.valueOf(relationTypeNameMap.get(relationTypeId));
                List<BillRelation> relations = this.getBillRelations(data, customRelationEntities, initMaxSize);
                data.setCount(relations.size());
                AdvConAp panel = this.createAdvConAp(String.format("%s (%s)", relationTypeName, billInfos.size()), relations, true, data);
                panels[index++] = panel;
                String typeId = String.valueOf(relationTypeId);
                typeIds.add(typeId);
                this.getPageCache().put(typeId, JSON.toJSONString((Object)data));
            }
            this.getPageCache().put(KEY_CUSTOMRELATIONENTITIES, SerializationUtils.toJsonString((Object)customRelationEntities));
            this.getPageCache().put(KEY_RELATIONTYPEIDS, SerializationUtils.toJsonString(typeIds));
            this.updateMetadata("mainpanel", (ControlAp<?>[])panels);
        }
    }

    private FlexPanelAp createNoDataPanel() {
        FlexPanelAp outPanel = new FlexPanelAp();
        outPanel.setKey(this.getControlKey((ControlAp<?>)outPanel));
        outPanel.setWidth(new LocaleString("100%"));
        outPanel.setDirection("column");
        outPanel.setAlignItems("center");
        outPanel.setAlignContent("center");
        outPanel.setJustifyContent("center");
        FlexPanelAp innerPanel = new FlexPanelAp();
        innerPanel.setKey(this.getControlKey((ControlAp<?>)innerPanel));
        innerPanel.setDirection("column");
        innerPanel.setAlignItems("center");
        innerPanel.setAlignContent("center");
        innerPanel.setGrow(0);
        innerPanel.setShrink(0);
        outPanel.getItems().add(innerPanel);
        ImageAp noDataImg = new ImageAp();
        noDataImg.setKey(this.getControlKey((ControlAp<?>)noDataImg));
        noDataImg.setWidth(new LocaleString("168px"));
        noDataImg.setHeight(new LocaleString("96px"));
        noDataImg.setImageKey("/workflow/images/pc/other/lcfwy_customrelation_nodata_168_96.png");
        noDataImg.setShrink(0);
        noDataImg.setSectionMagnifier(false);
        noDataImg.setControlLoading(true);
        Style noDataImgStyle = new Style();
        Margin noDataImgMargin = new Margin();
        noDataImgMargin.setBottom("8px");
        noDataImgStyle.setMargin(noDataImgMargin);
        noDataImg.setStyle(noDataImgStyle);
        innerPanel.getItems().add(noDataImg);
        LabelAp noDataLabel = new LabelAp();
        noDataLabel.setKey(this.getControlKey((ControlAp<?>)noDataLabel));
        noDataLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"BpmBillRelationGraphCustomRelationPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        noDataLabel.setFontSize(14);
        noDataLabel.setControlLoading(true);
        noDataLabel.setForeColor("#999999");
        innerPanel.getItems().add(noDataLabel);
        return outPanel;
    }

    private List<BillRelation> getBillRelations(CustomRelationCardData data, Set<String> customRelationEntities, int maxSize) {
        ArrayList<String> ids;
        List infos = data.getBillInfos();
        int size = Math.min(maxSize, infos.size());
        HashMap billCardMap = new HashMap(size);
        HashMap<String, ArrayList<String>> entityBillsMap = new HashMap<String, ArrayList<String>>(size);
        HashMap<String, String> entityNameMap = new HashMap<String, String>(size);
        ArrayList<BillRelation> relations = new ArrayList<BillRelation>(size);
        for (int i = data.getCount(); i < size; ++i) {
            BusinessModelImpl info = (BusinessModelImpl)infos.get(i);
            String string = info.getEntityNumber();
            ArrayList<BillRelation> rels = (ArrayList<BillRelation>)billCardMap.get(string);
            if (rels == null) {
                rels = new ArrayList<BillRelation>();
                billCardMap.put(string, rels);
            }
            if ((ids = (ArrayList<String>)entityBillsMap.get(string)) == null) {
                ids = new ArrayList<String>();
                entityBillsMap.put(string, ids);
            }
            ids.add(info.getBusinessKey());
            String entityName = (String)entityNameMap.get(string);
            if (entityName == null) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)string);
                entityName = String.valueOf(entityType.getDisplayName());
                entityNameMap.put(string, entityName);
            }
            BillRelation relation = new BillRelation();
            relation.setBusinessKey(info.getBusinessKey());
            relation.setEntityNumber(string);
            relation.setEntityName(entityName);
            relation.setUniqueKey(string, info.getBusinessKey());
            relation.setHasCustomRelation(customRelationEntities.contains(string));
            relations.add(relation);
            rels.add(relation);
        }
        HashMap<String, String> billNoMap = new HashMap<String, String>(entityBillsMap.size());
        for (Map.Entry entry : entityBillsMap.entrySet()) {
            String entity = (String)entry.getKey();
            ids = (List)entry.getValue();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
            billNoMap.putAll(this.getBillNoMap(entityType, ids));
        }
        Map pluginMap = BizFlowGraphUtil.getBillRelationCardPlugin(billCardMap.keySet());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        String permStrategy = (String)formShowParameter.getCustomParam("permStrategy");
        if (permStrategy == null) {
            permStrategy = "all";
        }
        Map billMap = BizFlowGraphUtil.getBillCardData(billCardMap, (Map)pluginMap, (String)appId, (String)permStrategy);
        for (BillRelation relation : relations) {
            String uniqueKey = relation.getUniqueKey();
            relation.setBillNo((String)billNoMap.get(uniqueKey));
            CardBillInfo billInfo = (CardBillInfo)billMap.get(uniqueKey);
            relation.setHasPermission(billInfo.isHasPermission());
            BillCardData cardData = relation.getCardData();
            cardData.setBill(billInfo.getBill());
            cardData.addCanNotReadFields(billInfo.getCanNotReadFields());
        }
        return relations;
    }

    @Override
    protected void showMore(String key) {
        String identification = this.getIdentification(key);
        CustomRelationCardData data = this.getRelationDataFromCache(identification);
        if (data == null) {
            this.logger.debug(String.format("showMore: CustomRelationCardData is null. %s", key));
            return;
        }
        String entities = this.getPageCache().get(KEY_CUSTOMRELATIONENTITIES);
        Set<String> customRelationEntities = new HashSet<String>();
        if (WfUtils.isNotEmpty((String)entities)) {
            customRelationEntities = (Set)SerializationUtils.fromJsonString((String)entities, Set.class);
        }
        List<BillRelation> relations = this.getBillRelations(data, customRelationEntities, 10);
        data.setCount(data.getCount() + relations.size());
        List<ControlAp<?>> children = this.getAdvConPanelChildren(relations, data);
        Container panel = (Container)this.getControl(String.format("%s-%s", "container", data.getRelationTypeId()));
        panel.deleteControls(new String[]{key});
        panel.addControls(this.getCreatedControls(children.toArray(new ControlAp[0])));
        this.getPageCache().put(identification, JSON.toJSONString((Object)data));
    }

    @Override
    protected void showAll(String key) {
        String entityNumber;
        String identification = this.getIdentification(key);
        CustomRelationCardData data = this.getRelationDataFromCache(identification);
        if (data == null) {
            this.logger.debug(String.format("showAll: CustomRelationCardData is null. %s", key));
            return;
        }
        List infos = data.getBillInfos();
        HashMap<String, ArrayList<String>> entityBillMap = new HashMap<String, ArrayList<String>>(infos.size());
        for (BusinessModelImpl businessModelImpl : infos) {
            entityNumber = businessModelImpl.getEntityNumber();
            String businessKey = businessModelImpl.getBusinessKey();
            ArrayList<String> billIds = (ArrayList<String>)entityBillMap.get(entityNumber);
            if (billIds == null) {
                billIds = new ArrayList<String>();
                entityBillMap.put(entityNumber, billIds);
            }
            billIds.add(businessKey);
        }
        for (Map.Entry entry : entityBillMap.entrySet()) {
            entityNumber = (String)entry.getKey();
            List billIds = (List)entry.getValue();
            this.showBillList(entityNumber, billIds);
        }
    }

    private CustomRelationCardData getRelationDataFromCache(String relationTypeId) {
        if (WfUtils.isEmpty((String)relationTypeId)) {
            return null;
        }
        String datas = this.getPageCache().get(relationTypeId);
        if (WfUtils.isEmpty((String)datas)) {
            return null;
        }
        return (CustomRelationCardData)JSON.parseObject((String)datas, CustomRelationCardData.class);
    }

    private AdvConAp createAdvConAp(String caption, List<BillRelation> relations, boolean collapsible, CustomRelationCardData data) {
        AdvConAp advConAp = new AdvConAp();
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("0px");
        padding.setRight("0px");
        style.setPadding(padding);
        advConAp.setStyle(style);
        advConAp.setWidth(new LocaleString("100%"));
        advConAp.setKey(this.getControlKey((ControlAp<?>)advConAp));
        advConAp.setName(new LocaleString(caption));
        advConAp.setCollapsible(collapsible);
        advConAp.setGrow(0);
        AdvConChildPanelAp advConChildPanelAp = new AdvConChildPanelAp();
        advConChildPanelAp.setKey(String.format("%s-%s", "container", data.getRelationTypeId()));
        advConChildPanelAp.setGrow(1);
        advConChildPanelAp.setWrap(true);
        Style advConChildPanelApStyle = new Style();
        Margin advConChildPanelApMargin = new Margin();
        advConChildPanelApMargin.setLeft("-20px");
        advConChildPanelApStyle.setMargin(advConChildPanelApMargin);
        advConChildPanelAp.setStyle(advConChildPanelApStyle);
        advConChildPanelAp.setDirection("row");
        advConChildPanelAp.setLazyLoad(true);
        advConAp.getItems().add(advConChildPanelAp);
        List<ControlAp<?>> children = this.getAdvConPanelChildren(relations, data);
        advConChildPanelAp.getItems().addAll(children);
        return advConAp;
    }

    private List<ControlAp<?>> getAdvConPanelChildren(List<BillRelation> relations, CustomRelationCardData data) {
        ArrayList items = new ArrayList(relations.size());
        for (BillRelation relation : relations) {
            FlexPanelAp cardPanel = this.createCardPanel(relation);
            items.add((ControlAp<?>)cardPanel);
        }
        String relationTypeId = String.valueOf(data.getRelationTypeId());
        if (data.showMoreLink()) {
            items.add((ControlAp<?>)this.createLinkPanel("more", relationTypeId));
        }
        if (data.showAllLink()) {
            items.add((ControlAp<?>)this.createLinkPanel("all", relationTypeId));
        }
        return items;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String relationTypeIds = this.getPageCache().get(KEY_RELATIONTYPEIDS);
        if (WfUtils.isNotEmpty((String)relationTypeIds)) {
            Set typeIds = (Set)SerializationUtils.fromJsonString((String)relationTypeIds, Set.class);
            for (String typeId : typeIds) {
                this.getPageCache().remove(typeId);
            }
        }
        this.getPageCache().remove(KEY_RELATIONTYPEIDS);
        this.getPageCache().remove(KEY_CUSTOMRELATIONENTITIES);
    }
}

