/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.monitor.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.workflow.bizflow.graph.handler.IBillRelationGraphPluginHandler;
import kd.bos.workflow.bpm.monitor.plugin.BpmFlowViewBillRelationGraphPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class BpmBillRelationGraphHandlerPlugin
extends AbstractWorkflowPlugin
implements IBillRelationGraphPluginHandler {
    private static final String LABEL_SIDEBARTITLE = "labelap";
    private static final String PANEL_BILLSUMMARY = "billsummary";
    private static final String PANEL_APPROVALRECORD = "billapproval";
    private static final String PANEL_STACKEDCARDS = "stackedcardpanel";
    private static final String PANEL_SUMMARYANDAPPROVAL = "summaryandapproval";
    private static final String TAB = "tabap";
    private static final String TAB_APPROVALRECORD = "approvalrecordtab";
    private static final String TAB_CONTROL_APPROVALRECORD = "approvalrecordintab";
    private static final String TAB_CONTROL_BILLSUMMARYPANEL = "summarypanelintab";
    private static final String PAGEID_VIEWSTACKEDBILLS = "viewStackedBillsPageId";
    private static final String PAGEID_CUSTOMRELATION = "customRelationPageId";
    private static final String FORMID_VIEWSTACKEDBILLS = "bpm_viewstackedbills";
    private static final String KKEY_PROCINSTID = "procinstid";
    private static final String KEY_SELECTED_BUSINESSKEY = "selectedBusinessKey";
    private static final String KEY_SELECTED_ENTITYNUMBER = "selectedEntityNumber";

    public void selectCard(Map<String, Object> params) {
        String businessKey = (String)params.get("businessKey");
        if (WfUtils.isEmpty((String)businessKey)) {
            return;
        }
        String entityNumber = (String)params.get("entityNumber");
        String text = ResManager.loadKDString((String)"\u5ba1\u6279\u8bb0\u5f55", (String)"BpmBillRelationGraphHandlerPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        String procInstId = (String)this.getModel().getValue(KKEY_PROCINSTID);
        String activityInstId = (String)params.get("activityInstId");
        if (WfUtils.isNotEmpty((String)activityInstId) && !"0".equals(activityInstId) || WfUtils.isNotEmpty((String)entityNumber)) {
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            BpmFlowViewBillRelationGraphPlugin graphPlugin = (BpmFlowViewBillRelationGraphPlugin)pluginProxy.getPlugin(BpmFlowViewBillRelationGraphPlugin.class.getCanonicalName());
            Object hasCustomRelation = params.get("hasCustomRelation");
            if ("true".equals(String.valueOf(hasCustomRelation))) {
                text = ResManager.loadKDString((String)"\u8282\u70b9\u8be6\u60c5", (String)"BpmBillRelationGraphHandlerPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                this.getPageCache().put(KEY_SELECTED_ENTITYNUMBER, entityNumber);
                this.getPageCache().put(KEY_SELECTED_BUSINESSKEY, businessKey);
                this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_BILLSUMMARY, PANEL_APPROVALRECORD, PANEL_STACKEDCARDS});
                this.getView().setVisible(Boolean.TRUE, new String[]{TAB});
                graphPlugin.dynamicSetControlKey(TAB_CONTROL_APPROVALRECORD, TAB_CONTROL_BILLSUMMARYPANEL);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{TAB, PANEL_STACKEDCARDS});
                this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_BILLSUMMARY, PANEL_APPROVALRECORD});
            }
            Label sidebarTitle = (Label)this.getControl(LABEL_SIDEBARTITLE);
            sidebarTitle.setText(text);
            graphPlugin.showNodeDetailInfo(procInstId, activityInstId, entityNumber, businessKey);
        } else {
            this.hideNodeDetailPanel();
        }
    }

    public void selectStackedCard(Map<String, Object> params) {
        String entityNumber = (String)params.get("entityNumber");
        this.showStackedBillsInSidebar(entityNumber, params);
        Label sidebarTitle = (Label)this.getControl(LABEL_SIDEBARTITLE);
        sidebarTitle.setText(ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e\u7ec4", (String)"BpmBillRelationGraphHandlerPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    private void showStackedBillsInSidebar(String entityNumber, Map<String, Object> params) {
        this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_APPROVALRECORD, TAB, PANEL_BILLSUMMARY});
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_SUMMARYANDAPPROVAL, PANEL_STACKEDCARDS});
        List ids = (List)params.get("billIds");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("entityNumber", entityNumber);
        parameters.put("billIds", ids);
        String permStrategy = (String)this.getView().getFormShowParameter().getCustomParam("permStrategy");
        parameters.put("permStrategy", permStrategy);
        String pageId = this.showFormInContainer(FORMID_VIEWSTACKEDBILLS, PANEL_STACKEDCARDS, parameters);
        this.getPageCache().put(PAGEID_VIEWSTACKEDBILLS, pageId);
    }

    public void deselectCard(Map<String, Object> params) {
        this.closeCustomRelationPage();
        this.hidePanelAndClearCache();
    }

    private void closeCustomRelationPage() {
        IFormView customRelationView = null;
        String customRelationPageId = this.getPageCache().get(PAGEID_CUSTOMRELATION);
        if (customRelationPageId != null && (customRelationView = this.getView().getView(customRelationPageId)) != null) {
            customRelationView.close();
            this.getView().sendFormAction(customRelationView);
            this.getPageCache().remove(PAGEID_CUSTOMRELATION);
            Tab tab = (Tab)this.getControl(TAB);
            tab.activeTab(TAB_APPROVALRECORD);
        }
    }

    private void hidePanelAndClearCache() {
        this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_SUMMARYANDAPPROVAL});
        this.getPageCache().remove(KEY_SELECTED_BUSINESSKEY);
        this.getPageCache().remove(KEY_SELECTED_ENTITYNUMBER);
    }

    public void deselectStackedCard(Map<String, Object> params) {
        this.closeStackedBillPage();
        this.hidePanelAndClearCache();
    }

    private void closeStackedBillPage() {
        IFormView stackedBillsView = null;
        String stackedBillsPageId = this.getPageCache().get(PAGEID_VIEWSTACKEDBILLS);
        if (stackedBillsPageId != null && (stackedBillsView = this.getView().getView(stackedBillsPageId)) != null) {
            stackedBillsView.close();
            this.getView().sendFormAction(stackedBillsView);
            this.getPageCache().remove(PAGEID_VIEWSTACKEDBILLS);
        }
    }

    public void hideNodeDetailPanel() {
        this.closeCustomRelationPage();
        this.closeStackedBillPage();
        this.hidePanelAndClearCache();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(PAGEID_VIEWSTACKEDBILLS);
        this.getPageCache().remove(KEY_SELECTED_BUSINESSKEY);
        this.getPageCache().remove(KEY_SELECTED_ENTITYNUMBER);
    }
}

