/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.monitor.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.form.FormShowParameter;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bizflow.graph.model.BillCardConfig;
import kd.bos.workflow.bizflow.graph.model.BillCardData;
import kd.bos.workflow.bizflow.graph.model.BillCardTpl;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.CardBillInfo;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bpm.monitor.plugin.AbstractBpmBillRelationCardDetailPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;

public class BpmBillRelationGraphViewStackedBillPlugin
extends AbstractBpmBillRelationCardDetailPlugin {
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String BILLIDS = "billIds";
    private static final String LINE_FIRST = "first";
    private static final String LINE_SECOND = "second";
    private static final String LINE_THIRD = "third";
    private static final String LINE_TEXT_TPL = "%s %s";

    public void afterCreateNewData(EventObject e) {
        boolean showSummary;
        int maxSize = 10;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String entityNumber = (String)params.get(ENTITYNUMBER);
        List billIds = (List)params.get(BILLIDS);
        if (billIds == null || billIds.isEmpty()) {
            this.logger.debug(String.format("billIds is null. %s", entityNumber));
            return;
        }
        HashSet<String> entityNumbers = new HashSet<String>();
        entityNumbers.add(entityNumber);
        String appId = this.getView().getFormShowParameter().getAppId();
        Map pluginMap = BizFlowGraphUtil.getBillRelationCardPlugin(entityNumbers);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String entityName = String.valueOf(entityType.getDisplayName());
        int size = Math.min(maxSize, billIds.size());
        List<String> queryBillIds = billIds.subList(0, size);
        Map<String, String> billNoMap = this.getBillNoMap(entityType, queryBillIds);
        HashMap billCardMap = new HashMap(size);
        ArrayList<BillRelation> relations = new ArrayList<BillRelation>(size);
        for (int i = 0; i < size; ++i) {
            String billId = (String)billIds.get(i);
            String uniqueKey = BizFlowGraphUtil.getUniqueKey((String)entityNumber, (String)billId);
            String billNo = billNoMap.get(uniqueKey);
            if (billNo == null) continue;
            BillRelation relation = new BillRelation();
            relation.setBusinessKey(billId);
            relation.setEntityName(entityName);
            relation.setEntityNumber(entityNumber);
            relation.setUniqueKey(entityNumber, billId);
            relation.setBillNo(billNo);
            relations.add(relation);
        }
        billCardMap.put(entityNumber, relations);
        String permStrategy = (String)params.get("permStrategy");
        if (permStrategy == null) {
            permStrategy = "all";
        }
        Map billMap = BizFlowGraphUtil.getBillCardData(billCardMap, (Map)pluginMap, (String)appId, (String)permStrategy);
        boolean hasCustomRelation = this.hasCustomRelationEntityNumbers(entityNumber);
        boolean exceedLimit = billIds.size() > size;
        int length = exceedLimit ? relations.size() + 1 : relations.size();
        FlexPanelAp summaryPanel = this.createSummaryPanel(entityNumber, billIds);
        boolean bl = showSummary = summaryPanel != null;
        if (showSummary) {
            ++length;
        }
        int index = 0;
        FlexPanelAp[] panels = new FlexPanelAp[length];
        if (showSummary) {
            panels[0] = summaryPanel;
            index = 1;
        }
        for (BillRelation relation : relations) {
            String uniqueKey = relation.getUniqueKey();
            relation.setHasCustomRelation(hasCustomRelation);
            CardBillInfo billInfo = (CardBillInfo)billMap.get(uniqueKey);
            relation.setHasPermission(billInfo.isHasPermission());
            BillCardData cardData = relation.getCardData();
            cardData.setBill(billInfo.getBill());
            cardData.addCanNotReadFields(billInfo.getCanNotReadFields());
            FlexPanelAp cardPanel = this.createCardPanel(relation);
            panels[index++] = cardPanel;
        }
        if (exceedLimit) {
            panels[index] = this.createLinkPanel("all", "stacked");
        }
        this.updateMetadata("mainpanel", (ControlAp<?>[])panels);
    }

    private FlexPanelAp createSummaryPanel(String entityNumber, List<String> billIds) {
        Map<String, String> fieldMap = this.getSummaryFieldValue(entityNumber, billIds);
        if (fieldMap.isEmpty()) {
            return null;
        }
        FlexPanelAp panel = new FlexPanelAp();
        panel.setKey(this.getControlKey((ControlAp<?>)panel));
        panel.setRadius("4px");
        Style cardPanelStyle = new Style();
        Margin cardPanelMargin = new Margin();
        cardPanelMargin.setBottom("10px");
        cardPanelStyle.setMargin(cardPanelMargin);
        panel.setStyle(cardPanelStyle);
        panel.setWidth(new LocaleString("100%"));
        panel.setHeight(new LocaleString("128px"));
        panel.setShrink(0);
        panel.setGrow(0);
        panel.setAlignItems("stretch");
        panel.setWrap(false);
        panel.setDirection("column");
        panel.setBackgroundImg("/workflow/images/pc/other/lcfwy_bpm_billrelationgraph_summary_294_128.png");
        FlexPanelAp contentPanel = this.createContentPanel(fieldMap.get(LINE_FIRST), fieldMap.get(LINE_SECOND), fieldMap.get(LINE_THIRD));
        Padding padding = contentPanel.getStyle().getPadding();
        padding.setTop("14px");
        padding.setBottom("25px");
        LabelAp label = new LabelAp();
        label.setKey(this.getControlKey((ControlAp<?>)label));
        label.setName(new LocaleString(ResManager.loadKDString((String)"\u6c47\u603b\u6458\u8981\u4fe1\u606f", (String)"BpmBillRelationGraphViewStackedBillPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        label.setControlLoading(true);
        label.setFontSize(14);
        label.setFontWeight("400");
        label.setForeColor("#212121");
        Style labelStyle = new Style();
        Margin labelMargin = new Margin();
        labelMargin.setBottom("5px");
        labelStyle.setMargin(labelMargin);
        label.setStyle(labelStyle);
        contentPanel.getItems().add(0, label);
        panel.getItems().add(contentPanel);
        return panel;
    }

    private Map<String, String> getSummaryFieldValue(String entityNumber, List<String> billIds) {
        String appId;
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> entityNumbers = new HashSet<String>();
        entityNumbers.add(entityNumber);
        Map billCardTplMap = BizFlowGraphUtil.getBillCardDataFields(entityNumbers);
        BillCardTpl stackedCardTpl = (BillCardTpl)billCardTplMap.get("bpm_billrelation_stkcard");
        if (stackedCardTpl == null) {
            return result;
        }
        List configs = stackedCardTpl.getBillCardConfigs(entityNumber);
        if (configs == null || configs.isEmpty()) {
            return result;
        }
        Set canNotReadFields = new HashSet();
        long userId = RequestContext.get().getCurrUserId();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRule fieldRule = permissionService.getFieldRulesSum(userId, appId = BizFlowGraphUtil.getAppId((String)entityNumber, (String)this.getView().getFormShowParameter().getAppId()), entityNumber);
        if (fieldRule != null) {
            canNotReadFields = fieldRule.getCanNotReadFields();
        }
        HashSet<String> sqlFields = new HashSet<String>();
        HashSet<String> functionFields = new HashSet<String>();
        int count = billIds.size();
        String alias = LINE_FIRST;
        BillCardConfig config = (BillCardConfig)configs.get(0);
        LinkedHashMap<String, BillCardConfig> aliasConfigMap = new LinkedHashMap<String, BillCardConfig>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (canNotReadFields.contains(config.getField())) {
            result.put(alias, this.getAsteriskText(config.getShowContent()));
        } else if (this.isSumFunction(config, entityType)) {
            aliasConfigMap.put(alias, config);
            this.buildQuerySummaryFields(sqlFields, functionFields, alias, config, entityType);
        } else {
            result.put(alias, this.getShowValue(count, config));
        }
        int size = configs.size();
        if (size > 1) {
            alias = LINE_SECOND;
            config = (BillCardConfig)configs.get(1);
            if (canNotReadFields.contains(config.getField())) {
                result.put(alias, this.getAsteriskText(config.getShowContent()));
            } else if (this.isSumFunction(config, entityType)) {
                aliasConfigMap.put(alias, config);
                this.buildQuerySummaryFields(sqlFields, functionFields, alias, config, entityType);
            } else {
                result.put(alias, this.getShowValue(count, config));
            }
        }
        if (size > 2) {
            alias = LINE_THIRD;
            config = (BillCardConfig)configs.get(2);
            if (canNotReadFields.contains(config.getField())) {
                result.put(alias, this.getAsteriskText(config.getShowContent()));
            } else if (this.isSumFunction(config, entityType)) {
                aliasConfigMap.put(alias, config);
                this.buildQuerySummaryFields(sqlFields, functionFields, alias, config, entityType);
            } else {
                result.put(alias, this.getShowValue(count, config));
            }
        }
        if (aliasConfigMap.isEmpty()) {
            return result;
        }
        String algoKey = "wf.billRelationGraph.queryStackedCardSummary";
        String funcQueryField = WfUtils.listToString(functionFields, (String)",");
        Object billId = billIds.get(0);
        QFilter idFilter = new QFilter("id", "in", billIds);
        boolean isLongType = BizFlowGraphUtil.isLongType((Class)BizFlowGraphUtil.getEntityPKType((String)entityNumber));
        if (isLongType) {
            billId = Long.valueOf(billIds.get(0));
            idFilter = new QFilter("id", "in", (Object)WfUtils.stringListToLongArray(billIds));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityNumber, (String)funcQueryField, (QFilter[])new QFilter[]{idFilter}, null);){
            if (ds.hasNext()) {
                Row row = ds.next();
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", billId)};
                String queryField = WfUtils.listToString(sqlFields, (String)",");
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)queryField, (QFilter[])filters);
                for (Map.Entry entry : aliasConfigMap.entrySet()) {
                    String aliasField = (String)entry.getKey();
                    BillCardConfig cardConfig = (BillCardConfig)entry.getValue();
                    Object value = row.get(aliasField);
                    Object formatedValue = this.getFormattedValue(bill, cardConfig.getField(), value);
                    result.put(aliasField, String.format(LINE_TEXT_TPL, cardConfig.getShowContent(), formatedValue));
                }
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("query stackedCard value failed: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return result;
    }

    private String getAsteriskText(String showContent) {
        return String.format(LINE_TEXT_TPL, showContent, "******");
    }

    private Object getFormattedValue(DynamicObject bill, String field, Object value) {
        Object formattedValue = value;
        try {
            formattedValue = ExpressionCalculatorUtil.numberOrCurrencyFormatIncludeEntryType((DynamicObject)bill, (String)field, (Object)value, (boolean)true);
        }
        catch (Exception fe) {
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)fe));
        }
        return formattedValue;
    }

    private String getShowValue(int count, BillCardConfig config) {
        if ("count".equals(config.getAggregateFunction())) {
            return String.format(LINE_TEXT_TPL, config.getShowContent(), count);
        }
        return config.getShowContent();
    }

    private void buildQuerySummaryFields(Set<String> sqlFields, Set<String> functionFields, String alias, BillCardConfig config, MainEntityType entityType) {
        QtyProp qtyProp;
        String propName;
        String field = config.getField();
        DynamicProperty property = entityType.getProperty(field);
        if (property instanceof AmountProp) {
            AmountProp amountProp = (AmountProp)property;
            String propName2 = amountProp.getControlPropName();
            if (WfUtils.isNotEmpty((String)propName2)) {
                sqlFields.add(propName2);
            }
        } else if (property instanceof QtyProp && WfUtils.isNotEmpty((String)(propName = (qtyProp = (QtyProp)property).getControlPropName()))) {
            sqlFields.add(propName);
        }
        sqlFields.add(field);
        functionFields.add(String.format("%s(%s) %s", config.getAggregateFunction(), field, alias));
    }

    private boolean isSumFunction(BillCardConfig config, MainEntityType entityType) {
        boolean isSumFunction = "sum".equals(config.getAggregateFunction());
        if (isSumFunction) {
            DynamicProperty property = entityType.getProperty(config.getField());
            return property instanceof DecimalProp;
        }
        return isSumFunction;
    }

    private boolean hasCustomRelationEntityNumbers(String entityNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("relationtype", "not in", (Object)new String[]{"botp", "dap"}), new QFilter("srcbill", "=", (Object)entityNumber).or(new QFilter("targetbill", "=", (Object)entityNumber))};
        Long count = this.getRepositoryService().getEntityCountByFilter("bpm_billrelationmodel", filters);
        return count != null && count > 0L;
    }

    @Override
    protected void showAll(String key) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)showParameter.getCustomParam(ENTITYNUMBER);
        List billIds = (List)showParameter.getCustomParam(BILLIDS);
        this.showBillList(entityNumber, billIds);
    }
}

