/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.monitor.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphCell;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphData;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bpm.monitor.plugin.BpmBillRelationGraphHandlerPlugin;
import kd.bos.workflow.bpm.monitor.plugin.billrelation.BOTPBillRelationGraphInitPlugin;
import kd.bos.workflow.bpm.monitor.plugin.billrelation.BizFlowBillRelationGraphInitPlugin;
import kd.bos.workflow.bpm.monitor.plugin.billrelation.CustomBillRelationGraphInitPlugin;
import kd.bos.workflow.bpm.monitor.plugin.billrelation.IBillRelationGraphInitPlugin;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.component.WorkflowDesigner;
import kd.bos.workflow.design.plugin.IWorkflowDesigner;
import kd.bos.workflow.design.plugin.WorkflowViewBPMFlowchartPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import org.dom4j.Element;
import org.dom4j.Node;

public class BpmFlowViewBillRelationGraphPlugin
extends WorkflowViewBPMFlowchartPlugin
implements IWorkflowDesigner,
TabSelectListener {
    private static final String KEY_ID = "id";
    private static final String KEY_RELATION_GRAPH = "relation_graph";
    private static final String KEY_LAYOUT_HORIZONTAL = "horizontal";
    private static final String KEY_STACKEDNODEIDS = "stackedNodeIds";
    private static final String KEY_SELECTED_BUSINESSKEY = "selectedBusinessKey";
    private static final String KEY_SELECTED_ENTITYNUMBER = "selectedEntityNumber";
    private static final String PROCINSTID = "procinstid";
    private static final String TOOLBAR = "toolbarap";
    private static final String BTN_CLOSE = "close";
    private static final String BTN_REFRESH = "refresh";
    private static final String BTN_GOBACK = "goback";
    private static final String TAB = "tabap";
    private static final String TAB_CUSTOMRELATION = "customrelationtab";
    private static final String FORMID_CUSTOMRELATION = "bpm_customrelation";
    private static final String PAGEID_CUSTOMRELATION = "customRelationPageId";
    private static final String WORKFLOW_DESIGNER = "workflowdesigner";
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{TOOLBAR});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initConfigParams();
        this.setIsRelationGraph(true);
        this.cacheParamDatas();
    }

    private void cacheParamDatas() {
        this.cacheCustomBillCards();
        this.cacheSelectedRowData();
    }

    private void cacheCustomBillCards() {
        String datas = (String)this.getView().getFormShowParameter().getCustomParam("billCards");
        if (WfUtils.isNotEmpty((String)datas)) {
            this.getPageCache().put("billCards", datas);
        }
    }

    private void cacheSelectedRowData() {
        String rowData = (String)this.getView().getFormShowParameter().getCustomParam("selectedRowData");
        if (WfUtils.isNotEmpty((String)rowData)) {
            this.getPageCache().put("selectedRowData", rowData);
        }
    }

    private void initConfigParams() {
        HashMap<String, String> config = new HashMap<String, String>(2);
        config.put(KEY_LAYOUT_HORIZONTAL, "true");
        this.getPageCache().put(config);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "refresh": {
                this.refresh();
                break;
            }
            case "goback": {
                this.goback();
                break;
            }
            default: {
                super.itemClick(evt);
            }
        }
    }

    private void switchLayout(Map<String, Object> param) {
        boolean horizontal = Boolean.TRUE.equals(param.get(KEY_LAYOUT_HORIZONTAL));
        if (horizontal) {
            this.getPageCache().put(KEY_LAYOUT_HORIZONTAL, "true");
        } else {
            this.getPageCache().put(KEY_LAYOUT_HORIZONTAL, "false");
        }
        this.refresh();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("block", false);
        this.getDesigner().notify("showBlock", params, this.getView());
    }

    private void goback() {
        this.getDesigner().cleanRecordsState();
        this.hideNodeDetailPanel();
        this.setIsRelationGraph(true);
        String procInstId = this.getPageCache().get(KEY_ID);
        if (procInstId != null) {
            this.getModel().setValue(PROCINSTID, (Object)Long.valueOf(procInstId));
        } else {
            this.getModel().setValue(PROCINSTID, null);
        }
        this.getView().setVisible(Boolean.FALSE, BUTTONS);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_GOBACK, "barprecomputator", "viewbillrelation", "barviewapprovalrecord"});
        this.reloadBillRelationGraph();
    }

    private void refresh() {
        String isRelation = this.getPageCache().get(KEY_RELATION_GRAPH);
        if ("true".equals(isRelation)) {
            this.reloadBillRelationGraph();
            this.hideNodeDetailPanel();
        } else {
            super.refreshPage();
        }
    }

    private void reloadBillRelationGraph() {
        WorkflowDesigner designer = this.getDesigner();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("procInstId", this.getModel().getValue(PROCINSTID));
        FormShowParameter parameter = this.getView().getFormShowParameter();
        params.put("billId", parameter.getCustomParam("billId"));
        params.put("entityNumber", parameter.getCustomParam("entityNumber"));
        params.put("permStrategy", parameter.getCustomParam("permStrategy"));
        try {
            IBillRelationGraphInitPlugin initPlugin = this.getGraphInitPlugin(params);
            BillRelationGraphData graphData = initPlugin.getRefreshedGraphData(this.getView(), params);
            if (graphData != null) {
                Map<String, Object> initData = this.getInitData(graphData);
                initData.put("time", String.valueOf(WfUtils.now().getTime()));
                designer.open("WorkflowModel", initData);
            }
        }
        catch (Exception e) {
            this.showLoadErrorNotification(e);
        }
    }

    private void showLoadErrorNotification(Exception e) {
        if (e instanceof KDBizException) {
            this.getView().showErrorNotification(e.getMessage());
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u4e0a\u4e0b\u6e38\u5355\u636e\u5173\u7cfb\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u5f53\u524d\u4e1a\u52a1\u573a\u666f\u3002", (String)"BpmFlowViewBillRelationGraphPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
    }

    private WorkflowDesigner getDesigner() {
        return (WorkflowDesigner)this.getControl(WORKFLOW_DESIGNER);
    }

    @Override
    public void afterLoadInitData(Map<String, Object> params) {
        try {
            IBillRelationGraphInitPlugin initPlugin = this.getGraphInitPlugin(params);
            BillRelationGraphData graphData = initPlugin.getIntegratedGraphData(this.getView(), params);
            if (graphData != null) {
                Map<String, Object> initData = this.getInitData(graphData);
                initData.put("time", String.valueOf(WfUtils.now().getTime()));
                this.getDesigner().open("WorkflowModel", initData);
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void cacheStackedBillInfo(Map<String, List<String>> businessKeysMap) {
        Set<String> nodeIds = businessKeysMap.keySet();
        this.getPageCache().put(KEY_STACKEDNODEIDS, SerializationUtils.toJsonString(nodeIds));
        HashMap<String, String> cacheMap = new HashMap<String, String>(businessKeysMap.size());
        for (Map.Entry<String, List<String>> entry : businessKeysMap.entrySet()) {
            String nodeId = entry.getKey();
            String key = this.getStackedNodeIdCacheKey(nodeId);
            List<String> billIds = entry.getValue();
            cacheMap.put(key, SerializationUtils.toJsonString(billIds));
        }
        this.getPageCache().put(cacheMap);
    }

    private String getStackedNodeIdCacheKey(String nodeId) {
        return String.format("%s.%s", "stackedBillIds", nodeId);
    }

    private void removeStackedBillInfo() {
        String nodeIdStr = this.getPageCache().get(KEY_STACKEDNODEIDS);
        if (nodeIdStr == null) {
            return;
        }
        Set nodeIds = (Set)SerializationUtils.fromJsonString((String)nodeIdStr, Set.class);
        ArrayList<String> keys = new ArrayList<String>(nodeIds.size());
        for (String nodeId : nodeIds) {
            String key = this.getStackedNodeIdCacheKey(nodeId);
            keys.add(key);
        }
        this.getPageCache().batchRemove(keys);
    }

    @Override
    public Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        this.getPageCache().put("showAdminButtons", "true".equals(params.get("showButtons")) ? "true" : "false");
        String isRelation = this.getPageCache().get(KEY_RELATION_GRAPH);
        if ("false".equals(isRelation)) {
            return super.getDesignerInitData(params);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_REFRESH, BTN_CLOSE});
        try {
            IBillRelationGraphInitPlugin initPlugin = this.getGraphInitPlugin(params);
            BillRelationGraphData graphData = initPlugin.getInitGraphData(this.getView(), params);
            return this.getInitData(graphData);
        }
        catch (Exception e) {
            this.showLoadErrorNotification(e);
            return this.getInitData(BizFlowGraphUtil.createBpmnModel((String)ModelType.BizFlow.name(), (String)"bill_circulaterelation"));
        }
    }

    private Map<String, Object> getInitData(BillRelationGraphData graphData) {
        if (graphData == null) {
            BpmnModel bpmnModel = BizFlowGraphUtil.createBpmnModel((String)ModelType.BizFlow.name(), (String)"bill_circulaterelation");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6d41\u7a0b\u6682\u65e0\u5355\u636e\u5173\u7cfb\u6570\u636e\u3002", (String)"BpmFlowViewBillRelationGraphPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return this.getInitData(bpmnModel);
        }
        if (WfUtils.isNotEmpty((String)graphData.getTip())) {
            this.getView().showTipNotification(graphData.getTip());
        }
        this.cacheStackedBillInfo(graphData.getBusinessKeysMap());
        if (graphData.getGraphRoot() != null) {
            return this.getInitJsonData(graphData.getGraphRoot());
        }
        return this.getInitData(graphData.getBpmnModel());
    }

    private Map<String, Object> getInitJsonData(BillRelationGraphCell graphRoot) {
        JSONObject jsonData = new JSONObject();
        jsonData.put("time", (Object)String.valueOf(WfUtils.now().getTime()));
        jsonData.put("root", (Object)graphRoot);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("graph_json", SerializationUtils.toJsonString((Object)jsonData));
        data.put("flowType", ModelType.BizFlow.name());
        data.put("isBillRelationGraph", true);
        return data;
    }

    private Map<String, Object> getInitData(BpmnModel bpmnModel) {
        GraphCodecContext context = new GraphCodecContext(bpmnModel);
        context.setBillRelation(true);
        HashMap<String, Object> data = new HashMap<String, Object>();
        Node node = GraphCodecUtils.convertBpmnModelToNode((BpmnModel)bpmnModel, (GraphCodecContext)context);
        String path = String.format("/mxGraphModel/root/mxCell/Object[@process_id=\"%s\"]", "bill_circulaterelation");
        Node propNode = node.getDocument().getRootElement().selectSingleNode(path);
        if (propNode instanceof Element) {
            ((Element)propNode).addAttribute("time", String.valueOf(WfUtils.now().getTime()));
        }
        data.put("graph_xml", node.asXML());
        data.put("flowType", ModelType.BizFlow.name());
        data.put("isBillRelationGraph", context.isBillRelation());
        return data;
    }

    @Override
    public void updateProcInstId(String procInstId, Map<String, Object> data) {
        this.setIsRelationGraph(false);
        this.getModel().setValue(PROCINSTID, (Object)procInstId);
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_GOBACK});
        super.refreshPage();
    }

    @Override
    public void handleCustomEvent(String type, Map<String, Object> param) {
        if ("switchLayout".equals(type)) {
            this.switchLayout(param);
        }
    }

    private void hideNodeDetailPanel() {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        BpmBillRelationGraphHandlerPlugin handlerPlugin = (BpmBillRelationGraphHandlerPlugin)pluginProxy.getPlugin(BpmBillRelationGraphHandlerPlugin.class.getCanonicalName());
        handlerPlugin.hideNodeDetailPanel();
    }

    public void showNodeDetailInfo(String procInstId, String activityInstId, String entityNumber, String businessKey) {
        this.updateBillSummaryAndApprovalRecored(procInstId, activityInstId, entityNumber, businessKey, true);
    }

    public void dynamicSetControlKey(String approvalRecordKey, String billSummaryPanel) {
        this.approvalRecordKey = approvalRecordKey;
        this.billSummaryPanel = billSummaryPanel;
    }

    private void setIsRelationGraph(boolean isRelationGraph) {
        this.getPageCache().put(KEY_RELATION_GRAPH, isRelationGraph ? "true" : "false");
    }

    @Override
    protected void switchButtonVisibility(Long procInstId) {
        super.switchButtonVisibility(procInstId);
        if (this.getView().getFormShowParameter().getCustomParam("billId") != null) {
            this.getView().setVisible(Boolean.FALSE, BUTTONS);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        if (TAB_CUSTOMRELATION.equals(key)) {
            this.loadCustomRelationPage();
        }
    }

    private void loadCustomRelationPage() {
        String pageId = this.getPageCache().get(PAGEID_CUSTOMRELATION);
        if (pageId == null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            FormShowParameter parameter = this.getView().getFormShowParameter();
            params.put("entityNumber", this.getPageCache().get(KEY_SELECTED_ENTITYNUMBER));
            params.put("businessKey", this.getPageCache().get(KEY_SELECTED_BUSINESSKEY));
            params.put("permStrategy", parameter.getCustomParam("permStrategy"));
            pageId = this.showFormInContainer(FORMID_CUSTOMRELATION, TAB_CUSTOMRELATION, params);
            this.getPageCache().put(PAGEID_CUSTOMRELATION, pageId);
        }
    }

    private IBillRelationGraphInitPlugin getGraphInitPlugin(Map<String, Object> params) {
        String datas = this.getPageCache().get("billCards");
        if (WfUtils.isNotEmpty((String)datas)) {
            return new CustomBillRelationGraphInitPlugin();
        }
        String procInstId = (String)params.get("procInstId");
        if (WfUtils.isEmpty((String)procInstId)) {
            return new BOTPBillRelationGraphInitPlugin();
        }
        return new BizFlowBillRelationGraphInitPlugin();
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_ID);
        this.getPageCache().remove(KEY_RELATION_GRAPH);
        this.getPageCache().remove(KEY_LAYOUT_HORIZONTAL);
        this.getPageCache().remove(PAGEID_CUSTOMRELATION);
        this.getPageCache().remove("billCards");
        this.removeStackedBillInfo();
    }
}

