/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.monitor.plugin;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;

public class ViewBillRelationGraphUtil {
    private static Log log = LogFactory.getLog(ViewBillRelationGraphUtil.class);

    public static void showStackedBills(String entityNumber, List<String> ids, Object title, IFormView view, String parentPageId) {
        String appId = view.getFormShowParameter().getAppId();
        ListShowParameter showParameter = null;
        showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNumber);
        ListFilterParameter filterParameter = new ListFilterParameter();
        Class pkType = null;
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            pkType = entityType.getPrimaryKey().getPropertyType();
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (ids != null && !ids.isEmpty()) {
            if (pkType != null && (Long.TYPE.isAssignableFrom(pkType) || Long.class.isAssignableFrom(pkType))) {
                List longIds = BizFlowUtil.getLongBusinessKeys(ids);
                for (Long id : longIds) {
                    showParameter.addLinkQueryPkId((Object)id);
                }
            } else {
                for (String id : ids) {
                    showParameter.addLinkQueryPkId((Object)id);
                }
            }
        } else {
            filterParameter.setFilter(new QFilter("1", "!=", (Object)1));
            showParameter.setListFilterParameter(filterParameter);
        }
        showParameter.setCustomParam("hasright", (Object)Boolean.TRUE);
        showParameter.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
        showParameter.setCustomParam("appid", (Object)appId);
        showParameter.setAppId(appId);
        showParameter.setParentPageId(parentPageId);
        ViewBillRelationGraphUtil.showBillForm((FormShowParameter)showParameter, String.format(ResManager.loadKDString((String)"%s\u5217\u8868", (String)"ViewBillRelationGraphUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), title), view);
    }

    public static void showBillForm(FormShowParameter showParameter, String caption, IFormView view) {
        IFormView tabView = null;
        tabView = ViewFlowchartUtil.getTabControlView((IFormView)view);
        if (tabView != null) {
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (caption != null) {
                showParameter.setCaption(caption);
            }
            tabView.showForm(showParameter);
            view.sendFormAction(tabView);
        } else {
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm(showParameter);
        }
    }
}

