/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ControlTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.task.center.util.Navigationutils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.MCNavigationItemCustomEvent;

@DataEntityTypeAttribute(name="kd.bos.workflow.component.WFNavigationBar")
public class WFNavigationBar
extends Control {
    public static final String ACTION_REFRESH = "refreshWfNavigation";
    public static final String REFRESHDATA = "refreshData";
    private Map<String, List> data;
    private String operationKey;
    protected List<ItemClickListener> barItemClickListeners = new ArrayList<ItemClickListener>();

    public WFNavigationBar() {
        ControlTypes.register(((Object)((Object)this)).getClass());
    }

    public String getOperationKey() {
        return this.operationKey;
    }

    public void setOperationKey(String operationKey) {
        this.operationKey = operationKey;
    }

    public void addCustomListListener(ItemClickListener listener) {
        this.barItemClickListeners.add(listener);
    }

    public Map<String, List> getData() {
        return this.data;
    }

    public void setData(Map<String, List> data, String selectedTab, String expandItem) {
        this.data = data;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("wfNavigationItems", data);
        param.put("selectedTab", selectedTab);
        param.put("expandItem", expandItem);
        param.put("key", this.getKey());
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SHOW_WFNAVIGATION", param);
    }

    public void itemClick(LinkedHashMap<?, ?> id) {
        this.itemClick(id, null);
    }

    public void refreshData(IFormView view) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("key", this.getKey());
        ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction(ACTION_REFRESH, param);
    }

    public void refreshNavData() {
        String uid = RequestContext.get().getUserId();
        long userId = Long.parseLong(uid);
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, List> data = new HashMap<String, List>();
        if (this.getView().getEntityId().equals("wf_msg_center")) {
            HashMap taskData = wfService.getTaskService().getMCNavigationData(userId);
            List taskNodes = Navigationutils.getNavigationNodes((List)((List)taskData.get("task")));
            List transfer = Navigationutils.getNavigationNodes((List)((List)taskData.get("transfer")));
            taskNodes.addAll(transfer);
            List delegate = Navigationutils.getNavigationNodes((List)((List)taskData.get("delegate")));
            taskNodes.addAll(delegate);
            List customs = Navigationutils.getNavigationNodes((List)((List)taskData.get("custom")));
            taskNodes.addAll(customs);
            data.put("task", taskNodes);
            List msgNodes = Navigationutils.getNavigationNodes((List)((List)taskData.get("message")));
            data.put("message", msgNodes);
            MCNavigationItemCustomEvent args = new MCNavigationItemCustomEvent(this.getView(), "MCNavigationItemInit", "MCNavigationItemInitEvent", null, userId, taskNodes);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent((CustomEventArgs)args);
        }
        param.put("wfNavigationItems", data);
        param.put("key", "wfnavigationbarap");
        IPageCache pageCache = this.getView().getPageCache();
        if (pageCache.get(REFRESHDATA) != null) {
            Map refreshData = (Map)SerializationUtils.fromJsonString((String)pageCache.get(REFRESHDATA), Map.class);
            if (WfUtils.isNotEmpty((String)((String)refreshData.get("selectedTab")))) {
                param.put("selectedTab", refreshData.get("selectedTab"));
            }
            if (WfUtils.isNotEmpty((String)((String)refreshData.get("expandItem")))) {
                param.put("expandItem", refreshData.get("expandItem"));
            }
            pageCache.remove(REFRESHDATA);
        }
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SHOW_WFNAVIGATION", param);
    }

    public void itemClick(LinkedHashMap<?, ?> id, String operationKey) {
        if ("deleteCustomFolder".equals(operationKey)) {
            WfUtils.addOpLog((String)"", (String)"delete", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664", "WFNavigationBar_2", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664\u6587\u4ef6\u5939\uff0c\u540d\u79f0\u4e3a\uff1a%s", "WFNavigationBar_1", "bos-wf-formplugin"), (Object[])new Object[]{id.get("name")});
        }
        BeforeItemClickEvent evt = new BeforeItemClickEvent((Object)this, SerializationUtils.toJsonString(id), operationKey);
        this.fireBeforeItemClick(evt);
        if (!evt.isCancel()) {
            ItemClickEvent evt1 = new ItemClickEvent((Object)this, evt.getItemKey(), operationKey);
            this.fireItemClick(evt1);
        }
    }

    private void fireBeforeItemClick(BeforeItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            l.beforeItemClick(e);
        }
    }

    private void fireItemClick(ItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            l.itemClick(e);
        }
    }
}

