/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.rule.ConditionRegister;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

@DataEntityTypeAttribute(name="kd.bos.workflow.component.WfCondition")
public class WfCondition
extends Container
implements ICloseCallBack {
    private Log logger = LogFactory.getLog(WfCondition.class);
    protected final String ENTITYNUMBER = "entityNumber";
    private static final String VALUETYPE = "valueType";
    private static final String VALUEVARIABLE = "value";
    private static final String FIELDNAME = "fieldName";
    private static final String COMPARETYPE = "compareType";
    private static final String LEFTBRACKET = "leftBracket";
    private static final String RIGHTBRACKET = "rightBracket";
    private static final String FILTERCOLUMNS = "filterColumns";
    private static final String CREATEFILTERCOLUMNS = "createFilterColumns";
    private static final String WF_PROCESSDEFINITIONINFO = "wf_processdefinitioninfo";
    private static final String NUMBER = "number";
    private static final String LOGIC = "logic";
    private List<Map<String, Object>> filterColumns;
    private Map<String, Object> params;
    private String ISITEMBILL = "0";
    protected List<ItemClickListener> barItemClickListeners = new ArrayList<ItemClickListener>();

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getEntityNumber() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        return pageCache.get("entityNumber");
    }

    public void setEntityNumber(String entityNumber) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("entityNumber", entityNumber);
    }

    public String getItemBill() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        return pageCache.get(this.ISITEMBILL);
    }

    public void setItemBill(String isItemBill) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(this.ISITEMBILL, isItemBill);
    }

    public void SetValue(List<Map<String, Object>> value) {
        if (!value.isEmpty() && value.size() > 0) {
            for (Map<String, Object> map : value) {
                if (!WfUtils.isNotEmptyString((Object)map.get(VALUETYPE))) continue;
                Object val = map.get(VALUEVARIABLE);
                String valStr = null;
                if (val instanceof String && (valStr = val.toString()).startsWith("[{")) {
                    map.put(map.get(VALUETYPE).toString(), SerializationUtils.fromJsonStringToList((String)valStr, Map.class));
                } else {
                    map.put(map.get(VALUETYPE).toString(), val);
                }
                map.remove(VALUEVARIABLE);
            }
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String mapStr = pageCache.get(VALUEVARIABLE);
        Map valMap = null;
        valMap = WfUtils.isNotEmpty((String)mapStr) ? (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class) : new HashMap();
        valMap.put(this.getKey(), value);
        this.postBack(value);
        pageCache.put(VALUEVARIABLE, SerializationUtils.toJsonString(valMap));
        this.clientViewProxy.invokeControlMethod(this.getKey(), "loadWfConditions", new Object[]{value});
    }

    public List<Map<String, Object>> getValue() {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        Object data = proxy.getViewState(this.getKey());
        if (data != null) {
            List value = (List)data;
            if (value.size() < 1) {
                return new ArrayList<Map<String, Object>>();
            }
            ArrayList<Map<String, Object>> formatValue = new ArrayList<Map<String, Object>>(value.size());
            for (Map item : value) {
                Object valueTypeObj;
                HashMap formatItem = new HashMap();
                formatItem.put("id", item.get("id"));
                formatItem.put(FIELDNAME, item.get(FIELDNAME));
                formatItem.put(COMPARETYPE, item.get(COMPARETYPE));
                formatItem.put(LOGIC, item.get(LOGIC));
                if (item.get(LEFTBRACKET) != null) {
                    formatItem.put(LEFTBRACKET, item.get(LEFTBRACKET));
                }
                if (item.get(RIGHTBRACKET) != null) {
                    formatItem.put(RIGHTBRACKET, item.get(RIGHTBRACKET));
                }
                if (WfUtils.isNotEmptyString(valueTypeObj = item.get(VALUETYPE))) {
                    formatItem.put(VALUETYPE, valueTypeObj);
                    formatItem.put(VALUEVARIABLE, item.get(valueTypeObj.toString()));
                } else {
                    Map itemValue = (Map)item.get(VALUEVARIABLE);
                    if (itemValue != null) {
                        formatItem.put(VALUEVARIABLE, itemValue);
                    }
                }
                formatValue.add(formatItem);
            }
            return formatValue;
        }
        return new ArrayList<Map<String, Object>>();
    }

    public void setFilterColumns(List<Map<String, Object>> filterColumns) {
        this.filterColumns = filterColumns;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(FILTERCOLUMNS, SerializationUtils.toJsonString(filterColumns));
    }

    public List<Map<String, Object>> getFilterColumns() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (pageCache.get(FILTERCOLUMNS) != null) {
            this.filterColumns = SerializationUtils.fromJsonStringToList((String)pageCache.get(FILTERCOLUMNS), Map.class);
        }
        return this.filterColumns;
    }

    private void setFilterMetaData() {
        try {
            if (this.filterColumns == null) {
                throw new Exception(ResManager.loadKDString((String)"\u6761\u4ef6\u9879\u4e3a\u7a7a", (String)"WfCondition_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            this.clientViewProxy.invokeControlMethod(this.getKey(), CREATEFILTERCOLUMNS, new Object[]{this.filterColumns});
            if (this.params != null && this.params.size() > 0) {
                this.clientViewProxy.invokeControlMethod(this.getKey(), "addConditionParams", new Object[]{this.params});
            }
        }
        catch (Exception e) {
            throw new WFException((Throwable)e, WFErrorCode.conditionParseError(), new Object[]{e.getMessage()});
        }
    }

    public void setEntityIdAndFilters(String entityNumber, boolean isItemBill, Integer size) {
        this.setEntityNumber(entityNumber);
        this.setFilterColumns(ConditionRegister.getGeneralConditions(entityNumber, isItemBill, size));
        this.clientViewProxy.invokeControlMethod(this.getKey(), CREATEFILTERCOLUMNS, new Object[]{this.filterColumns});
    }

    public void bindData(BindingContext bctx) {
        try {
            this.setFilterMetaData();
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String valueStr = pageCache.get(VALUEVARIABLE);
            if (WfUtils.isNotEmpty((String)valueStr)) {
                Map value = (Map)SerializationUtils.fromJsonString((String)valueStr, Map.class);
                this.postBack(value.get(this.getKey()));
            }
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        super.bindData(bctx);
    }

    public void f7Click(String entityId, boolean isMulti, int clientType, int rowIndex, Object selecteds, String compareType, String fieldName, String valueNumber) {
        if (fieldName.split("\\.").length > 2) {
            fieldName = fieldName.substring(fieldName.indexOf(46) + 1, fieldName.lastIndexOf(46));
        }
        QFilter filter = null;
        if ("task.entityNumber".equals(fieldName)) {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            RepositoryService service = wfService.getRepositoryService();
            Set entityNumbers = service.getProcessEntityNumbers(true);
            filter = new QFilter(NUMBER, "in", (Object)entityNumbers);
        } else if ("Transfer".equalsIgnoreCase(fieldName) || "circulated".equalsIgnoreCase(fieldName)) {
            String userid = RequestContext.get().getUserId();
            filter = new QFilter("id", "!=", (Object)Long.valueOf(userid));
            filter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            List<QFilter> qFilters = ApprovalPluginUtil.addPersonFiltersCustomEvent(this.getView(), null);
            if (null != qFilters && !qFilters.isEmpty()) {
                for (QFilter qFilter : qFilters) {
                    if (null == qFilter) continue;
                    if (filter == null) {
                        filter = qFilter;
                        continue;
                    }
                    filter.and(qFilter);
                }
            }
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        BasedataProp basedataProp = (BasedataProp)EntityTypeUtil.getDataEntityProperty((String)fieldName, (EntityType)entityType);
        QFilter Orgfilter = PermissionFilterUtil.getOrgFilter((BasedataProp)basedataProp);
        if (filter != null) {
            if (Orgfilter != null) {
                filter.and(Orgfilter);
            }
        } else {
            filter = Orgfilter;
        }
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(this.getKey());
        closeCallBack.setActionId(entityId + "$" + clientType + "$" + rowIndex + "$" + valueNumber);
        Object[] selectedRows = null;
        if (isMulti && selecteds != null && !"".equals(selecteds)) {
            List selectedObject = (List)selecteds;
            selectedRows = new Object[selectedObject.size()];
            int j = 0;
            for (Map i : selectedObject) {
                selectedRows[j] = "task.entityNumber".equals(fieldName) ? (i.get(NUMBER).equals(i.get(VALUEVARIABLE)) ? i.get(VALUEVARIABLE) : i.get(NUMBER)) : i.get(VALUEVARIABLE);
                ++j;
            }
        }
        ListShowParameter para = ShowFormHelper.createShowListForm((String)entityId, (boolean)isMulti);
        para.setHasRight(true);
        para.setCloseCallBack(closeCallBack);
        if (selectedRows != null) {
            para.setSelectedRows(selectedRows);
        }
        para.getListFilterParameter().setFilter(filter);
        if (WF_PROCESSDEFINITIONINFO.equals(entityId)) {
            para.setBillFormId("bos_entityobject");
            para.setFormId("bos_listf7");
            para.setCaption(ResManager.loadKDString((String)"\u6d41\u7a0b\u5355\u636e\u5217\u8868", (String)"WfCondition_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.setItemBill("1");
        } else {
            para.setCustomParam("externalUserType", (Object)"all");
        }
        this.view.showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("ide_listfieldid".equals(e.getActionId())) {
            List rows = (List)e.getReturnData();
            IClientViewProxy actionIds = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            actionIds.setFieldProperty(this.getKey(), "setCompareValue", (Object)String.format("GetValue(%s)", ((Map)rows.get(0)).get(VALUEVARIABLE)));
        } else {
            Object entityRealNumber;
            String preEntityNumber;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            if (rows == null || rows.size() == 0) {
                return;
            }
            String[] actionIds1 = e.getActionId().split("\\$");
            String entityNumber = actionIds1[0];
            boolean isItemBill = false;
            if (WF_PROCESSDEFINITIONINFO.equals(entityNumber)) {
                isItemBill = true;
            }
            int clientType = Integer.parseInt(actionIds1[1]);
            int rowIndex = Integer.parseInt(actionIds1[2]);
            String valueNumber = actionIds1[3];
            BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
            if ("task.entityNumber".equalsIgnoreCase(valueNumber) && WfUtils.isNotEmpty((String)entityNumber) && (!(preEntityNumber = WfUtils.isEmpty((String)this.getEntityNumber()) ? "" : this.getEntityNumber()).equals(entityRealNumber = rows.get(0).getNumber()) || rows.size() > 0)) {
                this.setEntityIdAndFilters((String)entityRealNumber, isItemBill, rows.size());
            }
            ArrayList<Map<String, Object>> basedataValueColl = new ArrayList<Map<String, Object>>();
            if (WF_PROCESSDEFINITIONINFO.equals(entityType.toString())) {
                for (ListSelectedRow row : rows) {
                    HashMap<String, String> basedataValue = new HashMap<String, String>();
                    basedataValue.put(VALUEVARIABLE, String.valueOf(row.getPrimaryKeyValue()));
                    basedataValue.put("alias", row.getName());
                    basedataValue.put(NUMBER, row.getNumber());
                    basedataValueColl.add(basedataValue);
                }
            } else {
                ArrayList<Object> pkValues = new ArrayList<Object>();
                if (rows != null && rows.size() > 0) {
                    for (ListSelectedRow row : rows) {
                        pkValues.add(row.getPrimaryKeyValue());
                    }
                }
                Map mapObjects = this.getView().getModel().loadReferenceDataBatch((DynamicObjectType)entityType, pkValues.toArray(new Object[0]));
                for (DynamicObject entry : mapObjects.values()) {
                    HashMap<String, String> basedataValue = new HashMap<String, String>();
                    basedataValue.put(VALUEVARIABLE, String.valueOf(entityType.getPrimaryKey().getValue((Object)entry)));
                    String alias = "";
                    String entityId = entityType.findProperty(entityType.getNumberProperty()).getValue((Object)entry).toString();
                    alias = entityType.findProperty(entityType.getNameProperty()).getValue((Object)entry).toString();
                    basedataValue.put("alias", alias);
                    basedataValue.put(NUMBER, entityId);
                    basedataValueColl.add(basedataValue);
                }
            }
            HashMap<String, Object> clientMeta = new HashMap<String, Object>();
            clientMeta.put("clientType", clientType);
            clientMeta.put("rowIndex", rowIndex);
            clientMeta.put(VALUEVARIABLE, basedataValueColl);
            clientMeta.put("valueNumber", valueNumber);
            this.clientViewProxy.invokeControlMethod(this.key, "setF7Value", new Object[]{clientMeta});
            this.fireOnConditionChange(rowIndex, valueNumber, basedataValueColl);
        }
    }

    private void fireOnConditionChange(int rowIndex, String valueNumber, List<Map<String, Object>> basedataValueColl) {
        List<Map<String, Object>> value = this.getValue();
        for (Map<String, Object> itemCon : value) {
            if (WfUtils.isNullObject((Object)itemCon.get(VALUETYPE)) || !WfUtils.isNotEmptyString((Object)itemCon.get(VALUETYPE))) continue;
            itemCon.put(itemCon.get(VALUETYPE).toString(), itemCon.remove(VALUEVARIABLE));
        }
        Map<String, Object> map = value.get(rowIndex);
        if (WfUtils.isNotEmptyString((Object)map.get(VALUETYPE))) {
            map.put(map.get(VALUETYPE).toString(), basedataValueColl);
        } else {
            Map valueMap = (Map)map.get(VALUEVARIABLE);
            valueMap.put(valueNumber, basedataValueColl);
        }
        LinkedHashMap<String, List<Map<String, Object>>> data = new LinkedHashMap<String, List<Map<String, Object>>>();
        data.put(VALUEVARIABLE, value);
        this.onConditionChange(data);
    }

    public void deleteAllCondition() {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "deleteAllCondition", new Object[]{1});
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put(VALUEVARIABLE, null);
        this.onConditionChange(data);
    }

    public void addOneConditionItem() {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "addOneCondition", new Object[]{1});
        List<Map<String, Object>> filterColumns = this.getFilterColumns();
        List<Map<String, Object>> condValue = this.getValue();
        if (condValue == null) {
            condValue = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> itemCon : condValue) {
            if (WfUtils.isNullObject((Object)itemCon.get(VALUETYPE)) || !WfUtils.isNotEmptyString((Object)itemCon.get(VALUETYPE))) continue;
            itemCon.put(itemCon.get(VALUETYPE).toString(), itemCon.remove(VALUEVARIABLE));
        }
        if (filterColumns != null && filterColumns.size() > 0) {
            Map<String, Object> column = filterColumns.get(0);
            HashMap<String, Object> valmap = new HashMap<String, Object>();
            valmap.put(FIELDNAME, column.get(FIELDNAME));
            Object compareTypes = column.get("compareTypes");
            if (compareTypes != null) {
                List compareTypeList = (List)compareTypes;
                valmap.put(COMPARETYPE, ((Map)compareTypeList.get(0)).get("id"));
            }
            valmap.put(LEFTBRACKET, this.getAddedItem(LEFTBRACKET, column));
            valmap.put(RIGHTBRACKET, this.getAddedItem(RIGHTBRACKET, column));
            valmap.put(LOGIC, this.getAddedItem(LOGIC, column));
            if (column.get("commVal") != null) {
                valmap.put(VALUETYPE, "commVal");
                valmap.put(VALUEVARIABLE, "");
            } else {
                HashMap<String, String> value = new HashMap<String, String>();
                value.put(column.get(FIELDNAME).toString(), "");
                valmap.put(VALUEVARIABLE, value);
            }
            condValue.add(valmap);
            LinkedHashMap<String, List<Map<String, Object>>> data = new LinkedHashMap<String, List<Map<String, Object>>>();
            data.put(VALUEVARIABLE, condValue);
            this.onConditionChange(data);
        }
    }

    private Object getAddedItem(String key, Map<String, Object> column) {
        Object obj = column.get(key);
        if (obj != null) {
            List compareTypeList = (List)obj;
            return ((Map)compareTypeList.get(0)).get(NUMBER);
        }
        return null;
    }

    public void deleteBillType(LinkedHashMap<?, ?> entityNumber) {
        if (WfUtils.isNotEmpty((String)this.getEntityNumber())) {
            this.setEntityNumber("");
            boolean isItemBill = false;
            isItemBill = "1".equals(this.getItemBill());
            this.setFilterColumns(ConditionRegister.getGeneralConditions(isItemBill));
            this.clientViewProxy.invokeControlMethod(this.getKey(), CREATEFILTERCOLUMNS, new Object[]{this.filterColumns});
        }
    }

    public void addCustomListListener(ItemClickListener listener) {
        this.barItemClickListeners.add(listener);
    }

    public void onConditionChange(LinkedHashMap<?, ?> data) {
        LinkedHashMap<?, ?> map = data;
        List conditionVal = (List)map.get(VALUEVARIABLE);
        this.postBack(conditionVal);
        BeforeItemClickEvent evt = new BeforeItemClickEvent((Object)this, SerializationUtils.toJsonString((Object)conditionVal), "onConditionChange");
        this.fireBeforeItemClick(evt);
        if (!evt.isCancel()) {
            this.fireItemClick((ItemClickEvent)evt);
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "donothing", new Object[0]);
    }

    private void fireBeforeItemClick(BeforeItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            l.beforeItemClick(e);
        }
    }

    private void fireItemClick(ItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            l.itemClick(e);
        }
    }

    public boolean isNumber(String fieldName) {
        if (WfUtils.isEmpty((String)fieldName)) {
            return false;
        }
        List<Map<String, Object>> fieldCoulmns = this.getFilterColumns();
        for (Map<String, Object> coulmn : fieldCoulmns) {
            String itemName = coulmn.get(FIELDNAME).toString();
            if (!fieldName.equals(itemName)) continue;
            int fieldType = (Integer)coulmn.get("fieldType");
            List<Integer> fieldTypeList = this.getFiledTypeList();
            if (!fieldTypeList.contains(fieldType)) break;
            return true;
        }
        return false;
    }

    public List<Integer> getFiledTypeList() {
        ArrayList<Integer> fieldTypeList = new ArrayList<Integer>(8);
        fieldTypeList.add(-6);
        fieldTypeList.add(5);
        fieldTypeList.add(4);
        fieldTypeList.add(-5);
        fieldTypeList.add(8);
        fieldTypeList.add(6);
        fieldTypeList.add(3);
        fieldTypeList.add(2);
        return fieldTypeList;
    }

    public boolean isBoolean(String fieldName) {
        if (WfUtils.isEmpty((String)fieldName)) {
            return false;
        }
        List<Map<String, Object>> columns = this.getFilterColumns();
        for (Map<String, Object> column : columns) {
            String itemName = column.get(FIELDNAME).toString();
            if (!fieldName.equals(itemName) || !"3".equals(column.get("compareGroupID"))) continue;
            return true;
        }
        return false;
    }
}

