/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.component;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.workflow.bizflow.graph.handler.BillRelationCardHandlerFactory;
import kd.bos.workflow.bizflow.graph.handler.IBillRelationCardHandler;
import kd.bos.workflow.component.WorkflowDesigner;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowBillRelationGraph
extends WorkflowDesigner {
    private static final String EVENT_SHOWBILL = "showBill";
    private static final String EVENT_SHOWSTACKEDBILLS = "showStackedBills";
    private static final String EVENT_SELECTCARD = "selectCard";
    private static final String EVENT_DESELECTCARD = "deselectCard";
    private static final String EVENT_AFTERSHOWICONTIP = "afterShowIconTip";

    public WorkflowBillRelationGraph(String key, IFormView view) {
        this.setKey(key);
        this.setView(view);
    }

    @Override
    public void handleEvent(String formId, String type, Map<String, Object> params) {
        switch (type) {
            case "showBill": 
            case "showStackedBills": {
                this.clickHyperLink(params);
                break;
            }
            case "selectCard": {
                this.selectCard(params);
                break;
            }
            case "deselectCard": {
                this.deselectCard(params);
                break;
            }
            case "afterShowIconTip": {
                this.afterShowIconTip(params);
                break;
            }
            default: {
                super.handleEvent(formId, type, params);
            }
        }
    }

    private void clickHyperLink(Map<String, Object> params) {
        try {
            IBillRelationCardHandler handler = this.getCardHandler(params);
            handler.clickHyperLink(this.getView(), params);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WorkflowBillRelationGraph_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void selectCard(Map<String, Object> params) {
        Boolean lock = (Boolean)params.get("lock");
        if (Boolean.TRUE.equals(lock)) {
            return;
        }
        IBillRelationCardHandler handler = this.getCardHandler(params);
        handler.selectCard(this.getView(), params);
    }

    private void deselectCard(Map<String, Object> params) {
        IBillRelationCardHandler handler = this.getCardHandler(params);
        handler.deselectCard(this.getView(), params);
    }

    private IBillRelationCardHandler getCardHandler(Map<String, Object> params) {
        String tenantId = (String)params.get("tenantId");
        String accountId = (String)params.get("accountId");
        String entityNumber = (String)params.get("entityNumber");
        boolean stacked = "true".equals(String.valueOf(params.get("isStacked")));
        return BillRelationCardHandlerFactory.getBillRelationCardHandler((boolean)stacked, (String)tenantId, (String)accountId, (String)entityNumber);
    }

    private void afterShowIconTip(Map<String, Object> params) {
        try {
            String entityNumber = (String)params.get("entityNumber");
            String businessKey = (String)params.get("businessKey");
            String plugin = (String)params.get("plugin");
            if (!ExternalInterfaceUtil.isValidValue((String)plugin)) {
                return;
            }
            Object result = ExternalInterfaceUtil.executeExtItf((ExtItfCallerType)ExtItfCallerType.GETPUSHSTATUS, (String)plugin, (Object[])new Object[]{entityNumber, businessKey});
            if (result instanceof Object[]) {
                Object[] infos = (Object[])result;
                String info = this.getStringInfo(infos, 0);
                if (info != null) {
                    params.put("first", info);
                }
                if ((info = this.getStringInfo(infos, 1)) != null) {
                    params.put("second", info);
                }
                if ((info = this.getStringInfo(infos, 2)) != null) {
                    params.put("third", info);
                }
                this.renderTooltipData(params);
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private String getStringInfo(Object[] infos, int index) {
        Object info;
        int length = infos.length;
        if (length > index && (info = infos[index]) instanceof String) {
            return (String)info;
        }
        return null;
    }
}

