/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.component;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.manager.IConditionEvent;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.model.AuditPointModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.component.WorkflowBillRelationGraph;
import kd.bos.workflow.component.YzjChat;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.IWorkflowDesigner;
import kd.bos.workflow.design.plugin.ViewFlowChartPermComponent;
import kd.bos.workflow.design.plugin.model.Directive;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WFEngineVersion;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.ApprovalRecordHtmlAdapter;
import kd.bos.workflow.engine.impl.util.BillSummaryType;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;
import kd.sdk.annotation.SdkPublic;

@DataEntityTypeAttribute(name="kd.bos.workflow.component.WorkflowDesigner")
@SdkPublic
public class WorkflowDesigner
extends TipsSupport {
    private final String INITCLASS = "initClass";
    private static final String WORKFLOWMODEL = "WorkflowModel";
    private static final String SHOWCOORDINATEINFO = "showCoordinateInfo";
    protected List<PropertyListener> listeners = new ArrayList<PropertyListener>();
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private GraphModel graphModel;
    private Map<String, Object> content;

    public WorkflowDesigner() {
        if (this.isWorkflowDesigner()) {
            ControlTypes.register(((Object)((Object)this)).getClass());
        }
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
    }

    public void initGraphModel(String modelType, String modelJson) {
        this.setGraphModel(new GraphModel(modelType, modelJson));
    }

    public void addPropertyButtonClickListener(PropertyListener listener) {
        this.listeners.add(listener);
    }

    private boolean isWorkflowDesigner() {
        return WorkflowDesigner.class.equals(((Object)((Object)this)).getClass());
    }

    private WorkflowDesigner getComponent(String formId) {
        if (!this.isWorkflowDesigner()) {
            return null;
        }
        if ("bpm_billrelation_graph".equals(formId)) {
            return new WorkflowBillRelationGraph(this.getKey(), this.getView());
        }
        return null;
    }

    public void postBack(Object value) {
        this.content = (Map)value;
    }

    public void click(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        PropertyEvent e = new PropertyEvent((Object)this, itemId, metaType, propertyName, param);
        this.fireClick(e);
    }

    private void fireClick(PropertyEvent e) {
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                l.click(e);
            }
        }
    }

    public void notify(String type, Map<String, Object> param, IFormView currentView) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
        params.add(param);
        this.notify(type, params, currentView);
    }

    public void notify(String type, List<Map<String, Object>> params, IFormView currentView) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), type, new Object[]{params});
        if (currentView != null && !currentView.equals(this.getView())) {
            currentView.sendFormAction(this.getView());
        }
    }

    public void change(String formId, String type, String itemId, Map<String, Object> param) {
        try {
            this.getDesigner(formId, null).change(type, itemId, param);
        }
        catch (Exception e) {
            this.log.error(String.format("\u5207\u6362\u8282\u70b9\u51fa\u9519\uff01 %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u5207\u6362\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesigner_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public void printModelJson(String formId, String itemId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("json", this.getDesigner(formId, null).getModelJson(itemId));
            this.notify("print", params, this.getView());
        }
        catch (Exception e) {
            this.log.error(String.format("\u83b7\u53d6%s\u8282\u70b9JSON\u51fa\u9519\uff01 %s", itemId, WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    public void removeCells(String formId, Map<String, Object> param) {
        try {
            String cellsJson = (String)param.get("cells");
            List cells = SerializationUtils.fromJsonStringToList((String)cellsJson, GraphCell.class);
            this.getDesigner(formId, null).beforeRemoveCells(cells);
            this.graphModel.removeCells(cells);
            this.getDesigner(formId, null).afterRemoveCells(cells);
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            throw new WFException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesigner_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public void afterDeleteCells(String formId, Map<String, Object> param) {
        String cellsJson = (String)param.get("cells");
        String selectedCellsJson = (String)param.get("selectedCells");
        List cells = SerializationUtils.fromJsonStringToList((String)cellsJson, GraphCell.class);
        List selectedCells = SerializationUtils.fromJsonStringToList((String)selectedCellsJson, GraphCell.class);
        this.getDesigner(formId, null).afterDeleteCells(cells, selectedCells);
    }

    public void cellsInserted(String formId, Map<String, Object> param) {
        try {
            String cellJson = (String)param.get("cell");
            if (cellJson != null) {
                GraphCell cell = (GraphCell)SerializationUtils.fromJsonString((String)cellJson, GraphCell.class);
                this.graphModel.addCell(cell);
                this.getDesigner(formId, null).afterInsertCells(cell);
            } else {
                String edgeJson = (String)param.get("edge");
                GraphCell edge = (GraphCell)SerializationUtils.fromJsonString((String)edgeJson, GraphCell.class);
                String sourceId = (String)param.get("sourceId");
                String targetJson = (String)param.get("target");
                GraphCell target = (GraphCell)SerializationUtils.fromJsonString((String)targetJson, GraphCell.class);
                String type = this.graphModel.connectAddCell(edge, sourceId, target);
                this.getDesigner(formId, null).afterInsertCells(edge, sourceId, target, type);
            }
        }
        catch (Exception e) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u65b0\u589e\u8282\u70b9\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesigner_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public void connect(String formId, Map<String, Object> param) {
        try {
            String edgeJson = (String)param.get("edge");
            String sourceId = (String)param.get("sourceId");
            String targetId = (String)param.get("targetId");
            GraphCell edge = (GraphCell)SerializationUtils.fromJsonString((String)edgeJson, GraphCell.class);
            this.graphModel.connect(edge, sourceId, targetId);
            this.getDesigner(formId, null).connect(edge, sourceId, targetId);
        }
        catch (Exception e) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u8fde\u63a5\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesigner_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public void splitEdge(String formId, Map<String, Object> param) {
        try {
            String edgeJson = (String)param.get("edge");
            String newEdgeJson = (String)param.get("newEdge");
            GraphCell edge = (GraphCell)SerializationUtils.fromJsonString((String)edgeJson, GraphCell.class);
            GraphCell newEdge = (GraphCell)SerializationUtils.fromJsonString((String)newEdgeJson, GraphCell.class);
            this.graphModel.splitEdge(edge, newEdge);
            this.getDesigner(formId, null).afterSplitEdge(edge, newEdge);
        }
        catch (Exception e) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u8fde\u63a5\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesigner_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public void updateProperty(Directive directive) {
        ArrayList<Directive> directives = new ArrayList<Directive>();
        directives.add(directive);
        this.updateProperties(directives);
    }

    public void updateProperties(List<Directive> directives) {
        IFormView view = null;
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(directives.size());
        for (Directive directive : directives) {
            view = directive.getCurrentView();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("itemId", directive.getItemId());
            param.put("group", directive.getGroup());
            param.put("property", directive.getProperty());
            param.put("value", directive.getValue());
            params.add(param);
        }
        this.notify("updateProperty", params, view);
    }

    public void addNodeToDiagram(String baseType, String type, String template, String text, String style, boolean isContainer) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("baseType", baseType);
        param.put("type", type);
        param.put("template", template);
        param.put("value", text);
        param.put("style", style);
        param.put("containable", isContainer);
        this.notify("addNodeToDiagram", param, null);
    }

    public void shrinkConfigurePanel(IFormView view) {
        this.notify("shrinkConfigurePanel", new HashMap<String, Object>(), view);
    }

    public void exportImage(IFormView view, String fileName) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("fileName", fileName);
        this.notify("exportImage", param, view);
    }

    public void changeStyle(String itemId, IFormView view, String newStyle) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("itemId", itemId);
            params.put("newStyle", newStyle);
            this.notify("changeStyle", params, view);
        }
        catch (Exception e) {
            this.log.error(String.format("\u83b7\u53d6%s\u8282\u70b9JSON\u51fa\u9519\uff01 %s", itemId, WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    public void selectProcess(IFormView view) {
        this.notify("selectProcess", new HashMap<String, Object>(), view);
    }

    public void selectNode(IFormView view, String itemId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("cellId", itemId);
        this.notify("selectNode", param, view);
    }

    public void pasteUICells(IFormView view) {
        this.notify("paste", new HashMap<String, Object>(), view);
    }

    public void beforePasteCells(String formId, Map<String, Object> param) {
        try {
            String cellsJson = (String)param.get("cells");
            List cells = SerializationUtils.fromJsonStringToList((String)cellsJson, GraphCell.class);
            this.getDesigner(formId, null).beforePasteCells(cells);
        }
        catch (Exception e) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesigner_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public void afterPasteCells(String formId, Map<String, Object> param) {
        try {
            String cellsJson = (String)param.get("cells");
            List cells = SerializationUtils.fromJsonStringToList((String)cellsJson, GraphCell.class);
            this.getDesigner(formId, null).afterPasteCells(cells);
        }
        catch (Exception e) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesigner_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public void parentChanged(String formId, Map<String, Object> param) {
        try {
            String parentId = (String)param.get("parentId");
            Map changed = (Map)param.get("changed");
            this.graphModel.parentChanged(parentId, changed);
            this.getDesigner(formId, null).afterParentChanged(parentId, changed);
        }
        catch (Exception e) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u79fb\u52a8\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesigner_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public void handleEvent(String formId, String type, Map<String, Object> param) {
        WorkflowDesigner component = this.getComponent(formId);
        if (component != null) {
            component.handleEvent(formId, type, param);
            return;
        }
        if ("expandedConfigurePanel".equals(type)) {
            try {
                this.getDesigner(formId, null).expandedConfigurePanel(param);
            }
            catch (Exception e) {
                this.log.error(String.format("\u5c55\u5f00%s\u8282\u70b9\u5c5e\u6027\u9762\u677f\u51fa\u9519\uff01 %s", type, WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        } else {
            this.getDesigner(formId, null).handleCustomEvent(type, param);
        }
    }

    public void open(String modelType, Map<String, Object> doc) {
        boolean isPC = !modelType.startsWith("Mob");
        Object val = doc.get("isPC");
        if (val instanceof Boolean) {
            isPC = (Boolean)val;
        }
        doc.put("version", WFEngineVersion.getVersion());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "open", new Object[]{modelType, isPC, doc});
    }

    public void afterLoadData(String formId, Map<String, Object> params) {
        this.getDesigner(formId, null).afterLoadInitData(params);
    }

    public void loadData(String formId, Map<String, Object> params) {
        Map<String, Object> result = null;
        try {
            result = this.getInitData(formId, params);
        }
        catch (Exception e) {
            this.log.error("load initData failed! " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (result == null) {
            return;
        }
        this.open(WORKFLOWMODEL, result);
    }

    private Map<String, Object> getInitData(String formId, Map<String, Object> params) {
        IWorkflowDesigner designer = this.getDesigner(formId, params.get("initClass") != null ? params.get("initClass").toString() : null);
        if (designer == null) {
            return null;
        }
        try {
            return designer.getDesignerInitData(params);
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6570\u636e\u83b7\u53d6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesigner_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            return null;
        }
    }

    private IWorkflowDesigner getDesigner(String formId, String className) {
        IFormView view = this.getView();
        FormViewPluginProxy proxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        if (WfUtils.isNotEmpty((String)className)) {
            return (IWorkflowDesigner)proxy.getPlugin(className);
        }
        List plugins = proxy.getPlugIns();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof IWorkflowDesigner)) continue;
            return (IWorkflowDesigner)plugin;
        }
        throw new WFException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u7684IWorkflowDesigner\u5b9e\u73b0\u7c7b\u3002\u8868\u5355ID\uff1a%1$s\uff0c\u7c7b\u540d\uff1a%2$s\u3002", (String)"WorkflowDesigner_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), formId, className));
    }

    public void loadSubProcessData(String formId, Map<String, Object> params) {
        Map<String, Object> result = this.getInitData(formId, params);
        if (result == null) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "loadSubProcessData", new Object[]{result});
    }

    public Map<String, Object> createClientConfig() {
        return super.createClientConfig();
    }

    protected boolean isNotOverride(Class<?> clazz, String methodName, IConditionEvent conditionEvent, Class<?> ... parameterTypes) {
        return super.isNotOverride(clazz, methodName, conditionEvent, (Class[])parameterTypes);
    }

    public void loadApprovalRecords(String cellId, String procInstId, String billId, boolean historic) {
        ViewFlowChartPermComponent viewFlowChartPermComponent;
        boolean hasPerm;
        this.injectArchiveRouteInfo();
        WorkflowService workflowService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RepositoryService repositoryService = workflowService.getRepositoryService();
        Long processInstanceId = null;
        if (WfUtils.isNotEmpty((String)procInstId)) {
            processInstanceId = Long.valueOf(procInstId);
        } else if (WfUtils.isNotEmpty((String)billId)) {
            processInstanceId = workflowService.getRuntimeService().getProcInstIdByBusKey(billId);
        }
        BpmnModel bpmnModel = null;
        try {
            bpmnModel = repositoryService.getBpmnModel(null, processInstanceId);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (bpmnModel == null) {
            this.log.debug(String.format("BpmnModel is null, ProcessInstance may have been deleted! ProcessInstanceId: %s", processInstanceId));
            return;
        }
        FlowElement cell = bpmnModel.getMainProcess().getFlowElement(cellId);
        if (cell instanceof CallActivity && !(hasPerm = (viewFlowChartPermComponent = new ViewFlowChartPermComponent(this.getView())).cellHasPerm(cellId, Long.valueOf(procInstId)))) {
            return;
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("key", String.format("%s-%s", cellId, !historic ? "latestRecords" : "historyRecords"));
        List records = ApprovalRecordHtmlAdapter.approvalHistoryRecordsHtmlAdapter((List)repositoryService.getApprovalHistoryRecords(processInstanceId, cellId, historic));
        SignatureUtils.handleApprovalHisRecordSignatureUrl((List)records);
        retMap.put("datas", records);
        FlowElement flowElement = bpmnModel.getFlowElement(cellId);
        if (flowElement != null && !"CallActivity".equals(flowElement.getType())) {
            if (!historic && records != null && records.isEmpty()) {
                boolean showCoordinate = this.isShowCoordiante(cellId, processInstanceId);
                retMap.put("showCoordinate", showCoordinate);
            }
            this.setAutoCoordinateInfo(records, retMap);
        }
        if (!historic && flowElement instanceof AuditTask) {
            ILocaleString auditPointTitle = null;
            AuditPointModel auditPointModel = ((AuditTask)flowElement).getAuditPointModel();
            if (auditPointModel != null) {
                String multiKey = String.format("%s.auditPointModel.auditPointTitle", cellId);
                auditPointTitle = BpmnModelUtil.getMultiLangFieldValue((Long)processInstanceId, (String)multiKey, (String)auditPointModel.getAuditPointTitle());
            }
            if (auditPointTitle != null) {
                retMap.put("datas-auditPointsTitle", auditPointTitle.getLocaleValue());
            } else {
                retMap.put("datas-auditPointsTitle", ResManager.loadKDString((String)"\u5ba1\u6279\u8981\u70b9", (String)"ApprovalPagePluginNew_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            List pointRecords = repositoryService.getAuditPointHistoryRecords(processInstanceId, cellId);
            retMap.put("datas-auditPoints", pointRecords);
        }
        retMap.put("coordinateName", WfConfigurationUtil.getCoordinateName());
        retMap.put("transferName", WfConfigurationUtil.getTransferName());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "loadApprovalRecords", new Object[]{retMap});
    }

    public void showChildProcessInfo(String procInstId, String formId) {
        Map<String, Object> data = null;
        try {
            ViewFlowChartPermComponent permComponent = new ViewFlowChartPermComponent().setView(this.getView());
            Long processInstanceId = Long.valueOf(procInstId);
            boolean instanceHasPerm = permComponent.processInstanceHasPerm(processInstanceId);
            if (!instanceHasPerm) {
                String tips = ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u5bf9\u5e94\u6d41\u7a0b\u56fe\u7684\u6743\u9650", (String)"WorkflowViewFlowchartPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                return;
            }
            this.injectArchiveRouteInfo();
            HashMap<String, Object> params = new HashMap<String, Object>();
            data = this.getFlowchartInitData(processInstanceId);
            if (data == null || data.isEmpty()) {
                this.getView().showTipNotification(WFMultiLangConstants.getProcessNodeNoInfo());
                return;
            }
            this.getDesigner(formId, null).updateProcInstId(procInstId, params);
            this.open(WORKFLOWMODEL, data);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(WFMultiLangConstants.getProcessNodeNoInfo(), e.getMessage()));
            this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public void backToParentProcess(String procInstId, String formId) {
        ViewFlowChartPermComponent viewFlowChartPermComponent = new ViewFlowChartPermComponent(this.getView());
        if (!viewFlowChartPermComponent.processInstanceHasPerm(Long.valueOf(procInstId))) {
            String tips = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7236\u6d41\u7a0b\u201d\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\u3002", (String)"WorkflowViewFlowchartPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        Map<String, Object> data = null;
        try {
            this.injectArchiveRouteInfo();
            HashMap<String, Object> params = new HashMap<String, Object>();
            this.getDesigner(formId, null).updateProcInstId(procInstId, params);
            data = this.getFlowchartInitData(Long.valueOf(procInstId));
            if (data == null || data.isEmpty()) {
                this.getView().showTipNotification(WFMultiLangConstants.getProcessNodeNoInfo());
                return;
            }
            this.open(WORKFLOWMODEL, data);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(WFMultiLangConstants.getViewFlowChartErrorInfo(), e.getMessage()));
            this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void setAutoCoordinateInfo(List<ApprovalHistoryRecord> records, Map<String, Object> retMap) {
        if (records != null && !records.isEmpty()) {
            String groupId = records.get(0).getGroupId();
            if (WfUtils.isEmpty((String)groupId)) {
                for (ApprovalHistoryRecord record : records) {
                    if (!WfUtils.isNotEmpty((String)record.getTaskId()) || "0".equals(record.getTaskId())) continue;
                    groupId = record.getTaskId();
                    break;
                }
            }
            boolean isCanShowAutoCoordinate = WfUtils.isEmpty((String)groupId) || "0".equals(groupId) ? Boolean.FALSE : CoordinateRecordUtil.isCanShowAutoCoordinateRecored((String)groupId);
            retMap.put("showAutoCoordinate", isCanShowAutoCoordinate);
            if (isCanShowAutoCoordinate) {
                retMap.put("autoCoordinateGroupId", groupId);
            }
        }
    }

    public void showAutoCoordinateInfo(String groupId) {
        this.injectArchiveRouteInfo();
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List records = wfService.getTaskService().getAutoCoordinateRecordCmd(Long.valueOf(groupId));
        this.coordinateInfoTagTransform(records);
        SignatureUtils.handleApprovalRecordSignatureUrl((List)records);
        HashMap<String, List> ret = new HashMap<String, List>();
        ret.put("autoCoordinate_" + groupId, records);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), SHOWCOORDINATEINFO, new Object[]{ret});
    }

    private boolean isShowCoordiante(String cellId, Long processInstanceId) {
        boolean showCoodinate = false;
        QFilter q1 = new QFilter("processinstanceid", "=", (Object)processInstanceId);
        QFilter q2 = new QFilter("taskdefinitionkey", "=", (Object)cellId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_hitaskinst", (String)"id,endtime", (QFilter[])new QFilter[]{q1, q2});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long taskId;
                boolean isShowCoordinate;
                if (dynamicObject.get("endtime") != null || !(isShowCoordinate = CoordinateRecordUtil.isShowCoordinate((Long)(taskId = Long.valueOf(dynamicObject.getLong("id"))), (Long)userId))) continue;
                showCoodinate = isShowCoordinate;
                break;
            }
        }
        return showCoodinate;
    }

    public void showCoordinateInfoByProcInstIsd(String procInstId, String cellId) {
        this.injectArchiveRouteInfo();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        QFilter q1 = new QFilter("processinstanceid", "=", (Object)procInstId);
        QFilter q2 = new QFilter("taskdefinitionkey", "=", (Object)cellId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_hitaskinst", (String)"id,endtime", (QFilter[])new QFilter[]{q1, q2});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (dynamicObject.get("endtime") != null) continue;
                Long taskId = dynamicObject.getLong("id");
                taskIds.add(taskId);
            }
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List records = wfService.getTaskService().getCoordinatorRecordByTaskIdsCmd(taskIds);
        this.coordinateInfoTagTransform(records);
        HashMap<String, List> ret = new HashMap<String, List>();
        ret.put("coordinate_" + procInstId + "_" + cellId, records);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), SHOWCOORDINATEINFO, new Object[]{ret});
    }

    public void showCoordinateInfo(String taskId, String userId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"taskID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WorkflowDesigner_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7528\u6237\u7684userID\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WorkflowDesigner_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.injectArchiveRouteInfo();
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List records = wfService.getTaskService().getCoordinatorRecordCmd(Long.valueOf(taskId));
        this.coordinateInfoTagTransform(records);
        SignatureUtils.handleApprovalRecordSignatureUrl((List)records);
        HashMap<String, List> ret = new HashMap<String, List>();
        ret.put("coordinate_" + taskId + "_" + userId, records);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), SHOWCOORDINATEINFO, new Object[]{ret});
    }

    public void showTransferRecord(String taskId, String userId, boolean coordinate) {
        ApprovalPluginUtil.showTransferRecord(this.getView(), taskId, userId, coordinate);
    }

    public void cleanRecordsState() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "cleanRecordsState", new Object[0]);
    }

    public void renderTooltipData(Map<String, Object> param) {
        this.notify("renderTooltipData", param, null);
    }

    public void openYzjChat(List<String> openIds, String groupName) {
        String currentOpenId = RequestContext.get().getUserOpenId();
        openIds.remove(currentOpenId);
        if (!openIds.isEmpty()) {
            YzjChat chat = new YzjChat();
            chat.setView(this.getView());
            LinkedHashMap<String, String> param = new LinkedHashMap<String, String>(1);
            param.put("clickScene", "chat");
            chat.openChat(openIds.toArray(new String[openIds.size()]), groupName, param);
        }
    }

    public void clickCustomizeLink(Map<String, String> params) {
        DesignerPluginUtil.showCustomizedForm(this.getView(), params);
    }

    public void showFormByTips(String params, String elementId, String triggerType) {
        if (WfUtils.isEmpty((String)params)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63a7\u4ef6\u201c%s\u201d\u663e\u793atips\u5c5e\u6027params\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowDesigner_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), this.getKey()));
            return;
        }
        BeforeShowTipsEvent event = new BeforeShowTipsEvent((Object)this);
        FormShowParameter formShowParameter = event.getFormshowParameter();
        if (formShowParameter == null) {
            formShowParameter = new FormShowParameter();
        }
        HashMap<String, String> custParam = new HashMap<String, String>();
        custParam.put("elementId", elementId);
        JSONObject map = (JSONObject)JSONObject.parse((String)params);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("cellId", map.getString("cellId"));
        param.put("pageId", map.getString("pageId"));
        formShowParameter.setCustomParams(param);
        String type = map.getString("type");
        if ("billSummary".equals(type)) {
            this.showBillSummaryPage(formShowParameter, custParam, map);
        } else if ("floatLayer".equals(type)) {
            this.showFloatLayerPage(formShowParameter, custParam, map);
        }
    }

    private void showBillSummaryPage(FormShowParameter formShowParameter, HashMap<String, String> custParam, JSONObject map) {
        OpenStyle style = new OpenStyle();
        StyleCss cssStyle = new StyleCss();
        cssStyle.setHeight(map.getString("height"));
        style.setInlineStyleCss(cssStyle);
        style.setShowType(ShowType.ToolTips);
        formShowParameter.setOpenStyle(style);
        formShowParameter.getOpenStyle().setCustParam(custParam);
        formShowParameter.getOpenStyle().setTargetKey(this.getKey());
        this.initBillSummaryInfo(map, formShowParameter);
    }

    private void initBillSummaryInfo(JSONObject map, FormShowParameter formShowParameter) {
        FlowElement flowElement;
        Long historicActivityInstanceId = map.getLong("historicActivityInstanceId");
        Long procInstId = map.getLong("procInstId");
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        HistoricActivityInstanceEntity hiActInst = wfService.getHistoryService().getHistoricActivityByProcessInstanceIdAndActivityInstId(procInstId, historicActivityInstanceId);
        Long procdefId = hiActInst.getProcessDefinitionId();
        String cellId = hiActInst.getActivityId();
        String entityNumber = hiActInst.getEntityNumber();
        String businessKey = hiActInst.getBusinessKey();
        BpmnModel bpmnModel = wfService.getRepositoryService().getBpmnModel(procdefId, procInstId);
        String bizFlowBillSumary = ViewFlowchartUtil.getBizFlowBillSummary((BpmnModel)bpmnModel, (FlowElement)(flowElement = bpmnModel.getFlowElement(cellId)), (String)entityNumber);
        if (WfUtils.isEmpty((String)bizFlowBillSumary)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u914d\u7f6e\u8282\u70b9\u4e0a\u7684\u201c\u4e1a\u52a1\u6d41\u4fa7\u8fb9\u680f\u5355\u636e\u6458\u8981\u201d\u3002", (String)"WorkflowDesigner_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter billTypeFilter = new QFilter("billtype", "=", (Object)entityNumber);
        QFilter enableFilter = new QFilter("number", "=", (Object)bizFlowBillSumary);
        QFilter sceneFilter = new QFilter("scene", "=", (Object)BillSummaryType.flowchartSummary.name());
        DynamicObject billSummaryInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_mbillsummary_cfg", (QFilter[])new QFilter[]{billTypeFilter, enableFilter, sceneFilter});
        if (billSummaryInfo == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u4e0a\u7684\u4e1a\u52a1\u6d41\u4fa7\u8fb9\u680f\u5355\u636e\u6458\u8981(%s)\u4e0d\u5b58\u5728\u6216\u4f7f\u7528\u573a\u666f\u4e0d\u5339\u914d\uff0c\u8bf7\u81ea\u884c\u68c0\u67e5\u3002", (String)"WorkflowDesigner_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), bizFlowBillSumary));
            return;
        }
        formShowParameter.setCustomParam("bizFlowBillSummary", (Object)bizFlowBillSumary);
        formShowParameter.setCustomParam("businessKey", (Object)businessKey);
        formShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formShowParameter.setFormId(billSummaryInfo.getString("summarytplnum"));
        this.getView().showForm(formShowParameter);
    }

    private void showFloatLayerPage(FormShowParameter formShowParameter, HashMap<String, String> custParam, JSONObject map) {
        String cellId = map.getString("cellId");
        String procInstId = map.getString("procInstId");
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        BpmnModel bpmnModel = wfService.getRepositoryService().getBpmnModel(null, Long.valueOf(procInstId));
        FlowElement flowElement = bpmnModel.getFlowElement(cellId);
        String floatLayerBillSummary = null;
        if (flowElement instanceof UserTask) {
            floatLayerBillSummary = ((UserTask)flowElement).getFloatLayerBillSummary();
        } else if (flowElement instanceof CallActivity) {
            floatLayerBillSummary = ((CallActivity)flowElement).getFloatLayerBillSummary();
        }
        if (WfUtils.isEmpty((String)floatLayerBillSummary)) {
            return;
        }
        List historicActivityInstanceEntities = wfService.getHistoryService().getHistoricActivityByProcessInstanceIdAndActivityId(Long.valueOf(procInstId), cellId);
        if (CollectionUtil.isNotEmpty((Collection)historicActivityInstanceEntities)) {
            List filterEntityNumbers = ViewFlowchartUtil.getFilterEntityNumbers((Long)Long.valueOf(procInstId), (String)cellId);
            boolean needShowFlowFloatLayer = false;
            for (HistoricActivityInstanceEntity historicActivityInstanceEntity : historicActivityInstanceEntities) {
                if (!filterEntityNumbers.contains(historicActivityInstanceEntity.getEntityNumber()) || !WfUtils.exist((String)historicActivityInstanceEntity.getEntityNumber(), (Object)historicActivityInstanceEntity.getBusinessKey())) continue;
                needShowFlowFloatLayer = true;
                break;
            }
            if (needShowFlowFloatLayer) {
                OpenStyle style = new OpenStyle();
                style.setShowType(ShowType.ToolTips);
                formShowParameter.getCustomParams().put("procInstId", procInstId);
                formShowParameter.setOpenStyle(style);
                formShowParameter.getOpenStyle().setCustParam(custParam);
                formShowParameter.getOpenStyle().setTargetKey(this.getKey());
                formShowParameter.setFormId("bpm_floatlayertpl_default");
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void showBillSummaryInfo(Map<String, Object> data) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "showBillSummaryInfo", new Object[]{data});
    }

    private Map<String, Object> getFlowchartInitData(Long procInstId) {
        HistoricProcessInstanceEntity hisProInst;
        RepositoryService repositoryService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
        Map data = repositoryService.getFlowchartInitDataByProcInstId(hisProInst = (HistoricProcessInstanceEntity)repositoryService.findEntityById(procInstId, "wf_hiprocinst"));
        if (data == null || data.isEmpty()) {
            return data;
        }
        Long superProcInstId = hisProInst.getSuperProcessInstanceId();
        if (WfUtils.isEmpty((Long)superProcInstId)) {
            superProcInstId = null;
        }
        data.put("updateProcInstId", Boolean.TRUE);
        data.put("superProcInstId", WfUtils.isEmpty((Long)superProcInstId) ? null : String.valueOf(superProcInstId));
        data.put("procInstId", WfUtils.isEmpty((Long)procInstId) ? null : String.valueOf(procInstId));
        return data;
    }

    private void injectArchiveRouteInfo() {
        ArchiveFormService.create().injectArchiveRouteInfo(this.view);
    }

    private void coordinateInfoTagTransform(List<IApprovalRecordItem> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        for (IApprovalRecordItem record : records) {
            if (!(record instanceof ApprovalRecordItem)) continue;
            ApprovalRecordItem recordItem = (ApprovalRecordItem)record;
            if (StringUtils.isNotBlank((CharSequence)recordItem.getMessage())) {
                recordItem.setMessage(ApprovalRecordHtmlAdapter.adaptHtml((String)recordItem.getMessage()));
            }
            if (!StringUtils.isNotBlank((CharSequence)recordItem.getCoordInviteOpinion())) continue;
            recordItem.setCoordInviteOpinion(ApprovalRecordHtmlAdapter.adaptHtml((String)recordItem.getCoordInviteOpinion()));
        }
    }
}

