/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IPageCache;
import kd.bos.form.TipsSupport;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.util.PictureResourceEnum;

@DataEntityTypeAttribute(name="kd.bos.workflow.component.YzjChat")
public class YzjChat
extends TipsSupport {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String PCCHATTYPE = "chat_pc";
    private static final String PHONECHATTYPE = "chat";
    private static final String SHAREPARAMS = "shareParams";
    private static final String SCENE = "scene";
    private static final String OPENID = "openId";
    private static final String USERNAME = "userName";
    public static final String CLICKSCENE = "clickScene";
    public static final String CLICKSCENE_YZJ = "yzj";
    public static final String CLICKSCENE_MORECHAT = "moreChat";
    public static final String CLICKSCENE_CHAT = "chat";
    private Map<String, Object> parameters;
    private Map<String, Object> shareParams;

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getShareParams() {
        return this.shareParams;
    }

    public void setShareParams(Map<String, Object> shareParams) {
        this.shareParams = shareParams;
    }

    public void setYzjParameter(String billId, String featureCode, String scene) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("billId", billId);
        pageCache.put("featureCode", featureCode);
        pageCache.put(SCENE, scene);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("isPC", (String)parameters.get("isPC"));
    }

    @Deprecated
    public String openChat(String[] openIds, String groupName) {
        boolean isGroupChat = StringUtils.isEmpty((String)groupName);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String isPC = pageCache.get("isPC");
        if (isPC != null && "false".equalsIgnoreCase(isPC)) {
            this.openPhoneChat(openIds, isGroupChat, null);
            return null;
        }
        if (openIds.length == 1) {
            this.yzjInterfaceOpenChat(openIds, PCCHATTYPE);
        } else {
            this.yzjInterfaceWithRerurn(openIds, PCCHATTYPE, null);
        }
        return null;
    }

    public String openChat(String[] openIds, String groupName, LinkedHashMap param) {
        boolean isGroupChat = StringUtils.isEmpty((String)groupName);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String isPC = pageCache.get("isPC");
        if (isPC != null && "false".equalsIgnoreCase(isPC)) {
            this.openPhoneChat(openIds, isGroupChat, param);
        } else if (openIds.length == 1) {
            this.yzjInterfaceOpenChat(openIds, PCCHATTYPE);
        } else {
            this.yzjInterfaceWithRerurn(openIds, PCCHATTYPE, param);
        }
        return null;
    }

    private void openPhoneChat(String[] openIds, boolean isGroupChat, LinkedHashMap param) {
        if (openIds == null || openIds.length < 1) {
            return;
        }
        YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
        yzj.setView(this.getView());
        if (openIds.length == 1 && !isGroupChat) {
            HashMap<String, String> mData = new HashMap<String, String>();
            mData.put(OPENID, openIds[0]);
            if (param != null) {
                mData.putAll(param);
            }
            yzj.yzjInterface("chat", mData);
        } else {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String shareParams = pageCache.get(SHAREPARAMS);
            if (StringUtils.isEmpty((String)shareParams)) {
                if (openIds.length == 1) {
                    HashMap<String, String> mData = new HashMap<String, String>();
                    mData.put(OPENID, openIds[0]);
                    yzj.yzjInterface("chat", mData);
                } else {
                    this.yzjInterfaceWithRerurn(openIds, "chat", param);
                }
            } else {
                Map shareMap = (Map)SerializationUtils.fromJsonString((String)shareParams, Map.class);
                shareMap.put("selected", Arrays.asList(openIds));
                yzj.yzjInterface("share", shareMap);
            }
        }
    }

    private void yzjInterfaceOpenChat(String[] openIds, String chattype) {
        YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
        yzj.setView(this.getView());
        HashMap<String, String> mData = new HashMap<String, String>();
        List<Map<String, Object>> userInfos = this.getUserInfos(openIds);
        if (userInfos != null && userInfos.size() > 0) {
            StringBuilder openIdsSb = new StringBuilder();
            StringBuilder namesSb = new StringBuilder();
            for (Map<String, Object> userInfo : userInfos) {
                openIdsSb.append(userInfo.get(OPENID)).append(',');
                namesSb.append(userInfo.get(USERNAME)).append(',');
            }
            mData.put(OPENID, openIdsSb.substring(0, openIdsSb.length() - 1));
            mData.put(USERNAME, namesSb.substring(0, namesSb.length() - 1));
            mData.put("chattype", chattype);
            yzj.yzjInterface("createAndChat", mData);
        }
    }

    public void yzjInterfaceWithRerurn(String[] openIds, String chattype, Map param) {
        Optional optional;
        YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
        yzj.setView(this.getView());
        HashMap<String, Object> iData = new HashMap<String, Object>();
        if (WfUtils.isNotEmptyForMap((Map)param)) {
            iData.putAll(param);
        }
        if (!(optional = Arrays.asList(openIds).stream().reduce((os, o) -> os + "," + o)).isPresent()) {
            return;
        }
        String allOpenIds = (String)optional.get();
        iData.put(OPENID, allOpenIds + ",");
        iData.put("chattype", chattype);
        iData.put("businessType", "wf");
        if (WfUtils.isEmptyString(iData.get("webpageUrl"))) {
            this.getParameterForYzjChat(iData);
            iData.put("businessKey", param.get("businessKey"));
        }
        StringBuilder businessKeyScene = new StringBuilder();
        businessKeyScene.append(iData.get("businessKey")).append(param.get(CLICKSCENE));
        iData.put("businessKey", businessKeyScene.toString());
        this.logger.info("YzjChat.yzjInterfaceWithRerurn iData:" + iData);
        Map groupIdMap = yzj.yzjInterfaceWithRerurn("createAndChat", iData);
        if (WfUtils.isNotEmpty((String)((String)groupIdMap.get("groupId")))) {
            this.saveGroupId((String)groupIdMap.get("groupId"), allOpenIds);
        }
    }

    private void getParameterForYzjChat(Map<String, Object> iData) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String procInstIdStr = pageCache.get("procInstId");
        if (WfUtils.isEmpty((String)procInstIdStr)) {
            return;
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Map parameterForYzjChat = wfService.getTaskService().getParameterForYzjChatCmd(Long.valueOf(procInstIdStr));
        if (null == parameterForYzjChat || parameterForYzjChat.isEmpty()) {
            return;
        }
        parameterForYzjChat.put("thumbUrl", PictureResourceEnum.DISCUSS_YZJ_YDSP.getValue());
        iData.putAll(parameterForYzjChat);
    }

    private void saveGroupId(String groupId, String allOpenIds) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"wf_yzjchat");
        DynamicObject yzjEntity = new DynamicObject((DynamicObjectType)type);
        yzjEntity.set("groupid", (Object)groupId);
        yzjEntity.set("billid", (Object)pageCache.get("billId"));
        yzjEntity.set(SCENE, (Object)pageCache.get(SCENE));
        yzjEntity.set("featurecode", (Object)pageCache.get("featureCode"));
        yzjEntity.set("openids", (Object)allOpenIds);
        yzjEntity.set("currenteropenid", (Object)RequestContext.get().getUserOpenId());
        yzjEntity.set("createdate", (Object)WfUtils.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yzjEntity});
    }

    private List<Map<String, Object>> getUserInfos(String[] openIds) {
        QFilter filter = new QFilter("useropenid", "in", (Object)openIds);
        QFilter[] qFilters = new QFilter[]{filter};
        String fields = "useropenid,name";
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"bos_user", (String)fields, (QFilter[])qFilters);
        ArrayList<Map<String, Object>> userInfos = new ArrayList<Map<String, Object>>(dynObjs.length);
        for (int i = 0; i < dynObjs.length; ++i) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put(OPENID, dynObjs[i].get("useropenid"));
            userInfo.put(USERNAME, dynObjs[i].get("name"));
            userInfos.add(userInfo);
        }
        return userInfos;
    }

    public static String getSelectFields() {
        return "id,groupid,billid,featurecode,scene,createdate,openids,record,currenteropenid,identitykey";
    }

    public void openPhoneChat(String[] openIds, Map param) {
        boolean isGroupChat;
        if (openIds == null || openIds.length < 1) {
            return;
        }
        YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
        yzj.setView(this.getView());
        String groupName = (String)param.get("groupName");
        boolean bl = isGroupChat = StringUtils.isEmpty((String)groupName);
        if (openIds.length == 1 && !isGroupChat) {
            HashMap<String, String> mData = new HashMap<String, String>();
            mData.put(OPENID, openIds[0]);
            yzj.yzjInterface("chat", mData);
        } else {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String shareParams = pageCache.get(SHAREPARAMS);
            if (StringUtils.isEmpty((String)shareParams)) {
                if (openIds.length == 1) {
                    HashMap<String, String> mData = new HashMap<String, String>();
                    mData.put(OPENID, openIds[0]);
                    if (param != null) {
                        mData.putAll(param);
                    }
                    yzj.yzjInterface("chat", mData);
                } else {
                    this.yzjInterfaceWithRerurn(openIds, "chat", param);
                }
            } else {
                Map shareMap = (Map)SerializationUtils.fromJsonString((String)shareParams, Map.class);
                shareMap.put("selected", Arrays.asList(openIds));
                yzj.yzjInterface("share", shareMap);
            }
        }
    }
}

