/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.configurationcenter;

import com.google.common.collect.ImmutableSet;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.message.archive.service.ArchiveApiService;
import kd.bos.message.archive.service.MessageArchiveService;
import kd.bos.message.archive.utils.MessageArchiveUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.workCalendar.WorkCalendarUtil;

public class WorkFlowConfigurationCenterPlugin
extends AbstractFormPlugin {
    public static final String DISPLAYINFO = "displayinfo";
    public static final String WFARCHIVESERVICE = "wfarchiveservice";
    public static final String ISOPENWORKCALENDAR = "isopenworkcalendar";
    public static final String WF_CONF_REPAIR_COMPLETE = "workflow.isCompleteRepairApproveDuration";
    public static final String EAS_WORKFLOW_DETAIL_URL = "easworkflowdetailurl";
    private static final Set<String> isCheckNullChangeZapSet = ImmutableSet.of((Object)"easworkflowdetailurl");

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{DISPLAYINFO});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (DISPLAYINFO.equals(key)) {
            this.showParticipantDisplaysPage();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData changeData = changeSet[0];
        Object newChgValue = changeData.getNewValue();
        Object oldChgValue = changeData.getOldValue();
        if (isCheckNullChangeZapSet.contains(propName) && (WfUtils.isEmptyString((Object)newChgValue) || Objects.equals(newChgValue, 0))) {
            this.getModel().setValue(propName, oldChgValue);
        }
        if (WFARCHIVESERVICE.equalsIgnoreCase(e.getProperty().getName())) {
            this.checkWfArchiveServiceEnable(changeSet[0].getNewValue());
        }
        if (ISOPENWORKCALENDAR.equalsIgnoreCase(e.getProperty().getName()) && ((Boolean)(value = changeSet[0].getNewValue())).booleanValue()) {
            if (!WorkCalendarUtil.getIsHavingWorkCalendarForGroup()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u6682\u672a\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386\uff0c\u529f\u80fd\u65e0\u6cd5\u542f\u7528\u3002", (String)"WorkFlowConfigurationCenterPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.getModel().setValue(ISOPENWORKCALENDAR, (Object)Boolean.FALSE);
                return;
            }
            if (!"true".equals(WfConfigurationUtil.getConfigCenterVal((String)WF_CONF_REPAIR_COMPLETE))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u672a\u4fee\u590d\u5b8c\u6210\uff0c\u6682\u4e0d\u652f\u6301\u4f7f\u7528\u5de5\u4f5c\u65e5\u5386\u3002", (String)"WorkFlowConfigurationCenterPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.getModel().setValue(ISOPENWORKCALENDAR, (Object)Boolean.FALSE);
                return;
            }
        }
    }

    private void checkWfArchiveServiceEnable(Object newValue) {
        if (newValue != null) {
            if (!((Boolean)newValue).booleanValue()) {
                MessageArchiveUtil.disableScheduleJob();
            } else {
                boolean mcPropertiesOk = Boolean.TRUE;
                String archiveEnable = System.getProperty("archive.enable");
                if (archiveEnable == null || !Boolean.parseBoolean(archiveEnable)) {
                    mcPropertiesOk = Boolean.FALSE;
                } else {
                    ArchiveApiService archiveApiService = MessageArchiveService.create().getArchiveApiService();
                    List mcDatabases = archiveApiService.getDatabase("wf_hiprocinst");
                    if (mcDatabases == null || mcDatabases.isEmpty()) {
                        mcPropertiesOk = Boolean.FALSE;
                    }
                }
                if (!mcPropertiesOk) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"MC\u4e2d\u5f52\u6863\u670d\u52a1\u672a\u542f\u52a8\uff0c\u8bf7\u5148\u5230MC\u4e2d\u8fdb\u884c\u914d\u7f6e\u3002", (String)"WorkFlowConfigurationCenterPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    this.getModel().setValue(WFARCHIVESERVICE, (Object)Boolean.FALSE);
                    return;
                }
                String tips = ResManager.loadKDString((String)"\u5f00\u542f\u5386\u53f2\u6d41\u7a0b\u5f52\u6863\u670d\u52a1\u540e\uff0c\u6d88\u606f\u4e2d\u5fc3\u7684\u4efb\u52a1\u5217\u8868\u5c06\u9ed8\u8ba4\u663e\u793a\u672a\u5f52\u6863\u6570\u636e\uff0c\u5df2\u5f52\u6863\u6570\u636e\u53ef\u901a\u8fc7\u5207\u6362\u5f52\u6863\u5e93\u65b9\u5f0f\u67e5\u8be2\u3002\u8bf7\u786e\u8ba4\uff0c\u662f\u5426\u5f00\u542f\u201c\u5386\u53f2\u6d41\u7a0b\u5f52\u6863\u670d\u52a1\u201d\uff1f", (String)"WorkFlowConfigurationCenterPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(tips, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(WFARCHIVESERVICE, (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (WFARCHIVESERVICE.equals(callBackId) && MessageBoxResult.No == result) {
            this.getModel().setValue(WFARCHIVESERVICE, (Object)Boolean.FALSE);
        }
    }

    private void showParticipantDisplaysPage() {
        Object infoValue = this.getModel().getValue(DISPLAYINFO);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DISPLAYINFO));
        parameter.setFormId("wf_participantsetting");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("value", infoValue);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (DISPLAYINFO.equals(actionId) && returnData instanceof Map) {
            Map returnDataMap = (Map)returnData;
            String value = (String)returnDataMap.get("settingValue");
            this.getModel().setValue(DISPLAYINFO, (Object)value);
        }
    }
}

