/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.batchsetting.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.batchsetting.filter.AssignParticipantPropertyFilter;
import kd.bos.workflow.design.batchsetting.filter.AuditCommentsPropertyFilter;
import kd.bos.workflow.design.batchsetting.filter.AuditPointsPropertyFilter;
import kd.bos.workflow.design.batchsetting.filter.AutoCoordinatePropertyFilter;
import kd.bos.workflow.design.batchsetting.filter.CirculatePropertyFilter;
import kd.bos.workflow.design.batchsetting.filter.ConditionRulePropertyFilter;
import kd.bos.workflow.design.batchsetting.filter.ExpireTimePropertyFilter;
import kd.bos.workflow.design.batchsetting.filter.IBatchSettingPropertyFilter;
import kd.bos.workflow.design.batchsetting.filter.PropertyFilterContext;
import kd.bos.workflow.design.batchsetting.filter.SubjectPropertyFilter;
import kd.bos.workflow.design.batchsetting.filter.TimeControlsPropertyFilter;
import kd.bos.workflow.design.plugin.model.ShareConfig;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ExpressionExtEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BatchSettingPropertyFilter {
    private Log log = LogFactory.getLog(this.getClass());
    private static Map<String, Class<? extends IBatchSettingPropertyFilter>> filterMap = new HashMap<String, Class<? extends IBatchSettingPropertyFilter>>();

    public Map<String, ShareConfig> filterProperties(String stencilType, Map<String, ShareConfig> sharedProperties, Map<String, Object> cellProperties) {
        HashMap<String, ShareConfig> sharedMap = new HashMap<String, ShareConfig>(sharedProperties.size());
        PropertyFilterContext context = new PropertyFilterContext();
        context.addExpressions(this.getProcessExpressionTemplate());
        String entityNumber = (String)BpmnModelUtil.getProperty(cellProperties, (String)"entityNumber");
        context.addExpressions(this.getEntityCommonFieldsExpression(entityNumber));
        context.addExpression("model.");
        context.setStencilType(stencilType);
        context.setCellProperties(cellProperties);
        for (Map.Entry<String, ShareConfig> entry : sharedProperties.entrySet()) {
            Object value;
            ShareConfig config = entry.getValue();
            this.renameSharedProps(config, context);
            Class<? extends IBatchSettingPropertyFilter> clazz = filterMap.get(config.getProperty());
            if (clazz == null) {
                sharedMap.put(entry.getKey(), config);
                this.log.debug(String.format("%s no filter", config.getProperty()));
                continue;
            }
            IBatchSettingPropertyFilter filter = (IBatchSettingPropertyFilter)TypesContainer.createInstance(clazz);
            if (!filter.filter(config, value = BatchSettingUtil.getPropertyValue(cellProperties, (BatchSettingProperty)config), context)) continue;
            sharedMap.put(entry.getKey(), config);
        }
        Set<String> hiddenProps = context.getHiddenProps();
        if (!hiddenProps.isEmpty()) {
            Set set = sharedMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (!hiddenProps.contains(next.getKey())) continue;
                iterator.remove();
            }
        }
        return sharedMap;
    }

    private List<String> getProcessExpressionTemplate() {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        QFilter[] filters = new QFilter[]{new QFilter("entitynumber", "=", (Object)"process"), new QFilter("expressionTemplate", "!=", (Object)" "), new QFilter("expressionTemplate", "!=", (Object)"proc"), new QFilter("expressionTemplate", "not like", (Object)"%$%")};
        List expressionExtEntities = service.getRepositoryService().findEntitiesByFilters("wf_expressionext", filters, "expressionTemplate", null);
        ArrayList<String> procTpls = new ArrayList<String>(expressionExtEntities.size());
        for (ExpressionExtEntity entity : expressionExtEntities) {
            procTpls.add(entity.getExpressionTemplate());
        }
        return procTpls;
    }

    private List<String> getEntityCommonFieldsExpression(String entityNumber) {
        ArrayList<String> fields = new ArrayList<String>(16);
        if (WfUtils.isEmpty((String)entityNumber)) {
            return fields;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (IDataEntityProperty fieldProp : entityType.getAllFields().values()) {
            if (!(fieldProp instanceof IFieldHandle) || fieldProp.getParent() != null && !entityNumber.equals(fieldProp.getParent().getName()) || fieldProp instanceof MulBasedataProp || fieldProp instanceof BasedataProp || fieldProp instanceof AttachmentProp) continue;
            fields.add(fieldProp.getName());
        }
        return fields;
    }

    private void renameSharedProps(ShareConfig config, PropertyFilterContext context) {
        if ("UserTask".equals(context.getStencilType())) {
            this.renameUserTaskSharedProps(config);
        }
    }

    private void renameUserTaskSharedProps(ShareConfig config) {
        switch (config.getProperty()) {
            case "formKey": {
                config.setPropertyName(ResManager.loadKDString((String)"PC\u7aef\u5904\u7406\u9875\u9762", (String)"WorkflowBasicInfoPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                break;
            }
            case "mobilFormKey": {
                config.setPropertyName(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5904\u7406\u9875\u9762", (String)"WorkflowBasicInfoPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    static {
        filterMap.put("subject", SubjectPropertyFilter.class);
        filterMap.put("skipCondition", ConditionRulePropertyFilter.class);
        filterMap.put("autoAuditCondition", ConditionRulePropertyFilter.class);
        filterMap.put("batchApproveCond", ConditionRulePropertyFilter.class);
        filterMap.put("batchRejectCond", ConditionRulePropertyFilter.class);
        filterMap.put("auditPoints", AuditPointsPropertyFilter.class);
        filterMap.put("expireTime", ExpireTimePropertyFilter.class);
        filterMap.put("timeControls", TimeControlsPropertyFilter.class);
        filterMap.put("autoCoordinate", AutoCoordinatePropertyFilter.class);
        filterMap.put("circulate", CirculatePropertyFilter.class);
        filterMap.put("auditComments", AuditCommentsPropertyFilter.class);
        filterMap.put("allowNextPersonSetting", AssignParticipantPropertyFilter.class);
    }
}

