/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.batchsetting.filter;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.design.batchsetting.filter.AbstractBatchSettingPropertyFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;

public class TimeControlsPropertyFilter
extends AbstractBatchSettingPropertyFilter {
    @Override
    protected boolean filter(Object value, List<String> expressions) {
        if (value instanceof List) {
            List timeControls = (List)value;
            for (Map timeControl : timeControls) {
                Map operation;
                boolean ret;
                Object expireOperation = timeControl.get("operation");
                if (!(expireOperation instanceof Map) || (ret = this.checkOperation(operation = (Map)expireOperation, expressions))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkOperation(Map<String, Object> operation, List<String> expressions) {
        String operationNumber = (String)operation.get("operationNumber");
        String configStr = (String)operation.get("config");
        if (WfUtils.isNotEmpty((String)configStr)) {
            Map config = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
            switch (operationNumber) {
                case "sendMessageExpire": {
                    return this.checksendMessageExpire(config, expressions);
                }
                case "transferExpire": {
                    return this.checkTransferExpire(config);
                }
            }
        }
        return true;
    }

    private boolean checksendMessageExpire(Map<String, Object> config, List<String> expressions) {
        String message = (String)config.get("msgContent");
        return !BatchSettingUtil.isExpressionHasNotCommonExpression((String)message, expressions);
    }

    private boolean checkTransferExpire(Map<String, Object> config) {
        String referencePerson;
        String type = (String)config.get("type");
        return !BatchSettingUtil.isParticipantReferNotCommonExpression((String)type, (String)(referencePerson = (String)config.get("referencePerson")));
    }
}

