/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.batchsetting.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.management.plugin.scheme.SelectedScheme;
import kd.bos.workflow.management.plugin.scheme.WorkflowDynamicConfigSchemePlugin;

public class WorkflowAdvancedPropSettingPlugin
extends WorkflowDynamicConfigSchemePlugin {
    private static final String LABEL_SOLUTIONCONFIG = "solutionconfig";
    private static final String BTN_SHARECONFIGTO = "shareconfigto";
    private static final String KEY_WHETHERTOSAVE = "whethertosave";
    private static final String SHARECONFIGTOPERMISSION = "1CWJCD1V3PLN";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SHARECONFIGTO});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initControlVisibility();
    }

    private void initControlVisibility() {
        if (!Lang.get().equals((Object)Lang.zh_CN)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SHARECONFIGTO});
        }
        if (!BatchSettingUtil.hasAdvancedSettingPermission()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"savebtn"});
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateSubTitleText();
    }

    private void updateSubTitleText() {
        SelectedScheme schemeInfo = this.getSelectSchemeInfo();
        Label title = (Label)this.getControl(LABEL_SOLUTIONCONFIG);
        title.setText(schemeInfo.getSchemeName());
    }

    @Override
    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (BTN_SHARECONFIGTO.equals(key)) {
            this.shareConfigTo();
        } else {
            super.click(evt);
        }
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        this.updateSubTitleText();
    }

    private void shareConfigTo() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_processinfo", (String)SHARECONFIGTOPERMISSION)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u6279\u91cf\u8bbe\u7f6e\u201d\u7684\u201c\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e\u201d\u6743\u9650\u3002", (String)"WorkflowAdvancedPropSettingPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.canNotDoOperation()) {
            this.getView().showErrorNotification(WFMultiLangConstants.getNotAdminForOperation());
            return;
        }
        boolean result = DesignerModelUtil.showFatalValidateError(this.getGraphModel().getBpmnModelJson(), this, null);
        if (result) {
            return;
        }
        StencilConfig stencilConfig = DesignerModelUtil.getStencilConfig(this.modelType, this.selectionCellType);
        if (stencilConfig == null || stencilConfig.getAdvancedSharedProps().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8282\u70b9\u6ca1\u6709\u53ef\u6279\u91cf\u8bbe\u7f6e\u7684\u5c5e\u6027\u3002", (String)"WorkflowAdvancedPropSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"WorkflowAdvancedPropSettingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_WHETHERTOSAVE));
            return;
        }
        this.showBatchSetAdvancedPropsPage();
    }

    private void showBatchSetAdvancedPropsPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wf_shareprocessconfig");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Long procDefId = (Long)this.getView().getFormShowParameter().getCustomParam("procDefId");
        showParameter.setCustomParam("procDefId", (Object)procDefId);
        showParameter.setCustomParam("modelType", (Object)this.modelType);
        showParameter.setCustomParam("stencilType", (Object)this.selectionCellType);
        GraphCell selectedCell = this.getGraphModel().getGraphCell(this.getSelectionCellId());
        showParameter.setCustomParam("cellProperties", (Object)selectedCell.getProperties());
        this.getView().showForm(showParameter);
    }

    @Override
    protected String getDesignerFormId() {
        return "wf_advancedprop_setting";
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (KEY_WHETHERTOSAVE.equals(callBackId)) {
            this.whetherToSave(e);
        } else {
            super.confirmCallBack(e);
        }
    }

    private void whetherToSave(MessageBoxClosedEvent e) {
        if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.save();
            this.showBatchSetAdvancedPropsPage();
        }
    }

    private boolean canNotDoOperation() {
        String modelJson = this.getGraphModel().getBpmnModelJson();
        JSONObject properties = JSON.parseObject((String)modelJson).getJSONObject("properties");
        Object orgUnitId = properties.get((Object)"orgUnitId");
        return !this.canDoOperation(Long.valueOf(orgUnitId.toString()));
    }
}

