/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.batchsetting.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.batchsetting.plugin.ProcessInfoInitializeTaskClick;
import kd.bos.workflow.design.plugin.model.ShareConfig;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingJobInfo;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.management.batchsetting.MutexResult;
import kd.bos.workflow.engine.management.batchsetting.task.GeneralPropertyBatchSettingTask;

public class WorkflowGeneralPropertyListPlugin
extends AbstractListPlugin {
    protected static final String BTN_SET = "btnset";
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String ENTRYENTITY_PROPERTYNAME = "propertyname";
    protected static final String ENTRYENTITY_PROPERTYVALUE = "propertyvalue";
    protected static final String ENTRYENTITY_GROUP = "group";
    protected static final String ENTRYENTITY_PROPERTY = "property";
    protected static final String ENTRYENTITY_STENCILTYPES = "stenciltypes";
    private static final String KEY_CONFIRMOPERATION = "confirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SET});
    }

    public void afterCreateNewData(EventObject e) {
        this.initGeneralPropertyList();
    }

    private void initControlVisibility() {
        if (!Lang.get().equals((Object)Lang.zh_CN)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SET});
        }
    }

    private void initGeneralPropertyList() {
        List<ShareConfig> shareInfos = DesignerModelUtil.getDomainModelSharedProperties("WorkflowModel", "general");
        int size = shareInfos.size();
        if (size < 1) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, size);
        for (int i = 0; i < size; ++i) {
            ShareConfig shareInfo = shareInfos.get(i);
            this.getModel().setValue(ENTRYENTITY_PROPERTYNAME, (Object)shareInfo.getPropertyName(), i);
            this.getModel().setValue(ENTRYENTITY_GROUP, (Object)shareInfo.getGroup(), i);
            this.getModel().setValue(ENTRYENTITY_PROPERTY, (Object)shareInfo.getProperty(), i);
            String stencilTypes = WfUtils.listToString((Collection)shareInfo.getStencilTypes(), (String)",");
            this.getModel().setValue(ENTRYENTITY_STENCILTYPES, (Object)stencilTypes, i);
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_SET.equals(key)) {
            this.setGeneralProperties();
        }
    }

    private void setGeneralProperties() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_processinfo", (String)"1CWJ9Q+=HU64")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6279\u91cf\u4fee\u6539\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowGeneralPropertyListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6279\u91cf\u8bbe\u7f6e\u7684\u6d41\u7a0b\u6216\u65b9\u6848\u3002", (String)"WorkflowGeneralPropertyListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
        boolean selected = false;
        for (DynamicObject dynamicObject : collection) {
            String value = dynamicObject.getString(ENTRYENTITY_PROPERTYVALUE);
            if ("donothing".equals(value)) continue;
            selected = true;
            break;
        }
        if (!selected) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u53ef\u5feb\u901f\u8bbe\u7f6e\u7684\u5e38\u7528\u5c5e\u6027\u201d\u4e2d\u4fee\u6539\u8981\u6279\u91cf\u8bbe\u7f6e\u7684\u5c5e\u6027\u3002", (String)"WorkflowGeneralPropertyListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u5c5e\u6027\u5c06\u88ab\u5e94\u7528\u81f3\u6240\u9009\u6d41\u7a0b\u7684\u5168\u90e8\u8282\u70b9\uff0c\u6b64\u8fc7\u7a0b\u4e2d\u6240\u9009\u6d41\u7a0b\u7684\u52a8\u6001\u914d\u7f6e\u65b9\u6848\u4e0d\u652f\u6301\u4fee\u6539\uff0c\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"WorkflowGeneralPropertyListPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_CONFIRMOPERATION));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (KEY_CONFIRMOPERATION.equals(callBackId)) {
            this.confirmSetting(e);
        }
    }

    private void confirmSetting(MessageBoxClosedEvent e) {
        if (!MessageBoxResult.Yes.equals((Object)e.getResult())) {
            return;
        }
        MutexResult result = BatchSettingUtil.requireBatchSettingMutexLock((String)"batch_setting_properties");
        if (!result.isSuccess()) {
            BatchSettingUtil.showRequireFailedTip((IFormView)this.getView(), (MutexResult)result);
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        BatchSettingProperty property = null;
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<BatchSettingProperty> properties = new ArrayList<BatchSettingProperty>(collection.size());
        for (Object dynamicObject : collection) {
            String value = dynamicObject.getString(ENTRYENTITY_PROPERTYVALUE);
            if ("donothing".equals(value)) continue;
            boolean booValue = "yes".equals(value);
            property = new BatchSettingProperty();
            property.setValue((Object)booValue);
            property.setGroup(dynamicObject.getString(ENTRYENTITY_GROUP));
            property.setProperty(dynamicObject.getString(ENTRYENTITY_PROPERTY));
            String stencilTypes = dynamicObject.getString(ENTRYENTITY_STENCILTYPES);
            property.setStencilTypes(BatchSettingUtil.getStencilTypesFormString((String)stencilTypes));
            properties.add(property);
        }
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        BatchSettingJobInfo info = new BatchSettingJobInfo();
        String title = ResManager.loadKDString((String)"\u901a\u7528\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e", (String)"WorkflowGeneralPropertyListPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        info.setName(title);
        info.setCaption(title);
        info.setTaskClassname(GeneralPropertyBatchSettingTask.class.getCanonicalName());
        info.setClickClassName(ProcessInfoInitializeTaskClick.class.getCanonicalName());
        info.putParam("ids", ids);
        info.putParam("properties", (Object)SerializationUtils.toJsonString(properties));
        BatchSettingUtil.dispatchJobFormInfo((IFormView)this.getView(), (AbstractFormPlugin)this, (BatchSettingJobInfo)info);
        WfUtils.addOpLog((String)"wf_processinfo", (String)"batchModify", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6279\u91cf\u4fee\u6539", "BatchSettingUtil_4", "bos-wf-engine"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u901a\u7528\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e", "WorkflowGeneralPropertyListPlugin_7", "bos-wf-formplugin"), (Object[])new Object[0]);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("taskcloseback".equals(actionId)) {
            this.taskCloseCallBack(e);
        } else {
            super.closedCallBack(e);
        }
    }

    private void taskCloseCallBack(ClosedCallBackEvent e) {
        boolean result = BatchSettingUtil.batchSettingTaskCloseCallBack((IFormView)this.getView(), (ClosedCallBackEvent)e);
        if (result) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"WorkflowGeneralPropertyListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }
}

