/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.batchsetting.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.batchsetting.filter.BatchSettingPropertyFilter;
import kd.bos.workflow.design.batchsetting.plugin.ProcessInfoInitializeTaskClick;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.model.ShareConfig;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingJobInfo;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.management.batchsetting.MutexResult;
import kd.bos.workflow.engine.management.batchsetting.task.AdvancedPropertyBatchSettingTask;

public class WorkflowShareProceessConfigPlugin
extends AbstractWorkflowPlugin
implements IConfirmCallBack {
    private static final String BTN_CONFIRM = "btnconfirm";
    private static final String LABEL_SUBHEADING = "subheading";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY_GROUPNAME = "groupname";
    private static final String ENTRYENTITY_SHARE = "share";
    private static final String ENTRYENTITY_GROUP = "group";
    private static final String ENTRYENTITY_PROPERTY = "property";
    private static final String ENTRYENTITY_SAMEENTITY = "sameentity";
    private static final String ENTRYENTITY_PROPERTYNAME = "propertyname";
    private static final String ENTRYENTITY_STENCILTYPES = "stenciltypes";
    private static final String PANEL_PROCESSLIST = "processlistpanel";
    private static final String KEY_NOGROUP = "noGroup";
    protected static final String KEY_ENTITYID = "entityId";
    private static final String KEY_STENCILTYPE = "stencilType";
    protected static final String KEY_FILTER_FIELD = "filterField";
    private static final String KEY_PROCLISTPAGEID = "pageId";
    protected static final String KEY_STATE_SAMEENTITY = "isSameEntity";
    private static final String KEY_OPERATION_CALLBACKID = "operationCallBack";
    private static final String KEY_CONFIRM_CALLBACKID = "confirmCallBack";
    private static final String KEY_PROPERTY_HAS_CHANGED = "hasChanged";
    private static final String PROPERTY_EXPIRETYPE = "expireType";
    private static final String PROPERTY_EXPIRETIME = "expireTime";
    private static final String PROPERTY_EXPRESSIONTYPE = "expressionType";
    private static final String PROPERTY_FIELDMODIFIED = "fieldModified";
    private static final String PROPERTY_PAGEATTRCONFIG = "pageAttrConfig";
    private static final String PROPERTY_MOBILEPAGEATTRCONFIG = "mobilePageAttrConfig";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String modelType = (String)parameter.getCustomParam("modelType");
        String stencilType = (String)parameter.getCustomParam(KEY_STENCILTYPE);
        StencilConfig stencilConfig = DesignerModelUtil.getStencilConfig(modelType, stencilType);
        Map cellProperties = (Map)parameter.getCustomParam("cellProperties");
        this.initSubHeading(cellProperties);
        this.cacheData(stencilType, cellProperties);
        this.initProcessList(stencilType);
        if (this.getView().getView(this.getPageCache().get(KEY_PROCLISTPAGEID)) == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY});
            return;
        }
        this.initSharedProperties(stencilConfig);
    }

    private void initSubHeading(Map<String, Object> cellProperties) {
        String name = (String)cellProperties.get("name");
        Label title = (Label)this.getControl(LABEL_SUBHEADING);
        title.setText(name);
    }

    private void cacheData(String stencilType, Map<String, Object> cellProperties) {
        String entityId = null;
        String filterField = null;
        if ("Diagram".equals(stencilType)) {
            filterField = "entityid.id";
            entityId = (String)cellProperties.get("entraBillId");
        } else {
            filterField = "details.activityentityid.id";
            entityId = (String)cellProperties.get(KEY_ENTITYID);
        }
        if (WfUtils.isNotEmpty((String)entityId)) {
            this.getPageCache().put(KEY_ENTITYID, entityId);
        }
        this.getPageCache().put(KEY_FILTER_FIELD, filterField);
        this.getPageCache().put(KEY_STENCILTYPE, stencilType);
    }

    private void initProcessList(String stencilType) {
        ListShowParameter showParameter = null;
        showParameter = new ListShowParameter();
        showParameter.setFormId("bos_listf7");
        showParameter.setCaption(ResManager.loadKDString((String)"\u5171\u4eab\u6d41\u7a0b\u8bbe\u8ba1\u81f3", (String)"WorkflowShareProceessConfigPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setTargetKey(PANEL_PROCESSLIST);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam("billFormId", (Object)"wf_processinfo");
        ListFilterParameter filterParameter = new ListFilterParameter();
        Long procDefId = (Long)this.getView().getFormShowParameter().getCustomParam("procDefId");
        QFilter filter = new QFilter("procdefid", "!=", (Object)procDefId);
        if ("Diagram".equals(stencilType)) {
            showParameter.setBillFormId("wf_processinfo_procshare");
        } else {
            showParameter.setBillFormId("wf_processinfo_nodeshare");
            filter.and(new QFilter("details.activitytype", "=", (Object)stencilType));
        }
        filterParameter.setFilter(filter);
        showParameter.setListFilterParameter(filterParameter);
        this.getPageCache().put(KEY_PROCLISTPAGEID, showParameter.getPageId());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void initSharedProperties(StencilConfig stencilConfig) {
        BatchSettingPropertyFilter propertyFilter = new BatchSettingPropertyFilter();
        Map cellProperties = (Map)this.getView().getFormShowParameter().getCustomParam("cellProperties");
        Map<String, ShareConfig> advSharedProps = propertyFilter.filterProperties(stencilConfig.getId(), stencilConfig.getAdvancedSharedProps(), cellProperties);
        int size = advSharedProps.size();
        HashMap<String, ArrayList<ShareConfig>> groupedProps = new HashMap<String, ArrayList<ShareConfig>>(size);
        ShareConfig config = null;
        ArrayList<ShareConfig> props = null;
        for (Map.Entry<String, ShareConfig> entry : advSharedProps.entrySet()) {
            config = entry.getValue();
            String group = config.getDisplayGroup() != null ? config.getDisplayGroup() : KEY_NOGROUP;
            props = (ArrayList<ShareConfig>)groupedProps.get(group);
            if (props == null) {
                props = new ArrayList<ShareConfig>();
                groupedProps.put(group, props);
            }
            props.add(config);
        }
        int index = 0;
        List noGroupConfigs = (List)groupedProps.get(KEY_NOGROUP);
        if (noGroupConfigs != null && !noGroupConfigs.isEmpty()) {
            size = noGroupConfigs.size();
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, size);
            for (ShareConfig noGroupConfig : noGroupConfigs) {
                this.initSharedPropertyRow(noGroupConfig, index);
                ++index;
            }
        }
        for (Map.Entry entry : groupedProps.entrySet()) {
            String key = (String)entry.getKey();
            if (KEY_NOGROUP.equals(key)) continue;
            List configs = (List)entry.getValue();
            size = configs.size();
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, size);
            for (int i = 0; i < size; ++i) {
                config = (ShareConfig)((Object)configs.get(i));
                if (i == 0) {
                    this.getModel().setValue(ENTRYENTITY_GROUPNAME, (Object)config.getGroupName(), index + i);
                }
                this.initSharedPropertyRow(config, index + i);
            }
            index += size;
        }
    }

    private void initSharedPropertyRow(ShareConfig config, int index) {
        this.getModel().setValue(ENTRYENTITY_GROUP, (Object)config.getGroup(), index);
        this.getModel().setValue(ENTRYENTITY_PROPERTY, (Object)config.getProperty(), index);
        this.getModel().setValue(ENTRYENTITY_SAMEENTITY, (Object)config.isSameEntity(), index);
        this.getModel().setValue(ENTRYENTITY_PROPERTYNAME, (Object)config.getPropertyName(), index);
        String stencilTypes = WfUtils.listToString((Collection)config.getStencilTypes(), (String)",");
        this.getModel().setValue(ENTRYENTITY_STENCILTYPES, (Object)stencilTypes, index);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        } else {
            super.click(evt);
        }
    }

    private void confirm() {
        if (!BatchSettingUtil.hasAdvancedSettingPermission()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u6279\u91cf\u8bbe\u7f6e\u201d\u7684\u201c\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e\u201d\u6743\u9650\u3002", (String)"WorkflowShareProceessConfigPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean selectedProps = false;
        int count = this.getModel().getEntryRowCount(ENTRYENTITY);
        for (int i = 0; i < count; ++i) {
            Object value = this.getModel().getValue(ENTRYENTITY_SHARE, i);
            if (!Boolean.TRUE.equals(value)) continue;
            selectedProps = true;
            break;
        }
        if (!selectedProps) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u6d41\u7a0b\u5171\u4eab\u5c5e\u6027\u201d\u4e2d\u52fe\u9009\u8981\u6279\u91cf\u8bbe\u7f6e\u7684\u5c5e\u6027\u3002", (String)"WorkflowShareProceessConfigPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<Long, List<Long>> idsMap = this.getClassifiedMap();
        if (idsMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6279\u91cf\u8bbe\u7f6e\u7684\u6d41\u7a0b\u6216\u65b9\u6848\u3002", (String)"WorkflowShareProceessConfigPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u5c5e\u6027\u5c06\u5e94\u7528\u5230\u6240\u9009\u6d41\u7a0b\u7684\u8282\u70b9\u4e2d\uff0c\u6b64\u8fc7\u7a0b\u4e2d\u6d41\u7a0b\u52a8\u6001\u914d\u7f6e\u65b9\u6848\u4e0d\u652f\u6301\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"WorkflowShareProceessConfigPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_CONFIRM_CALLBACKID));
    }

    private Map<Long, List<Long>> getClassifiedMap() {
        ArrayList<Long> ids = null;
        HashMap<Long, List<Long>> idsMap = new HashMap<Long, List<Long>>();
        String pageId = this.getPageCache().get(KEY_PROCLISTPAGEID);
        IListView listView = (IListView)this.getView().getView(pageId);
        ListSelectedRowCollection rows = listView.getSelectedRows();
        for (ListSelectedRow row : rows) {
            ids = (ArrayList<Long>)idsMap.get(row.getPrimaryKeyValue());
            if (ids == null) {
                ids = new ArrayList<Long>();
                idsMap.put((Long)row.getPrimaryKeyValue(), ids);
            }
            ids.add((Long)row.getEntryPrimaryKeyValue());
        }
        return idsMap;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        if (ENTRYENTITY_SHARE.equals(propName)) {
            this.shareCheckBoxChanged(rowIndex, newValue);
        }
    }

    private void shareCheckBoxChanged(int rowIndex, Object newValue) {
        if ("true".equals(this.getPageCache().get(KEY_PROPERTY_HAS_CHANGED))) {
            return;
        }
        try {
            this.getPageCache().put(KEY_PROPERTY_HAS_CHANGED, "true");
            this.changeGangedProperty(rowIndex, newValue);
        }
        finally {
            this.getPageCache().remove(KEY_PROPERTY_HAS_CHANGED);
        }
        int count = this.getModel().getEntryRowCount(ENTRYENTITY);
        for (int i = 0; i < count; ++i) {
            if (Boolean.FALSE.equals(this.getModel().getValue(ENTRYENTITY_SHARE, i)) || !Boolean.TRUE.equals(this.getModel().getValue(ENTRYENTITY_SAMEENTITY, i))) continue;
            this.filterSameEntityData();
            return;
        }
        this.resetFilter();
    }

    private void changeGangedProperty(int rowIndex, Object newValue) {
        String property;
        switch (property = (String)this.getModel().getValue(ENTRYENTITY_PROPERTY, rowIndex)) {
            case "expireType": 
            case "expireTime": 
            case "expressionType": {
                this.handleExpireControl(property, newValue);
                break;
            }
            case "pageAttrConfig": 
            case "mobilePageAttrConfig": {
                this.handlePageAttrConfig(property, newValue);
                break;
            }
            case "fieldModified": {
                this.handleFieldModified(newValue);
                break;
            }
            case "allowSignature": {
                this.handleSignature("forceSignature", Boolean.FALSE, newValue);
                break;
            }
            case "forceSignature": {
                this.handleSignature("allowSignature", Boolean.TRUE, newValue);
                break;
            }
        }
    }

    private void handleExpireControl(Object property, Object newValue) {
        int index1 = -1;
        int index2 = -1;
        if (PROPERTY_EXPIRETYPE.equals(property)) {
            index1 = this.getPropertyIndex(PROPERTY_EXPIRETIME);
            index2 = this.getPropertyIndex(PROPERTY_EXPRESSIONTYPE);
        } else if (PROPERTY_EXPIRETIME.equals(property)) {
            index1 = this.getPropertyIndex(PROPERTY_EXPIRETYPE);
            index2 = this.getPropertyIndex(PROPERTY_EXPRESSIONTYPE);
        } else {
            index1 = this.getPropertyIndex(PROPERTY_EXPIRETYPE);
            index2 = this.getPropertyIndex(PROPERTY_EXPIRETIME);
        }
        if (index1 > -1 && index2 > -1) {
            this.getModel().setValue(ENTRYENTITY_SHARE, newValue, index1);
            this.getModel().setValue(ENTRYENTITY_SHARE, newValue, index2);
        }
    }

    private void handlePageAttrConfig(Object property, Object newValue) {
        Map<String, Object> cellProperties;
        if (Boolean.TRUE.equals(newValue) && this.isAttrConfigHasModifyTrueItem(cellProperties = this.getCellProperties(), (String)property)) {
            int index = this.getPropertyIndex(PROPERTY_FIELDMODIFIED);
            this.getModel().setValue(ENTRYENTITY_SHARE, newValue, index);
        }
    }

    private void handleFieldModified(Object newValue) {
        if (Boolean.FALSE.equals(newValue)) {
            Map<String, Object> cellProperties = this.getCellProperties();
            this.setAttrConfigPropertyNotChecked(cellProperties, PROPERTY_PAGEATTRCONFIG);
            this.setAttrConfigPropertyNotChecked(cellProperties, PROPERTY_MOBILEPAGEATTRCONFIG);
        }
    }

    private void handleSignature(String propName, boolean isTrue, Object newValue) {
        if (Objects.equals(isTrue, newValue)) {
            int forceSignatureIdx = this.getPropertyIndex(propName);
            this.getModel().setValue(ENTRYENTITY_SHARE, (Object)isTrue, forceSignatureIdx);
        }
    }

    private void setAttrConfigPropertyNotChecked(Map<String, Object> cellProperties, String property) {
        int index;
        if (this.isAttrConfigHasModifyTrueItem(cellProperties, property) && (index = this.getPropertyIndex(property)) > -1 && Boolean.TRUE.equals(this.getModel().getValue(ENTRYENTITY_SHARE, index))) {
            this.getModel().setValue(ENTRYENTITY_SHARE, (Object)false, index);
        }
    }

    private boolean isAttrConfigHasModifyTrueItem(Map<String, Object> cellProperties, String property) {
        String path = String.format("billSetting.%s", property);
        Object value = BpmnModelUtil.getProperty(cellProperties, (String)path);
        if (value instanceof List) {
            List items = (List)value;
            for (Map item : items) {
                if (!Boolean.TRUE.equals(item.get("modify"))) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, Object> getCellProperties() {
        return (Map)this.getView().getFormShowParameter().getCustomParam("cellProperties");
    }

    private int getPropertyIndex(String property) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(ENTRYENTITY);
        for (int i = 0; i < count; ++i) {
            if (!property.equals(model.getValue(ENTRYENTITY_PROPERTY, i))) continue;
            return i;
        }
        return -1;
    }

    private void resetFilter() {
        String isSameEntity = this.getPageCache().get(KEY_STATE_SAMEENTITY);
        if (isSameEntity != null && "false".equals(isSameEntity)) {
            return;
        }
        this.getPageCache().put(KEY_STATE_SAMEENTITY, "false");
        QFilter filter = new QFilter("1", "=", (Object)1);
        this.filterListData(filter);
    }

    private void filterSameEntityData() {
        String entityId = this.getPageCache().get(KEY_ENTITYID);
        if (entityId == null) {
            return;
        }
        String isSameEntity = this.getPageCache().get(KEY_STATE_SAMEENTITY);
        if (isSameEntity != null && "true".equals(isSameEntity)) {
            return;
        }
        this.getPageCache().put(KEY_STATE_SAMEENTITY, "true");
        String filterField = this.getPageCache().get(KEY_FILTER_FIELD);
        this.filterListData(new QFilter(filterField, "=", (Object)entityId));
    }

    private void filterListData(QFilter filter) {
        String pageId = this.getPageCache().get(KEY_PROCLISTPAGEID);
        IListView listView = (IListView)this.getView().getView(pageId);
        BillList list = (BillList)listView.getControl("billlistap");
        list.setFilter(filter);
        listView.clearSelection();
        listView.updateView("billlistap");
        this.getView().sendFormAction((IFormView)listView);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        switch (callBackId = e.getCallBackId()) {
            case "operationCallBack": {
                this.getView().close();
                break;
            }
            case "confirmCallBack": {
                this.confirmSetting(e);
                break;
            }
            default: {
                super.confirmCallBack(e);
            }
        }
    }

    private void confirmSetting(MessageBoxClosedEvent e) {
        if (!MessageBoxResult.Yes.equals((Object)e.getResult())) {
            return;
        }
        MutexResult result = BatchSettingUtil.requireBatchSettingMutexLock((String)"batch_setting_properties");
        if (!result.isSuccess()) {
            BatchSettingUtil.showRequireFailedTip((IFormView)this.getView(), (MutexResult)result);
            return;
        }
        BatchSettingProperty property = null;
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<BatchSettingProperty> properties = new ArrayList<BatchSettingProperty>(collection.size());
        Map cellProperties = (Map)this.getView().getFormShowParameter().getCustomParam("cellProperties");
        for (DynamicObject dynamicObject : collection) {
            if (!dynamicObject.getBoolean(ENTRYENTITY_SHARE)) continue;
            property = new BatchSettingProperty();
            property.setGroup(dynamicObject.getString(ENTRYENTITY_GROUP));
            property.setProperty(dynamicObject.getString(ENTRYENTITY_PROPERTY));
            String stencilTypes = dynamicObject.getString(ENTRYENTITY_STENCILTYPES);
            property.setValue(BatchSettingUtil.getPropertyValue((Map)cellProperties, (BatchSettingProperty)property));
            property.setStencilTypes(BatchSettingUtil.getStencilTypesFormString((String)stencilTypes));
            properties.add(property);
            this.handleRelaOldPropertys(property, properties, cellProperties);
        }
        String stencilType = this.getPageCache().get(KEY_STENCILTYPE);
        BatchSettingJobInfo info = new BatchSettingJobInfo();
        String title = ResManager.loadKDString((String)"\u9ad8\u7ea7\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e", (String)"WorkflowShareProceessConfigPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        info.setName(title);
        info.setCaption(title);
        info.setTaskClassname(AdvancedPropertyBatchSettingTask.class.getCanonicalName());
        info.setClickClassName(ProcessInfoInitializeTaskClick.class.getCanonicalName());
        info.putParam(KEY_STENCILTYPE, (Object)stencilType);
        info.putParam("properties", (Object)SerializationUtils.toJsonString(properties));
        info.putParam("classifiedMap", this.getClassifiedMap());
        BatchSettingUtil.dispatchJobFormInfo((IFormView)this.getView(), (AbstractFormPlugin)this, (BatchSettingJobInfo)info);
        WfUtils.addOpLog((String)"wf_processinfo", (String)"propertyBatchSetting", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e", "BatchSettingUtil_5", "bos-wf-engine"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u9ad8\u7ea7\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e", "WorkflowShareProceessConfigPlugin_7", "bos-wf-formplugin"), (Object[])new Object[0]);
    }

    private void handleRelaOldPropertys(BatchSettingProperty property, List<BatchSettingProperty> properties, Map<String, Object> cellProperties) {
        if (property.getProperty().equals("pageAttrConfigModel")) {
            BatchSettingProperty relaproperty = new BatchSettingProperty();
            relaproperty.setGroup("billSetting");
            relaproperty.setProperty(PROPERTY_PAGEATTRCONFIG);
            property.setValue(BatchSettingUtil.getPropertyValue(cellProperties, (BatchSettingProperty)property));
            properties.add(relaproperty);
        } else if (property.getProperty().equals("mobilePageAttrConfigModel")) {
            BatchSettingProperty relaproperty = new BatchSettingProperty();
            relaproperty.setGroup("billSetting");
            relaproperty.setProperty(PROPERTY_MOBILEPAGEATTRCONFIG);
            property.setValue(BatchSettingUtil.getPropertyValue(cellProperties, (BatchSettingProperty)property));
            properties.add(relaproperty);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("taskcloseback".equals(actionId)) {
            this.taskCloseCallBack(e);
        } else {
            super.closedCallBack(e);
        }
    }

    private void taskCloseCallBack(ClosedCallBackEvent e) {
        boolean result = BatchSettingUtil.batchSettingTaskCloseCallBack((IFormView)this.getView(), (ClosedCallBackEvent)e);
        if (result) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"WorkflowShareProceessConfigPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String stencilType = (String)parameter.getCustomParam(KEY_STENCILTYPE);
            this.initProcessList(stencilType);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_ENTITYID);
        this.getPageCache().remove(KEY_STENCILTYPE);
        this.getPageCache().remove(KEY_FILTER_FIELD);
        this.getPageCache().remove(KEY_PROCLISTPAGEID);
        this.getPageCache().remove(KEY_STATE_SAMEENTITY);
    }
}

